/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadOnlyCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.helpers.cache.ModelCache;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.LightMarkerRegistry;
import org.polarsys.capella.common.tools.report.appenders.usage.UsageMonitoringLogger;
import org.polarsys.capella.common.tools.report.appenders.usage.util.UsageMonitoring;
import org.polarsys.capella.core.commands.preferences.service.AbstractPreferencesInitializer;
import org.polarsys.capella.core.model.handler.validation.PluggableDiagnosticianProvider;
import org.polarsys.capella.core.platform.sirius.ui.actions.CapellaActionsActivator;

public class CapellaValidateAction
extends ValidateAction {
    protected Resource _currentResource;

    public CapellaValidateAction() {
        this.eclipseResourcesUtil = new ValidateAction.EclipseResourcesUtil(){

            protected String getMarkerID() {
                return "org.polarsys.capella.core.validation.markers";
            }

            public void createMarkers(Resource resource, Diagnostic diagnostic) {
                LightMarkerRegistry.getInstance().createMarker((IResource)this.getFile(CapellaValidateAction.this._currentResource), diagnostic, this.getMarkerID());
            }

            public void deleteMarkers(Object object, boolean includeSubtypes, int depth) {
                boolean cleanup = AbstractPreferencesInitializer.getBoolean((String)"cleanPreviousValidationResults", (boolean)false);
                if (cleanup) {
                    ArrayList markers = new ArrayList(LightMarkerRegistry.getInstance().getMarkers());
                    for (IMarker marker : markers) {
                        try {
                            if (!marker.getType().equals(this.getMarkerID())) continue;
                            marker.delete();
                        }
                        catch (CoreException e) {
                            CapellaActionsActivator.getDefault().log(4, e.getMessage(), e);
                        }
                    }
                }
            }

            protected IFile getFile(Object datum) {
                Session session;
                Object derivedDatum = datum;
                if (datum instanceof EObject) {
                    Session session2 = SessionManager.INSTANCE.getSession((EObject)datum);
                    if (session2 != null) {
                        derivedDatum = session2.getSessionResource();
                    }
                } else if (datum instanceof Resource && (session = SessionManager.INSTANCE.getSession((Resource)datum)) != null) {
                    derivedDatum = session.getSessionResource();
                }
                return super.getFile(derivedDatum);
            }
        };
    }

    protected Diagnostician createDiagnostician(AdapterFactory adapterFactory, IProgressMonitor progressMonitor) {
        return new PluggableDiagnosticianProvider().getDiagnostician(adapterFactory, progressMonitor);
    }

    public void run() {
        ExecutionManager executionManager = TransactionHelper.getExecutionManager((Collection)this.selectedObjects);
        if (executionManager == null) {
            return;
        }
        if (this.domain == null) {
            this.domain = executionManager.getEditingDomain();
        }
        executionManager.execute((ICommand)new AbstractReadOnlyCommand(){

            public void run() {
                CapellaValidateAction.this.executeValidationAction();
            }
        });
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.polarsys.capella.common.tools.report.appenders.reportlogview.logview");
        }
        catch (PartInitException e) {
            CapellaActionsActivator.getDefault().log(4, e.getMessage(), e);
        }
    }

    public void executeValidationAction() {
        final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            public void run(final IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    ModelCache.enable();
                    final Diagnostic diagnostic = CapellaValidateAction.this.validate(progressMonitor);
                    shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (progressMonitor.isCanceled()) {
                                CapellaValidateAction.this.handleDiagnostic(Diagnostic.CANCEL_INSTANCE);
                            } else {
                                CapellaValidateAction.this.handleDiagnostic(diagnostic);
                            }
                        }
                    });
                }
                finally {
                    ModelCache.disable();
                    progressMonitor.done();
                }
            }
        };
        if (this.eclipseResourcesUtil != null) {
            runnableWithProgress = this.eclipseResourcesUtil.getWorkspaceModifyOperation(runnableWithProgress);
        }
        String eventName = "Validation";
        String eventContext = "";
        String addendum = "";
        try {
            UsageMonitoringLogger.getInstance().log(eventName, eventContext, UsageMonitoring.EventStatus.NONE, addendum);
            new ProgressMonitorDialog(shell).run(false, true, runnableWithProgress);
            UsageMonitoringLogger.getInstance().log(eventName, eventContext, UsageMonitoring.EventStatus.OK, addendum);
        }
        catch (Exception exception) {
            EMFEditUIPlugin.INSTANCE.log((Object)exception);
            UsageMonitoringLogger.getInstance().log(eventName, eventContext, UsageMonitoring.EventStatus.ERROR, addendum);
        }
    }

    protected void handleDiagnostic(Diagnostic diagnostic) {
        try {
            List data = diagnostic.getData();
            if (data != null && data.size() > 0) {
                for (Object object : data) {
                    if (!(object instanceof EObject)) continue;
                    this._currentResource = ((EObject)object).eResource();
                    break;
                }
            }
            super.handleDiagnostic(diagnostic);
        }
        finally {
            this._currentResource = null;
        }
    }
}

