/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.search.searchfor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.polarsys.capella.core.ui.search.searchfor.item.SearchForAttributeItem;
import org.polarsys.capella.core.ui.search.searchfor.item.SearchForClassItem;
import org.polarsys.capella.core.ui.search.searchfor.item.SearchForDiagramItem;
import org.polarsys.capella.core.ui.search.searchfor.item.SearchForItem;
import org.polarsys.capella.core.ui.search.searchfor.item.SearchForNoteItem;
import org.polarsys.kitalpha.ad.common.utils.URIHelper;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Metamodel;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.resourcereuse.model.Resource;

public class SearchForItemCache {
    private Map<String, SearchForClassItem> classID2ClassItemMap = new HashMap<String, SearchForClassItem>();
    private Map<String, SearchForClassItem> classID2DiagCategoryItemMap = new HashMap<String, SearchForClassItem>();
    private Map<String, SearchForAttributeItem> attributeName2AttributeItemMap = new HashMap<String, SearchForAttributeItem>();
    private Set<Viewpoint> viewpoints = new HashSet<Viewpoint>();
    private Map<String, Viewpoint> classID2ViewpointMap = new HashMap<String, Viewpoint>();
    private static SearchForItemCache instance;

    private SearchForItemCache() {
        this.initModelElements();
        this.initDiagramElements();
        this.initViewpointElements();
        this.initAttributes(this.classID2ClassItemMap);
        this.initAttributes(this.classID2DiagCategoryItemMap);
    }

    private void initViewpointElements() {
        ResourceSetImpl set = new ResourceSetImpl();
        Resource[] resourceArray = ViewpointManager.getAvailableViewpoints();
        int n = resourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Resource res = resourceArray[n2];
            URI uri = URIHelper.createURI((Resource)res);
            Viewpoint viewpoint = (Viewpoint)set.getEObject(uri, true);
            if (viewpoint != null) {
                this.viewpoints.add(viewpoint);
                Metamodel metamodel = viewpoint.getMetamodel();
                if (metamodel != null) {
                    for (EPackage pack : metamodel.getModels()) {
                        EPackage registeredPkg = EPackage.Registry.INSTANCE.getEPackage(pack.getNsURI());
                        if (registeredPkg == null) continue;
                        for (EClassifier eClassifier : registeredPkg.getEClassifiers()) {
                            if (!(eClassifier instanceof EClass)) continue;
                            SearchForClassItem searchForClassItem = new SearchForClassItem(eClassifier);
                            this.classID2ClassItemMap.put(searchForClassItem.getUniqueID(), searchForClassItem);
                            this.classID2ViewpointMap.put(searchForClassItem.getUniqueID(), viewpoint);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private void initModelElements() {
        for (String nsURI : EPackage.Registry.INSTANCE.keySet()) {
            EPackage ePackage;
            if (!nsURI.startsWith("http://www.polarsys.org/capella") || (ePackage = EPackage.Registry.INSTANCE.getEPackage(nsURI)) == null) continue;
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                if (!(eClassifier instanceof EClass)) continue;
                SearchForClassItem searchForClassItem = new SearchForClassItem(eClassifier);
                this.classID2ClassItemMap.put(searchForClassItem.getUniqueID(), searchForClassItem);
            }
        }
    }

    private void initDiagramElements() {
        SearchForDiagramItem diagramItem = new SearchForDiagramItem(ViewpointPackage.eINSTANCE.getDRepresentationDescriptor());
        SearchForNoteItem noteItem = new SearchForNoteItem(NotationPackage.eINSTANCE.getShape());
        this.classID2DiagCategoryItemMap.put(diagramItem.getUniqueID(), diagramItem);
        this.classID2DiagCategoryItemMap.put(noteItem.getUniqueID(), noteItem);
    }

    private void initAttributes(Map<String, SearchForClassItem> classifiers) {
        classifiers.forEach((k, classItem) -> {
            List<Object> attributes = classItem.getAttributes();
            for (Object attribute : attributes) {
                EDataType type;
                if (attribute instanceof EAttribute && ((type = ((EAttribute)attribute).getEAttributeType()) == null || type.getInstanceClass() == null || !type.getInstanceClass().equals(String.class))) continue;
                SearchForAttributeItem attributeItem = new SearchForAttributeItem();
                attributeItem.addAttribute(attribute);
                SearchForItem currentAttributeItem = this.attributeName2AttributeItemMap.putIfAbsent(attributeItem.getText(), attributeItem);
                if (!(currentAttributeItem instanceof SearchForAttributeItem)) continue;
                ((SearchForAttributeItem)currentAttributeItem).addAttribute(attribute);
            }
        });
    }

    public static SearchForItemCache getInstance() {
        if (instance == null) {
            instance = new SearchForItemCache();
        }
        return instance;
    }

    public Set<SearchForItem> getDiagramItems() {
        return new HashSet<SearchForItem>(this.classID2DiagCategoryItemMap.values());
    }

    public Set<SearchForItem> getClassItems() {
        return new HashSet<SearchForItem>(this.classID2ClassItemMap.values());
    }

    public Set<SearchForItem> getCapellaClassItems() {
        return this.classID2ClassItemMap.values().stream().filter(item -> !this.classID2ViewpointMap.containsKey(item.getUniqueID())).collect(Collectors.toSet());
    }

    public Set<SearchForItem> getAttributeItems() {
        return new HashSet<SearchForItem>(this.attributeName2AttributeItemMap.values());
    }

    public Set<SearchForItem> getAddonItems(Viewpoint vp) {
        Set vpClasses = this.classID2ViewpointMap.keySet().stream().filter(cls -> this.classID2ViewpointMap.get(cls) == vp).collect(Collectors.toSet());
        return vpClasses.stream().map(cls -> this.classID2ClassItemMap.get(cls)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public Object getClassItem(String name) {
        SearchForClassItem eCls = this.classID2ClassItemMap.get(name);
        if (eCls == null) {
            eCls = this.classID2DiagCategoryItemMap.get(name);
        }
        return eCls;
    }

    public Object getAttribute(String attributeUniqueID) {
        return this.attributeName2AttributeItemMap.get(attributeUniqueID);
    }

    public Set<SearchForItem> getAttributes(Set<Object> checkedClassItems) {
        HashSet<SearchForItem> attributeItems = new HashSet<SearchForItem>();
        for (Object item : checkedClassItems) {
            if (!(item instanceof SearchForClassItem)) continue;
            List<Object> attributes = ((SearchForClassItem)item).getAttributes();
            for (Object att : attributes) {
                Optional<SearchForAttributeItem> attOpt = this.attributeName2AttributeItemMap.values().stream().filter(attributeItem -> attributeItem.represent(att)).findFirst();
                if (!attOpt.isPresent()) continue;
                attributeItems.add(attOpt.get());
            }
        }
        return attributeItems;
    }

    public Set<Viewpoint> getViewpoints() {
        return this.viewpoints;
    }
}

