/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.libraries.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.libraries.IModelIdentifier;

public class LibraryManagerExt {
    public static Collection<IModelIdentifier> getAllUnavailableReferences(IModel referencingModel) {
        LinkedHashSet<IModelIdentifier> visited = new LinkedHashSet<IModelIdentifier>();
        ArrayList<IModelIdentifier> result = new ArrayList<IModelIdentifier>();
        LinkedList<IModel> toVisit = new LinkedList<IModel>();
        toVisit.add(referencingModel);
        while (!toVisit.isEmpty()) {
            IModel model = (IModel)toVisit.removeFirst();
            if (model == null || visited.contains(model)) continue;
            visited.add(model.getIdentifier());
            for (IModelIdentifier iModelIdentifier : model.getReferences()) {
                if (result.contains(iModelIdentifier)) continue;
                result.add(iModelIdentifier);
            }
            for (IModel iModel : model.getAvailableReferences()) {
                toVisit.add(iModel);
            }
        }
        for (IModelIdentifier identifier : visited) {
            result.remove(identifier);
        }
        return result;
    }

    public static Collection<IModel> getReferences(IModel referencingModel) {
        return referencingModel.getAvailableReferences();
    }

    public static Collection<IModel> getAllReferences(IModel referencingModel) {
        LinkedHashSet<IModel> visited = new LinkedHashSet<IModel>();
        LinkedList<IModel> toVisit = new LinkedList<IModel>();
        toVisit.add(referencingModel);
        while (!toVisit.isEmpty()) {
            IModel model = (IModel)toVisit.removeFirst();
            if (model == null || visited.contains(model)) continue;
            visited.add(model);
            toVisit.addAll(model.getAvailableReferences());
        }
        visited.remove(referencingModel);
        return visited;
    }

    public static Collection<IModel> getAllActivesReferences(IModel referencingModel) {
        LinkedList<IModel> result = new LinkedList<IModel>();
        for (IModel model : LibraryManagerExt.getAllReferences(referencingModel)) {
            if (!referencingModel.isActive(model)) continue;
            result.add(model);
        }
        return result;
    }

    public static Collection<IModel> getActivesReferences(IModel referencingModel) {
        LinkedList<IModel> result = new LinkedList<IModel>();
        for (IModel model : referencingModel.getAvailableReferences()) {
            if (!referencingModel.isActive(model)) continue;
            result.add(model);
        }
        return result;
    }
}

