/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.common.ui.SiriusTransPlugin;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.ViewpointFactory;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.sirius.ui.wizard.AirdFileCreationWizardPage;

public class ExtractRepresentationsWizard
extends Wizard {
    private static final Logger logger = ReportManagerRegistry.getInstance().subscribe("User Interface");
    private TransactionalEditingDomain domain;
    private DAnalysisSession session;
    private List<DRepresentation> representations;
    private AirdFileCreationWizardPage diagramModelFilePage;
    private Resource pickedResource;

    public ExtractRepresentationsWizard(DAnalysisSession session, TransactionalEditingDomain domain, List<DRepresentation> movableRepresentations) {
        this.domain = domain;
        this.session = session;
        this.representations = movableRepresentations;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("Extract views");
        this.setNeedsProgressMonitor(true);
    }

    protected TransactionalEditingDomain getDomain() {
        return this.domain;
    }

    public boolean performFinish() {
        this.closeRepresentations(this.representations);
        DiagramFileCreationOperation op = new DiagramFileCreationOperation();
        boolean errorCatch = false;
        errorCatch = this.createAIRDFile((IRunnableWithProgress)op, errorCatch);
        if (errorCatch) {
            return false;
        }
        DAnalysis slaveAnalysis = this.prepareNewAnalysis();
        this.moveRepresentations(slaveAnalysis);
        return true;
    }

    private void moveRepresentations(final DAnalysis slaveAnalysis) {
        IRunnableWithProgress moveReps = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                ExtractRepresentationsWizard.this.getDomain().getCommandStack().execute((Command)new RecordingCommand(ExtractRepresentationsWizard.this.getDomain()){

                    protected void doExecute() {
                        ExtractRepresentationsWizard.this.doMoveRepresentation(slaveAnalysis);
                    }

                    public boolean canUndo() {
                        return false;
                    }
                });
            }
        };
        try {
            this.getContainer().run(false, true, moveReps);
        }
        catch (InterruptedException ex) {
            logger.debug((Object)new EmbeddedMessage(ex.getMessage(), "User Interface"));
        }
        catch (InvocationTargetException ex) {
            logger.debug((Object)new EmbeddedMessage(ex.getMessage(), "User Interface"));
        }
    }

    private boolean createAIRDFile(IRunnableWithProgress op, boolean error) {
        boolean errorCatch = error;
        try {
            this.getContainer().run(false, true, op);
        }
        catch (InterruptedException e) {
            errorCatch = true;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                CoreException targetException = (CoreException)e.getTargetException();
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)"Error creating resource", null, (IStatus)targetException.getStatus());
            } else {
                SiriusTransPlugin.getPlugin().error("Error creating aird session data", e.getTargetException());
            }
            errorCatch = true;
        }
        return errorCatch;
    }

    private DAnalysis prepareNewAnalysis() {
        final DAnalysis slaveAnalysis = ViewpointFactory.eINSTANCE.createDAnalysis();
        this.domain.getCommandStack().execute((Command)new RecordingCommand(this.domain){

            protected void doExecute() {
                ExtractRepresentationsWizard.this.doPrepareNewAnalysis(slaveAnalysis);
            }

            public boolean canUndo() {
                return false;
            }
        });
        return slaveAnalysis;
    }

    private void closeRepresentations(List<DRepresentation> diagrams) {
        IEditingSession uiSession = SessionUIManager.INSTANCE.getUISession((Session)this.session);
        if (uiSession != null) {
            for (DRepresentation representation : diagrams) {
                this.closeOpenedEditor(uiSession, representation);
            }
        }
    }

    private void closeOpenedEditor(IEditingSession uiSession, DRepresentation representation) {
        DialectEditor editor = uiSession.getEditor(representation);
        if (editor != null) {
            editor.getEditorSite().getPage().closeEditor((IEditorPart)editor, false);
        }
    }

    public void addPages() {
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add("odesign");
        this.diagramModelFilePage = new AirdFileCreationWizardPage("DiagramModelFile", (IStructuredSelection)new StructuredSelection(), "aird");
        this.addPage((IWizardPage)this.diagramModelFilePage);
    }

    public Resource getCreatedResource() {
        return this.pickedResource;
    }

    protected void doMoveRepresentation(DAnalysis slaveAnalysis) {
        this.session.addReferencedAnalysis(slaveAnalysis);
        for (Resource resource : this.session.getSemanticResources()) {
            if (resource.getContents().isEmpty()) continue;
            slaveAnalysis.getSemanticResources().add((Object)new ResourceDescriptor(resource.getURI()));
        }
        for (DRepresentation representation : this.representations) {
            DRepresentationDescriptor representationDescriptor = new DRepresentationQuery(representation).getRepresentationDescriptor();
            if (representationDescriptor == null) continue;
            this.session.moveRepresentation(slaveAnalysis, representationDescriptor);
        }
    }

    protected void doCreateResource() {
        this.pickedResource = TransactionHelper.getEditingDomain((Session)this.session).getResourceSet().createResource(this.diagramModelFilePage.getURI());
    }

    protected void doPrepareNewAnalysis(DAnalysis slaveAnalysis) {
        this.pickedResource.getContents().add((Object)slaveAnalysis);
    }

    private class DiagramFileCreationOperation
    extends WorkspaceModifyOperation {
        public DiagramFileCreationOperation() {
            super(null);
        }

        protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
            ExtractRepresentationsWizard.this.doCreateResource();
        }
    }
}

