/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.common.tools.api.query.IllegalStateExceptionQuery;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.appenders.usage.UsageMonitoringLogger;
import org.polarsys.capella.common.tools.report.appenders.usage.util.UsageMonitoring;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.sirius.ui.helper.DescriptionImageDescriptorHelper;
import org.polarsys.capella.core.sirius.ui.runnable.OpenRepresentationsRunnable;

public class OpenRepresentationsAction
extends BaseSelectionListenerAction {
    private static final Logger LOGGER = ReportManagerRegistry.getInstance().subscribe("User Interface");
    private DRepresentationDescriptor descriptor;

    public OpenRepresentationsAction() {
        super("Open");
    }

    protected OpenRepresentationsAction(String name) {
        super(name);
    }

    public OpenRepresentationsAction(DRepresentationDescriptor descriptor) {
        super(descriptor.getName());
        this.descriptor = descriptor;
        RepresentationDescription description = descriptor.getDescription();
        ImageDescriptor imageDescriptor = DescriptionImageDescriptorHelper.getDescriptionImageDescriptor(description);
        this.setImageDescriptor(imageDescriptor);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        try {
            return !this.getOpenableRepresentationDescriptors(selection).isEmpty();
        }
        catch (IllegalStateException e) {
            if (new IllegalStateExceptionQuery(e).isAConnectionLostException()) {
                return false;
            }
            throw e;
        }
    }

    protected List<DRepresentationDescriptor> getOpenableRepresentationDescriptors(IStructuredSelection selection) {
        return this.getOpenableRepresentationDescriptors(RepresentationHelper.getSelectedDescriptors((Collection)selection.toList()));
    }

    protected List<DRepresentationDescriptor> getOpenableRepresentationDescriptors(Collection<DRepresentationDescriptor> elements) {
        return elements.stream().filter(RepresentationHelper::isValid).collect(Collectors.toList());
    }

    public void run() {
        List<DRepresentationDescriptor> reps = this.descriptor != null ? Collections.singletonList(this.descriptor) : this.getOpenableRepresentationDescriptors(this.getStructuredSelection());
        if (reps.isEmpty()) {
            return;
        }
        this.openRepresentations(reps);
    }

    protected void openRepresentations(Collection<DRepresentationDescriptor> descriptors) {
        String eventName = "Open Representation";
        String eventContext = "";
        String addendum = "";
        UsageMonitoringLogger.getInstance().log(eventName, eventContext, UsageMonitoring.EventStatus.NONE, addendum);
        OpenRepresentationsRunnable runnable = new OpenRepresentationsRunnable(descriptors, false);
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
        try {
            progressDialog.run(false, false, (IRunnableWithProgress)runnable);
            UsageMonitoringLogger.getInstance().log(eventName, eventContext, UsageMonitoring.EventStatus.OK, addendum);
        }
        catch (InvocationTargetException e) {
            LOGGER.debug((Object)new EmbeddedMessage(e.getMessage(), "User Interface"));
            UsageMonitoringLogger.getInstance().log(eventName, eventContext, UsageMonitoring.EventStatus.ERROR, addendum);
        }
        catch (InterruptedException e) {
            LOGGER.debug((Object)new EmbeddedMessage(e.getMessage(), "User Interface"));
            UsageMonitoringLogger.getInstance().log(eventName, eventContext, UsageMonitoring.EventStatus.ERROR, addendum);
        }
    }
}

