/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.cs.validation.interface_;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionPortExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.InterfaceExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class MDCHKFunctionPortExchangeItemAllocationConsistency
extends AbstractValidationRule {
    public IStatus validate(IValidationContext context) {
        EObject eObj = context.getTarget();
        if (eObj instanceof FunctionPort) {
            FunctionPort functionPort = (FunctionPort)eObj;
            return this.validateFunctionPort(context, functionPort);
        }
        return context.createSuccessStatus();
    }

    private IStatus validateFunctionPort(IValidationContext context, FunctionPort functionPort) {
        boolean isOk;
        Set functionPortExchangeItems = FunctionPortExt.getAllIncomingExchangeItems((FunctionPort)functionPort);
        Set components = FunctionPortExt.getAllProvidedRealizedRequiredInterfaces((FunctionPort)functionPort);
        Set<AbstractExchangeItem> exchangeItems = this.getAllExchangesInterfaceItems(components);
        boolean bl = isOk = !functionPortExchangeItems.isEmpty() && exchangeItems.isEmpty() ? false : exchangeItems.containsAll(functionPortExchangeItems);
        if (!isOk && !components.isEmpty()) {
            String FUNCTION_PREFIXE = "\"" + functionPort.getName() + "\" ( " + functionPort.eClass().getName() + " ) ";
            Component component = (Component)components.toArray()[0];
            String COMPONENT_PREFIXE = "\"" + component.getName() + "\" ( " + component.eClass().getName() + " ) ";
            return this.createFailureStatus(context, new Object[]{FUNCTION_PREFIXE, COMPONENT_PREFIXE});
        }
        return context.createSuccessStatus();
    }

    private Set<AbstractExchangeItem> getAllExchangesInterfaceItems(Set<Component> components) {
        HashSet<AbstractExchangeItem> interfacesExchangeItems = new HashSet<AbstractExchangeItem>();
        for (Component containerComponent : components) {
            List interfaces = (List)ComponentExt.getRelatedInterfaces((Component)containerComponent);
            for (Interface interfazz : interfaces) {
                Set interfaceExchangeItems = (Set)InterfaceExt.getAllExchangeItems((Interface)interfazz);
                interfacesExchangeItems.addAll(interfaceExchangeItems);
            }
        }
        return interfacesExchangeItems;
    }
}

