/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.information;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.AbstractExchangeItemPkg;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.ExchangeItemRealization;
import org.polarsys.capella.core.data.information.Service;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.helpers.AbstractExchangeItemPkgExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class GetAvailable_Service_ExchangeItemRealization
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        List<CapellaElement> availableElements = this.getAvailableElements(capellaElement);
        return availableElements;
    }

    public List<CapellaElement> getAvailableElements(CapellaElement element) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>();
        SystemEngineering systemEngineering = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ExtensibleElement)element);
        if (systemEngineering == null) {
            return availableElements;
        }
        if (element instanceof Service) {
            Service service = (Service)element;
            availableElements.addAll(this.getRule_MQRY_Service_ItemRealization_11(systemEngineering, service));
        }
        return availableElements;
    }

    private List<CapellaElement> getRule_MQRY_Service_ItemRealization_11(SystemEngineering systemEng, Service currentProperty) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        BlockArchitecture arch = null;
        arch = SystemEngineeringExt.getRootBlockArchitecture((ModelElement)currentProperty);
        availableElements.addAll(this.getElementsFromBlockArchitecture(arch, currentProperty));
        if (!(arch instanceof OperationalAnalysis)) {
            availableElements.addAll(this.getRule_MQRY_Service_ItemRealization_11_1(systemEng, currentProperty));
        }
        return availableElements;
    }

    private List<CapellaElement> getElementsFromBlockArchitecture(BlockArchitecture arch, Service currentProperty) {
        DataPkg ownedDataPkg;
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        if (arch != null && (ownedDataPkg = arch.getOwnedDataPkg()) != null) {
            availableElements.addAll(AbstractExchangeItemPkgExt.getAllAbstractExchangeItems((AbstractExchangeItemPkg)ownedDataPkg));
            EList ownedExchangeItemRealisation = currentProperty.getOwnedExchangeItemRealizations();
            for (ExchangeItemRealization exchangeItemRealisation : ownedExchangeItemRealisation) {
                TraceableElement targetElement = exchangeItemRealisation.getTargetElement();
                if (targetElement == null || !(targetElement instanceof AbstractExchangeItem)) continue;
                availableElements.remove(targetElement);
            }
        }
        return availableElements;
    }

    private List<CapellaElement> getRule_MQRY_Service_ItemRealization_11_1(SystemEngineering systemEng, Service currentProperty) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        BlockArchitecture arch = null;
        arch = SystemEngineeringExt.getRootBlockArchitecture((ModelElement)currentProperty);
        SystemEngineering sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ExtensibleElement)currentProperty);
        OperationalAnalysis oa = SystemEngineeringExt.getOwnedOperationalAnalysis((SystemEngineering)sysEng);
        if (oa != null) {
            availableElements.addAll(this.getElementsFromBlockArchitecture((BlockArchitecture)oa, currentProperty));
        } else {
            SystemAnalysis ca = SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)sysEng);
            availableElements.addAll(this.getElementsFromBlockArchitecture((BlockArchitecture)ca, currentProperty));
        }
        if (arch != null) {
            if (oa != null && arch instanceof LogicalArchitecture || arch instanceof PhysicalArchitecture || arch instanceof EPBSArchitecture) {
                SystemAnalysis ctxArch = SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)sysEng);
                availableElements.addAll(this.getElementsFromBlockArchitecture((BlockArchitecture)ctxArch, currentProperty));
            }
            if (arch instanceof PhysicalArchitecture || arch instanceof EPBSArchitecture) {
                LogicalArchitecture logArch = SystemEngineeringExt.getOwnedLogicalArchitecture((SystemEngineering)sysEng);
                availableElements.addAll(this.getElementsFromBlockArchitecture((BlockArchitecture)logArch, currentProperty));
            }
            if (arch instanceof EPBSArchitecture) {
                PhysicalArchitecture physArch = SystemEngineeringExt.getOwnedPhysicalArchitecture((SystemEngineering)sysEng);
                availableElements.addAll(this.getElementsFromBlockArchitecture((BlockArchitecture)physArch, currentProperty));
            }
        }
        return availableElements;
    }
}

