/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.information;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.libraries.ILibraryManager;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.libraries.manager.LibraryManagerExt;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.ExtendingQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.business.queries.queries.information.GetAvailable_PhysicalQuantity_Unit;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.Unit;
import org.polarsys.capella.core.data.information.datatype.PhysicalQuantity;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.queries.QueryExt;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.DataPkgExt;
import org.polarsys.capella.core.model.utils.ListExt;

@ExtendingQuery(extendingQuery=GetAvailable_PhysicalQuantity_Unit.class)
public class GetAvailable_PhysicalQuantity_Unit__Lib
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        List<EObject> availableElements = this.getAvailableElements(capellaElement);
        return availableElements;
    }

    public List<EObject> getAvailableElements(CapellaElement element) {
        ArrayList<EObject> availableElements = new ArrayList();
        BlockArchitecture currentBlock = BlockArchitectureExt.getRootBlockArchitecture((EObject)element);
        IModel currentProject = ILibraryManager.INSTANCE.getModel((EObject)element);
        if (element instanceof PhysicalQuantity) {
            PhysicalQuantity currentElement = (PhysicalQuantity)element;
            Collection libraries = LibraryManagerExt.getAllActivesReferences((IModel)currentProject);
            for (IModel library : libraries) {
                BlockArchitecture correspondingBlock = (BlockArchitecture)QueryExt.getCorrespondingElementInLibrary((EObject)currentBlock, (CapellaModel)((CapellaModel)library));
                for (BlockArchitecture blockArchitecture : BlockArchitectureExt.getAllAllocatedArchitectures((BlockArchitecture)correspondingBlock)) {
                    availableElements.addAll(this.getElementsFromBlockArchitecture(blockArchitecture, currentElement.getUnit()));
                }
            }
        }
        availableElements = ListExt.removeDuplicates(availableElements);
        return availableElements;
    }

    private List<CapellaElement> getElementsFromBlockArchitecture(BlockArchitecture arch, Unit link) {
        DataPkg dataPkg;
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        if (arch != null && (dataPkg = DataPkgExt.getDataPkgOfBlockArchitecture((BlockArchitecture)arch)) != null) {
            for (Unit unit : DataPkgExt.getAllUnits((DataPkg)dataPkg)) {
                availableElements.add((CapellaElement)unit);
            }
        }
        return availableElements;
    }
}

