/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.utils.saxparser;

import java.io.StringReader;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.model.utils.NamingHelper;
import org.polarsys.capella.core.model.utils.saxparser.SaxParserHelper;
import org.polarsys.kitalpha.emde.model.Element;
import org.polarsys.kitalpha.richtext.widget.tools.utils.MDERichTextToolsHelper;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WriteCapellaElementDescriptionSAXParser {
    protected Logger logger = ReportManagerRegistry.getInstance().subscribe("Model Validation");
    protected StringBuilder description = null;
    protected StringBuilder currentElementDescription = null;

    protected String getName(EObject object) {
        return NamingHelper.getElementName(object);
    }

    protected boolean managedObject(EObject object) {
        return object instanceof Element || object instanceof DRepresentation || object instanceof DRepresentationDescriptor;
    }

    private String getDescription(EObject object) {
        if (object instanceof CapellaElement) {
            return ((CapellaElement)object).getDescription();
        }
        if (object instanceof DRepresentationDescriptor) {
            return ((DRepresentationDescriptor)object).getDocumentation();
        }
        return null;
    }

    private void setDescription(EObject object, String description) {
        if (object instanceof CapellaElement) {
            ((CapellaElement)object).setDescription(description);
        }
        if (object instanceof DRepresentationDescriptor) {
            ((DRepresentationDescriptor)object).setDocumentation(description);
        }
    }

    public boolean updateDescription(List<EObject> modelElements, final String linkId) {
        for (final EObject object : modelElements) {
            String elementDescription;
            if (!(object instanceof CapellaElement) && !(object instanceof DRepresentationDescriptor) || (elementDescription = this.getDescription(object)) == null || elementDescription.isEmpty()) continue;
            this.currentElementDescription = new StringBuilder();
            this.description = new StringBuilder();
            elementDescription = SaxParserHelper.escapeSpecialCharacter(elementDescription);
            this.currentElementDescription.append("<rootSAX>");
            this.currentElementDescription.append(elementDescription);
            this.currentElementDescription.append("</rootSAX>");
            SAXParser saxParser = null;
            StringReader reader = null;
            try {
                try {
                    SAXParserFactory saxFactory = SAXParserFactory.newInstance();
                    saxFactory.setValidating(false);
                    saxParser = saxFactory.newSAXParser();
                    saxParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                    saxParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                    DefaultHandler handler = new DefaultHandler(){
                        EObject elementFound = null;
                        boolean valueToAdd = false;
                        StringBuilder elementValue = new StringBuilder();
                        String elementId;

                        @Override
                        public void characters(char[] ch, int start, int length) throws SAXException {
                            this.valueToAdd = true;
                            this.elementValue.append(new String(ch, start, length));
                        }

                        @Override
                        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                            if (this.valueToAdd) {
                                WriteCapellaElementDescriptionSAXParser.this.description.append(this.elementValue.toString());
                                this.valueToAdd = false;
                            }
                            this.elementValue = new StringBuilder(0);
                            if (qName.equals("br")) {
                                return;
                            }
                            WriteCapellaElementDescriptionSAXParser.this.description.append("<");
                            WriteCapellaElementDescriptionSAXParser.this.description.append(qName);
                            if (attributes.getLength() == 0) {
                                WriteCapellaElementDescriptionSAXParser.this.description.append(">");
                            } else {
                                int i = 0;
                                while (i < attributes.getLength()) {
                                    EObject eObject;
                                    String attValue = attributes.getValue(i);
                                    String attName = attributes.getQName(i);
                                    if (attValue != null && !attValue.isEmpty() && qName.equalsIgnoreCase("a") && attName.equalsIgnoreCase("href") && WriteCapellaElementDescriptionSAXParser.this.managedObject(eObject = SaxParserHelper.getEObjectFromHrefAttribute(object, attValue))) {
                                        this.elementFound = eObject;
                                        this.elementId = attValue.replace("hlink://", "");
                                    }
                                    WriteCapellaElementDescriptionSAXParser.this.description.append(" ");
                                    WriteCapellaElementDescriptionSAXParser.this.description.append(attName);
                                    WriteCapellaElementDescriptionSAXParser.this.description.append("=");
                                    WriteCapellaElementDescriptionSAXParser.this.description.append("\"");
                                    WriteCapellaElementDescriptionSAXParser.this.description.append(attValue);
                                    WriteCapellaElementDescriptionSAXParser.this.description.append("\"");
                                    ++i;
                                }
                                if (qName.equals("img")) {
                                    WriteCapellaElementDescriptionSAXParser.this.description.append("/");
                                }
                                WriteCapellaElementDescriptionSAXParser.this.description.append(">");
                            }
                        }

                        @Override
                        public void endElement(String uri, String localName, String qName) throws SAXException {
                            if (qName.equals("img")) {
                                return;
                            }
                            if (qName.equals("br")) {
                                WriteCapellaElementDescriptionSAXParser.this.description.append("<br />");
                                return;
                            }
                            if (this.valueToAdd) {
                                this.valueToAdd = false;
                                boolean flag = false;
                                String value = this.elementValue.toString();
                                if (this.elementFound != null) {
                                    String name = WriteCapellaElementDescriptionSAXParser.this.getName(this.elementFound);
                                    name = StringEscapeUtils.escapeHtml((String)name);
                                    if (!(name = MDERichTextToolsHelper.encodeWhiteSpaces((String)name)).equals(value) && !this.elementId.isEmpty() && this.elementId.equals(linkId) && WriteCapellaElementDescriptionSAXParser.this.managedObject(this.elementFound)) {
                                        flag = true;
                                        WriteCapellaElementDescriptionSAXParser.this.description.append(name);
                                    }
                                    this.elementFound = null;
                                }
                                if (!flag) {
                                    WriteCapellaElementDescriptionSAXParser.this.description.append(value);
                                }
                            }
                            WriteCapellaElementDescriptionSAXParser.this.description.append("</");
                            WriteCapellaElementDescriptionSAXParser.this.description.append(qName);
                            WriteCapellaElementDescriptionSAXParser.this.description.append(">");
                            this.elementValue = new StringBuilder(0);
                            this.elementId = "";
                        }
                    };
                    InputSource is = new InputSource();
                    reader = new StringReader(this.currentElementDescription.toString());
                    is.setCharacterStream(reader);
                    saxParser.parse(is, handler);
                }
                catch (Exception exception) {
                    this.logger.error((Object)("Exception while quick fix : " + exception.toString()));
                    if (reader != null) {
                        reader.close();
                    }
                    if (saxParser != null) {
                        saxParser.reset();
                    }
                    return false;
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (saxParser != null) {
                    saxParser.reset();
                }
            }
            String result = this.description.toString().replaceAll("<rootSAX>", "");
            result = result.replaceAll("</rootSAX>", "");
            this.setDescription(object, result);
        }
        return true;
    }
}

