/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.utils;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.cs.delegates.PartNamingHelper;
import org.polarsys.capella.core.data.helpers.cs.services.CompositeStructureNamingHelper;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionalAnalysisNamingHelper;
import org.polarsys.capella.core.data.helpers.information.services.DataValueNamingHelper;
import org.polarsys.capella.core.data.helpers.information.services.InformationNamingHelper;
import org.polarsys.capella.core.data.helpers.interaction.services.InteractionNamingHelper;
import org.polarsys.capella.core.data.information.Operation;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.utils.Messages;

public class NamingHelper {
    private NamingHelper() {
    }

    public static String getDefaultTitle(EObject modelElement) {
        String name = null;
        String title = NamingHelper.getTitleLabel(modelElement);
        name = modelElement instanceof AbstractNamedElement ? ((AbstractNamedElement)modelElement).getName() : EObjectLabelProviderHelper.getText((Object)modelElement);
        if (title.length() > 0 && name != null) {
            title = String.valueOf(title) + " ";
        }
        title = String.valueOf(title) + (name == null ? "" : name);
        return title;
    }

    public static String getTitleLabel(EObject modelElement) {
        StringBuilder builder = new StringBuilder();
        String metaclassLabel = EObjectLabelProviderHelper.getMetaclassLabel((EObject)modelElement, (boolean)true);
        if (metaclassLabel != null) {
            builder.append(metaclassLabel);
        }
        if (modelElement instanceof Component && ComponentExt.isActor((Component)modelElement)) {
            builder.append("[Actor]");
        }
        if (modelElement instanceof PhysicalComponent) {
            String nature = ((PhysicalComponent)modelElement).getNature().getName();
            builder.append("[" + NamingHelper.capitalize(nature) + "]");
        }
        return builder.toString();
    }

    public static String getTextForResource(IResource resource) {
        IContainer parent = resource.getParent();
        if (parent != null && parent.getType() != 8) {
            return String.valueOf(resource.getName()) + " - " + parent.getFullPath();
        }
        return resource.getName();
    }

    public static String getValue(EObject element, EStructuralFeature feature) {
        IItemLabelProvider labelProvider;
        if (element instanceof DataValue) {
            return DataValueNamingHelper.getValue((DataValue)((DataValue)element), (EStructuralFeature)feature);
        }
        if (element instanceof Part) {
            return PartNamingHelper.getValue((Part)((Part)element));
        }
        if (element instanceof Property) {
            return InformationNamingHelper.getValue((Property)((Property)element));
        }
        if (element instanceof Operation) {
            return InformationNamingHelper.getValue((Operation)((Operation)element));
        }
        if (element instanceof SequenceMessage) {
            return InteractionNamingHelper.getValue((SequenceMessage)((SequenceMessage)element));
        }
        if (element instanceof FunctionalExchange) {
            return FunctionalAnalysisNamingHelper.getValue((FunctionalExchange)((FunctionalExchange)element));
        }
        if (element instanceof ExchangeItemAllocation) {
            return CompositeStructureNamingHelper.getValue((ExchangeItemAllocation)((ExchangeItemAllocation)element));
        }
        if (element instanceof AbstractNamedElement && !(element instanceof ConfigurationItem)) {
            String name = ((AbstractNamedElement)element).getName();
            if (name == null || "".equals(name)) {
                return MessageFormat.format(Messages.getString("UnnamedValue"), element.eClass().getName());
            }
            return name;
        }
        AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)element);
        if (editingDomain != null && (labelProvider = (IItemLabelProvider)editingDomain.getAdapterFactory().adapt((Notifier)element, IItemLabelProvider.class)) != null) {
            return labelProvider.getText((Object)element);
        }
        return Messages.getString("UndefinedValue");
    }

    public static String getDefaultMessage(EObject currentObject, String editedPropertyName) {
        String message = "Select " + editedPropertyName;
        if (currentObject instanceof AbstractNamedElement) {
            String name = ((AbstractNamedElement)currentObject).getName();
            message = String.valueOf(message) + " of " + currentObject.eClass().getName() + " \"" + (name == null ? "" : name) + "\".";
        }
        return message;
    }

    public static String toString(Collection<NamedElement> elements) {
        Assert.isLegal((elements != null ? 1 : 0) != 0);
        StringBuilder builder = new StringBuilder();
        Iterator<NamedElement> iterator = elements.iterator();
        while (iterator.hasNext()) {
            builder.append(iterator.next().getName());
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public static String capitalize(String str) {
        if (str.length() == 0) {
            return str;
        }
        return String.valueOf(str.substring(0, 1).toUpperCase()) + str.substring(1).toLowerCase();
    }

    public static void synchronizeName(AbstractNamedElement element, String value) {
        if (element != null && !StringUtils.equals((String)element.getName(), (String)value)) {
            element.setName(value);
        }
    }

    public static String getElementName(EObject object) {
        String result = null;
        if (object != null) {
            result = CapellaElementExt.getName(object);
            if (object instanceof DRepresentation) {
                DRepresentation res = (DRepresentation)object;
                object = RepresentationHelper.getRepresentationDescriptor((DRepresentation)res);
            }
            if (object instanceof DRepresentationDescriptor) {
                result = ((DRepresentationDescriptor)object).getName();
            }
        }
        return result;
    }
}

