/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers.graph;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalPath;
import org.polarsys.capella.core.data.cs.PhysicalPathInvolvement;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.model.helpers.PhysicalPathExt;
import org.polarsys.capella.core.model.helpers.graph.Graph;
import org.polarsys.capella.core.model.helpers.graph.GraphEdge;
import org.polarsys.capella.core.model.helpers.graph.GraphNode;
import org.polarsys.capella.core.model.helpers.graph.PhysicalPathInvolvementLink;

public class PhysicalPathInvolvementGraph
extends Graph<PhysicalPath, PhysicalPathInvolvement, PhysicalPathInvolvementLink, InvolvementNode, InvolvementEdge> {
    public PhysicalPathInvolvementGraph(PhysicalPath path) {
        super(path);
        for (PhysicalPathInvolvement inv : PhysicalPathExt.getFlatInvolvements(path)) {
            if (inv.getInvolved() instanceof Component) {
                this.getOrCreateNode(inv);
                continue;
            }
            if (!(inv.getInvolved() instanceof PhysicalLink)) continue;
            for (PhysicalPathInvolvement source : PhysicalPathExt.getFlatPreviousPhysicalPathInvolvements(inv)) {
                for (PhysicalPathInvolvement target : PhysicalPathExt.getFlatNextPhysicalPathInvolvements(inv)) {
                    PhysicalPathInvolvementLink ppInvLink = new PhysicalPathInvolvementLink(inv, source, target);
                    if (this.hasEdge(ppInvLink)) continue;
                    InvolvementEdge invEdge = (InvolvementEdge)this.getOrCreateEdge(ppInvLink);
                    invEdge.setSource((InvolvementNode)this.getOrCreateNode(source));
                    invEdge.setTarget((InvolvementNode)this.getOrCreateNode(target));
                }
            }
        }
    }

    public boolean isInvolvingPhysicalLink(InvolvementEdge edge) {
        PhysicalPathInvolvementLink semantic = (PhysicalPathInvolvementLink)edge.getSemantic();
        return semantic != null && semantic.getInvolvement().getInvolved() instanceof PhysicalLink;
    }

    public PhysicalLink getInvolvedPhysicalLink(InvolvementEdge edge) {
        PhysicalPathInvolvementLink semantic = (PhysicalPathInvolvementLink)edge.getSemantic();
        if (semantic != null) {
            return (PhysicalLink)semantic.getInvolvement().getInvolved();
        }
        return null;
    }

    public static Set<PhysicalPort> getInvolvedPhysicalPorts(InvolvementEdge edge) {
        PhysicalPathInvolvementLink semantic = (PhysicalPathInvolvementLink)edge.getSemantic();
        if (semantic != null) {
            PhysicalLink pl = (PhysicalLink)semantic.getInvolvement().getInvolved();
            return new HashSet<PhysicalPort>(Arrays.asList(pl.getSourcePhysicalPort(), pl.getTargetPhysicalPort()));
        }
        return Collections.emptySet();
    }

    public static boolean containsPort(InvolvementNode node, PhysicalPort port) {
        PhysicalPathInvolvement semantic = (PhysicalPathInvolvement)node.getSemantic();
        if (semantic != null) {
            return semantic.getInvolvedComponent().getContainedPhysicalPorts().contains((Object)port);
        }
        return false;
    }

    public static PhysicalPort getInvolvedPhysicalPort(InvolvementEdge edge, InvolvementNode node) {
        for (PhysicalPort port : PhysicalPathInvolvementGraph.getInvolvedPhysicalPorts(edge)) {
            if (!PhysicalPathInvolvementGraph.containsPort(node, port)) continue;
            return port;
        }
        return null;
    }

    @Override
    public InvolvementNode createNode(PhysicalPathInvolvement semantic) {
        return new InvolvementNode(semantic);
    }

    @Override
    public InvolvementEdge createEdge(PhysicalPathInvolvementLink semantic) {
        return new InvolvementEdge(semantic);
    }

    public class InvolvementEdge
    extends GraphEdge<PhysicalPathInvolvementLink, InvolvementNode> {
        public InvolvementEdge(PhysicalPathInvolvementLink semantic) {
            super(semantic);
        }
    }

    public class InvolvementNode
    extends GraphNode<PhysicalPathInvolvement, InvolvementEdge> {
        public InvolvementNode(PhysicalPathInvolvement semantic) {
            super(semantic);
        }
    }
}

