/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers.graph;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalPath;
import org.polarsys.capella.core.data.cs.PhysicalPathInvolvement;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.model.helpers.graph.Graph;
import org.polarsys.capella.core.model.helpers.graph.GraphEdge;
import org.polarsys.capella.core.model.helpers.graph.GraphNode;
import org.polarsys.capella.core.model.helpers.graph.PhysicalPathInternalLink;
import org.polarsys.capella.core.model.helpers.graph.PhysicalPathInvolvementGraph;

public class PhysicalPathInternalLinksGraph
extends Graph<PhysicalPath, PhysicalPort, PhysicalPathInternalLink, InternalLinkNode, InternalLinkEdge> {
    public PhysicalPathInternalLinksGraph(PhysicalPathInvolvementGraph involvementGraph) {
        super((PhysicalPath)involvementGraph.getSemantic());
        for (PhysicalPathInvolvementGraph.InvolvementEdge edge : involvementGraph.getEdges().values()) {
            InternalLinkEdge newEdge;
            InternalLinkNode connectedPortNode;
            if (!involvementGraph.isInvolvingPhysicalLink(edge)) continue;
            PhysicalLink pl = involvementGraph.getInvolvedPhysicalLink(edge);
            InternalLinkNode firstPortNode = (InternalLinkNode)this.getOrCreateNode(pl.getSourcePhysicalPort());
            InternalLinkNode secondPortNode = (InternalLinkNode)this.getOrCreateNode(pl.getTargetPhysicalPort());
            for (PhysicalPort connectedPort : this.getConnectedPorts(firstPortNode, edge)) {
                connectedPortNode = (InternalLinkNode)this.getOrCreateNode(connectedPort);
                if (this.hasInternalLink((EObject)firstPortNode.getSemantic(), (EObject)connectedPort)) continue;
                newEdge = (InternalLinkEdge)this.getOrCreateEdge(new PhysicalPathInternalLink((PhysicalPort)firstPortNode.getSemantic(), connectedPort));
                newEdge.setSource(firstPortNode);
                newEdge.setTarget(connectedPortNode);
            }
            for (PhysicalPort connectedPort : this.getConnectedPorts(secondPortNode, edge)) {
                connectedPortNode = (InternalLinkNode)this.getOrCreateNode(connectedPort);
                if (this.hasInternalLink((EObject)secondPortNode.getSemantic(), (EObject)connectedPort)) continue;
                newEdge = (InternalLinkEdge)this.getOrCreateEdge(new PhysicalPathInternalLink((PhysicalPort)secondPortNode.getSemantic(), connectedPort));
                newEdge.setSource(secondPortNode);
                newEdge.setTarget(connectedPortNode);
            }
        }
    }

    public Set<PhysicalPort> getConnectedPorts(InternalLinkNode portNode, PhysicalPathInvolvementGraph.InvolvementEdge edge) {
        Optional<PhysicalPathInvolvementGraph.InvolvementNode> containerNodeOpt = edge.getConnectedNodes().stream().filter(node -> ((PhysicalPathInvolvement)node.getSemantic()).getInvolvedComponent().getContainedPhysicalPorts().contains(portNode.getSemantic())).findFirst();
        if (containerNodeOpt.isPresent()) {
            PhysicalPathInvolvementGraph.InvolvementNode containerNode = containerNodeOpt.get();
            return containerNode.getConnectedEdges().stream().filter(otherEdge -> otherEdge != edge).map(e -> PhysicalPathInvolvementGraph.getInvolvedPhysicalPort(e, containerNode)).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public boolean hasInternalLink(EObject source, EObject target) {
        return this.edges.keySet().stream().filter(PhysicalPathInternalLink.class::isInstance).map(PhysicalPathInternalLink.class::cast).anyMatch(key -> key.getSource() == source && key.getTarget() == target || key.getTarget() == source && key.getSource() == target);
    }

    @Override
    public InternalLinkNode createNode(PhysicalPort semantic) {
        return new InternalLinkNode(semantic);
    }

    @Override
    public InternalLinkEdge createEdge(PhysicalPathInternalLink semantic) {
        return new InternalLinkEdge(semantic);
    }

    public class InternalLinkEdge
    extends GraphEdge<PhysicalPathInternalLink, InternalLinkNode> {
        public InternalLinkEdge(PhysicalPathInternalLink semantic) {
            super(semantic);
        }
    }

    public class InternalLinkNode
    extends GraphNode<PhysicalPort, InternalLinkEdge> {
        public InternalLinkNode(PhysicalPort semantic) {
            super(semantic);
        }
    }
}

