/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.richtext.widget.tools.dialogs;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.polarsys.kitalpha.richtext.common.util.MDERichTextHelper;
import org.polarsys.kitalpha.richtext.widget.tools.dialogs.IEncodedURLHandler;
import org.polarsys.kitalpha.richtext.widget.tools.dialogs.MDEOkCancelDialog;
import org.polarsys.kitalpha.richtext.widget.tools.manager.LinkManager;
import org.polarsys.kitalpha.richtext.widget.tools.messages.Messages;
import org.polarsys.kitalpha.richtext.widget.tools.utils.Tuple;

public class MDELinkDialog
extends MDEOkCancelDialog
implements IEncodedURLHandler {
    protected Text urlText;
    protected String basePath;
    protected Composite composite;
    protected Label urlLabel;
    protected Text urlDisplayNameText;
    protected Label urlDisplayNameLabel;
    protected Combo linkTypeCombo;
    protected Button browseButton;
    protected String linkType;
    protected LinkManager linkManager;
    protected Composite informationArea;
    protected Label messageImageLabel1;
    protected Label messageLabel1;
    protected EObject element;
    protected String defaultLabel;
    protected String encodedURL;
    protected String dialogName;

    public MDELinkDialog(Shell parentShell, EObject element, String defaultLabel, LinkManager linkManager) {
        super(parentShell);
        this.linkManager = linkManager;
        this.element = element;
        this.defaultLabel = defaultLabel;
        this.basePath = MDERichTextHelper.getProjectPath((EObject)element);
    }

    public MDELinkDialog(Shell parentShell, EObject element, String defaultLabel, String dialogName, LinkManager linkManager) {
        this(parentShell, element, defaultLabel, linkManager);
        this.dialogName = dialogName;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite mainComposite = (Composite)super.createDialogArea(parent);
        mainComposite.setLayout((Layout)new GridLayout());
        Composite composite = new Composite(mainComposite, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        this.createUrlLabel(composite);
        this.createDisplayTextURL(composite);
        this.createListLinksType(composite);
        this.createBrowserButton(composite);
        this.updateButtonsState();
        String selectedText = this.getDefaultLabel();
        if (selectedText != null) {
            this.urlDisplayNameText.setText(selectedText);
        }
        this.createMessagePart(mainComposite);
        super.getShell().setText(this.getDialogName());
        return composite;
    }

    protected void createMessagePart(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.messageImageLabel1 = new Label(composite, 0);
        this.messageImageLabel1.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
        this.messageLabel1 = new Label(composite, 64);
        this.messageLabel1.setText("Choice not recommended if you want to share information and collaborate.\nUse URL link instead.");
        this.updateHeaderMessages();
    }

    protected void updateHeaderMessages() {
        String selectedItem = this.linkTypeCombo.getItem(this.linkTypeCombo.getSelectionIndex());
        boolean displayWarning = "File (absolute path) (not recommended)".equals(selectedItem) || "File (project relative path) (not recommended)".equals(selectedItem);
        this.messageImageLabel1.setVisible(displayWarning);
        this.messageLabel1.setVisible(displayWarning);
        this.getShell().layout(true, true);
    }

    private void createBrowserButton(Composite composite) {
        this.browseButton = new Button(composite, 8);
        this.browseButton.setLayoutData((Object)new GridData());
        this.browseButton.setText(Messages.RichTextWidget_Dialog_Add_Link_Browse);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Tuple<String, String> path = null;
                path = MDELinkDialog.this.linkManager.getURI(MDELinkDialog.this.linkType, MDELinkDialog.this.basePath, MDELinkDialog.this.getElement());
                if (path != null) {
                    String path2Object = path.getFirst();
                    String objectLabel = path.getSecond();
                    if (path2Object != null) {
                        if ("File (absolute path) (not recommended)".equals(MDELinkDialog.this.linkType)) {
                            path2Object = path2Object.replace("\\", "/");
                        }
                        MDELinkDialog.this.urlText.setText(path2Object);
                    }
                    MDELinkDialog.this.urlDisplayNameText.setText(objectLabel != null ? objectLabel : "");
                }
            }
        });
        this.browseButton.moveAbove((Control)this.urlDisplayNameLabel);
    }

    private void createListLinksType(Composite composite) {
        this.linkTypeCombo = new Combo(composite, 2056);
        GridData comboGridData = new GridData(768);
        comboGridData.horizontalSpan = 2;
        this.linkTypeCombo.setLayoutData((Object)comboGridData);
        final String[] itemsLinkList = this.linkManager.getAllLinkLabels().toArray(new String[0]);
        this.linkTypeCombo.setItems(itemsLinkList);
        this.linkType = itemsLinkList[0];
        this.linkTypeCombo.setText(this.linkType);
        this.linkTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                MDELinkDialog.this.linkType = itemsLinkList[MDELinkDialog.this.linkTypeCombo.getSelectionIndex()];
                MDELinkDialog.this.updateButtonsState();
                if ("URL".equals(MDELinkDialog.this.linkType)) {
                    MDELinkDialog.this.urlDisplayNameText.setText(MDELinkDialog.this.getDefaultLabel());
                } else {
                    MDELinkDialog.this.urlDisplayNameText.setText("");
                }
                MDELinkDialog.this.urlText.setText("");
                MDELinkDialog.this.updateHeaderMessages();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.linkTypeCombo.moveAbove((Control)this.urlLabel);
    }

    private void createDisplayTextURL(Composite composite) {
        this.urlDisplayNameLabel = new Label(composite, 0);
        this.urlDisplayNameLabel.setText(Messages.RichTextWidget_Dialog_Add_Link_URL_Display);
        this.urlDisplayNameText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).hint(300, -1).applyTo((Control)this.urlDisplayNameText);
        Label linkTypeLabel = new Label(composite, 0);
        linkTypeLabel.setText(Messages.RichTextWidget_Dialog_Add_Link);
        linkTypeLabel.moveAbove((Control)this.urlLabel);
    }

    private void createUrlLabel(Composite composite) {
        this.urlLabel = new Label(composite, 0);
        this.urlLabel.setText("URL");
        this.urlText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).hint(300, -1).applyTo((Control)this.urlText);
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (MDELinkDialog.this.getOK() != null) {
                    MDELinkDialog.this.getOK().setEnabled(MDELinkDialog.this.urlText.getText().trim().length() > 0);
                }
            }
        });
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.getOK().setEnabled(this.urlText.getText().trim().length() > 0);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        String url = this.urlText.getText();
        if (url != null && url.length() > 0) {
            String urlDisplayName = this.urlDisplayNameText.getText();
            if (urlDisplayName.trim().length() == 0) {
                urlDisplayName = url;
            }
            this.setEncodedURL(this.linkManager.encode(this.linkType, url, urlDisplayName));
        }
        this.urlText.setText("");
        super.okPressed();
    }

    protected EObject getElement() {
        return this.element;
    }

    protected String getDefaultLabel() {
        return this.defaultLabel;
    }

    @Override
    public String getEncodedURL() {
        return this.encodedURL;
    }

    protected void setEncodedURL(String url) {
        this.encodedURL = url;
    }

    protected String getText(EObject obj) {
        if (obj == null) {
            return null;
        }
        AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)obj);
        if (editingDomain == null) {
            return null;
        }
        IItemLabelProvider provider = (IItemLabelProvider)editingDomain.getAdapterFactory().adapt((Notifier)obj, IItemLabelProvider.class);
        String label = "";
        if (provider != null) {
            label = provider.getText((Object)obj);
        }
        return label;
    }

    protected String getDialogName() {
        if (this.dialogName == null) {
            String modelElementLabel = this.getText(this.getElement());
            this.dialogName = NLS.bind((String)Messages.RichTextWidget_Dialog_Edit_Link, (Object)modelElementLabel);
        }
        return this.dialogName;
    }

    protected void updateButtonsState() {
        this.browseButton.setEnabled(!"URL".equals(this.linkType));
        this.urlLabel.setEnabled("URL".equals(this.linkType) || "File (absolute path) (not recommended)".equals(this.linkType) || "File (project relative path) (not recommended)".equals(this.linkType));
        this.urlText.setEnabled("URL".equals(this.linkType) || "File (absolute path) (not recommended)".equals(this.linkType) || "File (project relative path) (not recommended)".equals(this.linkType));
    }

    @Override
    public boolean handle() {
        int result = this.open();
        return result == 0;
    }
}

