/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.dialogs;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.AbstractSelectionDialog;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.api.interpreter.IInterpreterMessages;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.capella.common.ui.toolkit.dialogs.Messages;

public class OpenRepresentationDialog
extends AbstractSelectionDialog<DRepresentationDescriptor> {
    HashSet<DRepresentationDescriptor> descriptors;
    DRepresentationDescriptor selectedDescriptor;

    public OpenRepresentationDialog(Shell parentShell, Collection<DRepresentationDescriptor> descriptors) {
        super(parentShell);
        this.descriptors = new HashSet<DRepresentationDescriptor>(descriptors);
    }

    public void create() {
        this.setTitle("Open existing representation");
        super.create();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.setMessage(Messages.openRepresentationMessage);
        this.createMessageArea(composite);
        GridData data = new GridData(1796);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        ComboViewer comboViewer = new ComboViewer(composite, 2828);
        comboViewer.getCombo().setFont(parent.getFont());
        comboViewer.getCombo().setLayoutData((Object)data);
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                DRepresentationDescriptor descriptor = (DRepresentationDescriptor)element;
                IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)descriptor);
                String newName = "";
                String titleExpression = descriptor.getName();
                if (!StringUtil.isEmpty((String)titleExpression)) {
                    try {
                        newName = interpreter.evaluateString((EObject)descriptor, titleExpression);
                    }
                    catch (EvaluationException e) {
                        SiriusPlugin.getDefault().error(IInterpreterMessages.EVALUATION_ERROR_ON_MODEL_MODIFICATION, (Throwable)e);
                    }
                }
                return newName;
            }
        });
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setInput(this.descriptors);
        comboViewer.addSelectionChangedListener(selectionChangedEvent -> {
            DRepresentationDescriptor dRepresentationDescriptor = this.selectedDescriptor = (DRepresentationDescriptor)((StructuredSelection)selectionChangedEvent.getSelection()).getFirstElement();
        });
        this.setInitialSelection(new DRepresentationDescriptor[]{this.descriptors.iterator().next()});
        comboViewer.setSelection((ISelection)new StructuredSelection(this.getInitialSelection()));
        comboViewer.addDoubleClickListener(event -> this.okPressed());
        return composite;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected boolean isResizable() {
        return false;
    }

    public DialogTray getTray() {
        return null;
    }

    public DRepresentationDescriptor getSelectedDescriptor() {
        return this.selectedDescriptor;
    }
}

