/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.mdsofa.common.helper.StringHelper;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;
import org.polarsys.capella.core.model.handler.helpers.CrossReferencerHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.Messages;
import org.polarsys.capella.core.ui.toolkit.dialogs.ImpactAnalysisDialog;

public class ImpactAnalysisAction
extends BaseSelectionListenerAction {
    public ImpactAnalysisAction() {
        super(Messages.ImpactAnalysisAction_Title);
    }

    public void init(IWorkbenchPart view_p) {
    }

    public void run() {
        EObject modelElement = (EObject)this.getStructuredSelection().getFirstElement();
        List referencingElements = CrossReferencerHelper.getReferencingElements((EObject)modelElement);
        referencingElements.addAll(RepresentationHelper.getAllRepresentationDescriptorsTargetedBy(Collections.singletonList(modelElement)));
        String formattedMessage = StringHelper.formatMessage((String)Messages.ImpactAnalysisDialog_Message, (Object[])new String[]{EObjectLabelProviderHelper.getText((Object)modelElement)});
        ImpactAnalysisDialog dialog = new ImpactAnalysisDialog(referencingElements, Messages.ImpactAnalysisDialog_Title, formattedMessage);
        dialog.open();
    }

    public void run(IAction action_p) {
        this.run();
    }

    public void selectionChanged(IAction action_p, ISelection selection_p) {
        boolean enabled = this.selectionChanged(selection_p);
        action_p.setEnabled(enabled);
    }

    public boolean selectionChanged(ISelection selection_p) {
        EObject element;
        IStructuredSelection selection = (IStructuredSelection)selection_p;
        boolean enabled = false;
        if (!selection.isEmpty() && (element = CapellaAdapterHelper.resolveBusinessObject((Object)selection.getFirstElement())) != null && CapellaResourceHelper.isSemanticElement((Object)element)) {
            enabled = true;
            this.selectionChanged((IStructuredSelection)new StructuredSelection((Object)element));
        }
        return enabled;
    }

    public void setActivePart(IAction action_p, IWorkbenchPart targetPart_p) {
    }

    protected boolean updateSelection(IStructuredSelection selection_p) {
        boolean result = false;
        if (selection_p != null && !selection_p.isEmpty()) {
            result = CapellaResourceHelper.isSemanticElements((Collection)selection_p.toList());
        }
        return result;
    }
}

