/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.flexibility.wizards.ui;

import java.util.Collection;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;

public class DefaultLabelProvider
implements ILabelProvider,
IColorProvider,
IFontProvider {
    private ILabelProvider _labelProvider = null;

    public DefaultLabelProvider(ILabelProvider labelProvider) {
        this._labelProvider = labelProvider;
    }

    public DefaultLabelProvider() {
    }

    public Image getImage(Object object) {
        IItemLabelProvider labelProvider;
        if (object instanceof Collection && ((Collection)object).size() == 1) {
            return this.getImage(((Collection)object).iterator().next());
        }
        if (this._labelProvider != null) {
            return this._labelProvider.getImage(object);
        }
        if (object instanceof IAdaptable && (labelProvider = (IItemLabelProvider)((IAdaptable)object).getAdapter(IItemLabelProvider.class)) != null) {
            return ExtendedImageRegistry.getInstance().getImage(labelProvider.getImage(object));
        }
        if (object instanceof EObject) {
            return ExtendedImageRegistry.getInstance().getImage(EObjectLabelProviderHelper.getImage((EObject)((EObject)object)));
        }
        return null;
    }

    public String getText(Object object) {
        IItemLabelProvider labelProvider;
        if (object instanceof Collection) {
            Collection col = (Collection)object;
            StringBuffer result = new StringBuffer();
            int i = 0;
            for (Object a : col) {
                result.append(this.getText(a));
                if (i++ >= col.size() - 1) continue;
                result.append(';');
                result.append(' ');
            }
            return result.toString();
        }
        if (this._labelProvider != null) {
            return this._labelProvider.getText(object);
        }
        if (object instanceof IAdaptable && (labelProvider = (IItemLabelProvider)((IAdaptable)object).getAdapter(IItemLabelProvider.class)) != null) {
            return labelProvider.getText(object);
        }
        return EObjectLabelProviderHelper.getText((Object)object);
    }

    public void addListener(ILabelProviderListener listener) {
        if (this._labelProvider != null) {
            this._labelProvider.addListener(listener);
        }
    }

    public void dispose() {
        if (this._labelProvider != null) {
            this._labelProvider.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        if (this._labelProvider != null) {
            return this._labelProvider.isLabelProperty(element, property);
        }
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this._labelProvider != null) {
            this._labelProvider.removeListener(listener);
        }
    }

    public Font getFont(Object element) {
        if (this._labelProvider instanceof IFontProvider) {
            return ((IFontProvider)this._labelProvider).getFont(element);
        }
        return null;
    }

    public Color getForeground(Object element) {
        if (this._labelProvider instanceof IColorProvider) {
            return ((IColorProvider)this._labelProvider).getForeground(element);
        }
        return null;
    }

    public Color getBackground(Object element) {
        if (this._labelProvider instanceof IColorProvider) {
            return ((IColorProvider)this._labelProvider).getBackground(element);
        }
        return null;
    }
}

