/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.IPattern;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternRole;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternRoleSymbol;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternSymbol;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IAtomicLocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IElementMappingLocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IElementRelativeLocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.ILocation;
import org.eclipse.emf.diffmerge.patterns.core.api.status.IModelTransformationStatus;
import org.eclipse.emf.diffmerge.patterns.core.api.status.IPatternConformityStatus;
import org.eclipse.emf.diffmerge.patterns.core.api.status.SimpleStatus;
import org.eclipse.emf.diffmerge.patterns.core.gen.PatternsCoreGenAdapter;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.AbstractLocation;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.AbstractPatternData;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.AbstractPatternInstance;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.CorepatternsFactory;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.CorepatternsPackage;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.PatternRoleBinding;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.PatternRoleSymbol;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.PatternSymbol;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.PatternVersion;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.impl.AbstractIdentifiedElementImpl;
import org.eclipse.emf.diffmerge.patterns.core.util.BasicPatternRoleSymbol;
import org.eclipse.emf.diffmerge.patterns.core.util.LocationsUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

public abstract class AbstractPatternInstanceImpl
extends AbstractIdentifiedElementImpl
implements AbstractPatternInstance {
    protected static final boolean FOLDED_EDEFAULT = false;
    protected boolean folded = false;
    protected EList<PatternRoleBinding> roleBindings;
    protected PatternVersion patternVersion;
    protected AbstractPatternData patternData;

    protected AbstractPatternInstanceImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return CorepatternsPackage.Literals.ABSTRACT_PATTERN_INSTANCE;
    }

    @Override
    public EList<PatternRoleBinding> getRoleBindings() {
        if (this.roleBindings == null) {
            this.roleBindings = new EObjectContainmentEList(PatternRoleBinding.class, (InternalEObject)this, 2);
        }
        return this.roleBindings;
    }

    @Override
    public PatternVersion getPatternVersion() {
        return this.patternVersion;
    }

    public NotificationChain basicSetPatternVersion(PatternVersion newPatternVersion, NotificationChain msgs) {
        PatternVersion oldPatternVersion = this.patternVersion;
        this.patternVersion = newPatternVersion;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldPatternVersion, (Object)newPatternVersion);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setPatternVersion(PatternVersion newPatternVersion) {
        if (newPatternVersion != this.patternVersion) {
            NotificationChain msgs = null;
            if (this.patternVersion != null) {
                msgs = ((InternalEObject)this.patternVersion).eInverseRemove((InternalEObject)this, -4, null, msgs);
            }
            if (newPatternVersion != null) {
                msgs = ((InternalEObject)newPatternVersion).eInverseAdd((InternalEObject)this, -4, null, msgs);
            }
            if ((msgs = this.basicSetPatternVersion(newPatternVersion, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newPatternVersion, (Object)newPatternVersion));
        }
    }

    @Override
    public boolean isFolded() {
        return this.folded;
    }

    @Override
    public void setFolded(boolean newFolded) {
        boolean oldFolded = this.folded;
        this.folded = newFolded;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, oldFolded, this.folded));
        }
    }

    @Override
    public AbstractPatternData getPatternData() {
        return this.patternData;
    }

    public NotificationChain basicSetPatternData(AbstractPatternData newPatternData, NotificationChain msgs) {
        AbstractPatternData oldPatternData = this.patternData;
        this.patternData = newPatternData;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldPatternData, (Object)newPatternData);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setPatternData(AbstractPatternData newPatternData) {
        if (newPatternData != this.patternData) {
            NotificationChain msgs = null;
            if (this.patternData != null) {
                msgs = ((InternalEObject)this.patternData).eInverseRemove((InternalEObject)this, 1, AbstractPatternData.class, msgs);
            }
            if (newPatternData != null) {
                msgs = ((InternalEObject)newPatternData).eInverseAdd((InternalEObject)this, 1, AbstractPatternData.class, msgs);
            }
            if ((msgs = this.basicSetPatternData(newPatternData, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)newPatternData, (Object)newPatternData));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getRoleBindings()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return this.basicSetPatternVersion(null, msgs);
            }
            case 4: {
                return this.basicSetPatternData(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.isFolded();
            }
            case 2: {
                return this.getRoleBindings();
            }
            case 3: {
                return this.getPatternVersion();
            }
            case 4: {
                return this.getPatternData();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setFolded((Boolean)newValue);
                return;
            }
            case 2: {
                this.getRoleBindings().clear();
                this.getRoleBindings().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.setPatternVersion((PatternVersion)newValue);
                return;
            }
            case 4: {
                this.setPatternData((AbstractPatternData)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setFolded(false);
                return;
            }
            case 2: {
                this.getRoleBindings().clear();
                return;
            }
            case 3: {
                this.setPatternVersion(null);
                return;
            }
            case 4: {
                this.setPatternData(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.folded;
            }
            case 2: {
                return this.roleBindings != null && !this.roleBindings.isEmpty();
            }
            case 3: {
                return this.patternVersion != null;
            }
            case 4: {
                return this.patternData != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (folded: ");
        result.append(this.folded);
        result.append(')');
        return result.toString();
    }

    public IModelTransformationStatus fold() {
        IPattern pattern = this.getPattern();
        Object result = pattern == null ? SimpleStatus.NO_PATTERN_FAILURE : pattern.fold((IPatternInstance)this);
        if (result.isOk()) {
            this.setFolded(true);
        }
        return result;
    }

    public IModelTransformationStatus unfold() {
        IPattern pattern = this.getPattern();
        Object result = pattern == null ? SimpleStatus.NO_PATTERN_FAILURE : pattern.unfold((IPatternInstance)this);
        if (result.isOk() && !result.hasWarnings()) {
            this.setFolded(false);
        }
        return result;
    }

    public IModelTransformationStatus update(IPattern.IModelUpdateSpecification specification_p) {
        IPattern pattern = this.getPattern();
        if (pattern == null) {
            return SimpleStatus.NO_PATTERN_FAILURE;
        }
        return pattern.updateModel((IPatternInstance)this, specification_p);
    }

    public IPatternConformityStatus checkConformance(List<EStructuralFeature> ignoredFeatures_p) {
        IPattern pattern = this.getPattern();
        if (pattern == null) {
            return SimpleStatus.NO_PATTERN_FAILURE;
        }
        return pattern.checkConformance((IPatternApplication)this, ignoredFeatures_p);
    }

    protected PatternRoleBinding getBindingFor(IPatternRole role_p) {
        IPatternRoleSymbol symbol = role_p.getSymbol();
        if (symbol == null) {
            return null;
        }
        return this.getBindingFor(symbol);
    }

    protected PatternRoleBinding getBindingFor(IPatternRoleSymbol symbol_p) {
        for (PatternRoleBinding binding : this.getRoleBindings()) {
            if (!BasicPatternRoleSymbol.areEqual((IPatternRoleSymbol)symbol_p, (IPatternRoleSymbol)binding.getRoleSymbol())) continue;
            return binding;
        }
        return null;
    }

    public List<EObject> getElements() {
        AbstractPatternData data = this.getPatternData();
        List result = data == null ? LocationsUtil.getMergeTargets((IPatternApplication)this) : data.getInstanceElements();
        return result;
    }

    public ILocation getLocation(IPatternRole role_p) {
        PatternRoleBinding binding = this.getBindingFor(role_p);
        if (binding == null) {
            return null;
        }
        return binding.getLocation();
    }

    public Collection<? extends ILocation> getLocations() {
        ArrayList<AbstractLocation> result = new ArrayList<AbstractLocation>();
        for (PatternRoleBinding binding : this.getRoleBindings()) {
            AbstractLocation location = binding.getLocation();
            if (location == null) continue;
            result.add(location);
        }
        return Collections.unmodifiableCollection(result);
    }

    public IPattern getPattern() {
        PatternSymbol symbol;
        IPattern result = null;
        PatternVersion version = this.getPatternVersion();
        PatternSymbol patternSymbol = symbol = version != null ? version.getPatternSymbol() : null;
        if (symbol != null) {
            result = CorePatternsPlugin.getDefault().getRepositoryRegistry().getPattern((IPatternSymbol)symbol);
        }
        return result;
    }

    public List<IPatternRole> getRolesOf(EObject element_p) {
        ArrayList<IPatternRole> result = new ArrayList<IPatternRole>();
        if (this.getPattern() != null) {
            block0: for (IPatternRole role : this.getPattern().getRoles()) {
                ILocation location = this.getLocation(role);
                if (location == null) continue;
                block1: for (IAtomicLocation atomicLocation : location.getAtomicContents()) {
                    if (atomicLocation instanceof IElementRelativeLocation) {
                        EObject element = ((IElementRelativeLocation)atomicLocation).getElement();
                        if (element != element_p) continue;
                        result.add(role);
                        continue block0;
                    }
                    if (!(atomicLocation instanceof IElementMappingLocation)) continue;
                    IElementMappingLocation mappingLocation = (IElementMappingLocation)atomicLocation;
                    for (EObject patternElement : mappingLocation.getPatternElements(this.getPattern())) {
                        EObject modelElement = mappingLocation.getElement(patternElement);
                        if (modelElement != element_p) continue;
                        result.add(role);
                        continue block1;
                    }
                }
            }
        }
        return Collections.unmodifiableList(result);
    }

    public Object getScopeElement() {
        return this;
    }

    public boolean isComplete() {
        for (IPatternRole role : this.getPattern().getRoles()) {
            if (this.isCompleteOn(role)) continue;
            return false;
        }
        return true;
    }

    public boolean isCompleteOn(IPatternRole role_p) {
        return role_p.checkApplicability(this.getLocation(role_p), (IPatternApplication)this).isOk();
    }

    public boolean isEmpty() {
        if (this.getPattern() == null) {
            return true;
        }
        for (IPatternRole role : this.getPattern().getRoles()) {
            if (!this.isCompleteOn(role)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setLocation(IPatternRole role_p, AbstractLocation location_p) {
        PatternRoleBinding binding = this.getBindingFor(role_p);
        if (binding == null) {
            binding = CorepatternsFactory.eINSTANCE.createPatternRoleBinding();
            PatternRoleSymbol symbol = PatternsCoreGenAdapter.GEN_ADAPTER.adapt(role_p.getSymbol());
            binding.setRoleSymbol(symbol);
            this.getRoleBindings().add((Object)binding);
        }
        binding.setLocation(location_p);
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                if (this.patternData != null) {
                    msgs = ((InternalEObject)this.patternData).eInverseRemove((InternalEObject)this, -5, null, msgs);
                }
                return this.basicSetPatternData((AbstractPatternData)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }
}

