/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.re.handlers.location;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ComposedSwitch;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.Switch;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacommon.StateEvent;
import org.polarsys.capella.core.data.capellacommon.util.CapellacommonSwitch;
import org.polarsys.capella.core.data.capellacore.AbstractPropertyValue;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyType;
import org.polarsys.capella.core.data.capellacore.PropertyValueGroup;
import org.polarsys.capella.core.data.capellacore.PropertyValuePkg;
import org.polarsys.capella.core.data.capellacore.util.CapellacoreSwitch;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.util.CsSwitch;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityPkg;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.data.ctx.MissionPkg;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.ctx.SystemComponentPkg;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.ctx.SystemFunctionPkg;
import org.polarsys.capella.core.data.ctx.util.CtxSwitch;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ExchangeCategory;
import org.polarsys.capella.core.data.fa.util.FaSwitch;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.KeyPart;
import org.polarsys.capella.core.data.information.Union;
import org.polarsys.capella.core.data.information.Unit;
import org.polarsys.capella.core.data.information.communication.CommunicationItem;
import org.polarsys.capella.core.data.information.communication.util.CommunicationSwitch;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.data.information.datatype.util.DatatypeSwitch;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.data.information.datavalue.util.DatavalueSwitch;
import org.polarsys.capella.core.data.information.util.InformationSwitch;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.la.CapabilityRealizationPkg;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.core.data.la.LogicalFunctionPkg;
import org.polarsys.capella.core.data.la.util.LaSwitch;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.EntityPkg;
import org.polarsys.capella.core.data.oa.OaFactory;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.OperationalActivityPkg;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.oa.OperationalCapability;
import org.polarsys.capella.core.data.oa.OperationalCapabilityPkg;
import org.polarsys.capella.core.data.oa.Role;
import org.polarsys.capella.core.data.oa.RolePkg;
import org.polarsys.capella.core.data.oa.util.OaSwitch;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.core.data.pa.PhysicalFunction;
import org.polarsys.capella.core.data.pa.PhysicalFunctionPkg;
import org.polarsys.capella.core.data.pa.util.PaSwitch;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.ProjectExt;
import org.polarsys.capella.core.model.helpers.SystemAnalysisExt;
import org.polarsys.capella.core.model.helpers.naming.NamingConstants;

public class SpecificPackageSupplierFactory {
    private final ComposedSwitch<Supplier<EObject>> zwitch;
    private final Map<Map.Entry<EObject, EStructuralFeature>, Supplier<EObject>> createdSuppliers = new HashMap<Map.Entry<EObject, EStructuralFeature>, Supplier<EObject>>();
    private final Resource destinationResource;
    private BlockArchitecture destinationBlock;
    private EObject packagedElement;

    public SpecificPackageSupplierFactory(Resource destinationResource) {
        this.destinationResource = destinationResource;
        List<Switch> theSwitches = Arrays.asList(new Switch[]{new Capellacommon(), new Capellacore(), new Communication(), new Cs(), new Ctx(), new Datatype(), new Datavalue(), new Fa(), new Information(), new La(), new Oa(), new Pa()});
        this.zwitch = new ComposedSwitch(theSwitches);
    }

    public Supplier<EObject> getSpecificPackageSupplier(EObject packagedElement) {
        this.destinationBlock = this.findDestinationBlock(packagedElement);
        this.packagedElement = packagedElement;
        return (Supplier)this.zwitch.doSwitch(packagedElement);
    }

    private BlockArchitecture findDestinationBlock(EObject packagedElement) {
        BlockArchitecture result = null;
        BlockArchitecture packagedElementBlock = BlockArchitectureExt.getRootBlockArchitecture((EObject)packagedElement);
        if (packagedElementBlock != null) {
            EClass clazz = packagedElementBlock.eClass();
            Resource resource = this.destinationResource;
            Project project = ProjectExt.getProject((Resource)resource);
            result = BlockArchitectureExt.getBlockArchitecture((EClass)clazz, (Project)project);
        }
        return result;
    }

    private Supplier<EObject> getSpecificPackageSupplier(final EObject container, final EReference feature) {
        AbstractMap.SimpleImmutableEntry<EObject, EReference> key = new AbstractMap.SimpleImmutableEntry<EObject, EReference>(container, feature);
        Supplier<EObject> created = this.createdSuppliers.get(key);
        if (created == null) {
            created = new Supplier<EObject>(){
                EObject suppliedObject;

                @Override
                public EObject get() {
                    if (this.suppliedObject == null) {
                        this.suppliedObject = EcoreUtil.create((EClass)feature.getEReferenceType());
                        ((Collection)container.eGet((EStructuralFeature)feature)).add(this.suppliedObject);
                    }
                    return this.suppliedObject;
                }
            };
            this.createdSuppliers.put(key, created);
        }
        return created;
    }

    private Supplier<EObject> getDataPkg() {
        System.out.println(this.destinationBlock.eClass().getName());
        DataPkg dataPkg = BlockArchitectureExt.getDataPkg((BlockArchitecture)this.destinationBlock, (boolean)true);
        return this.getSpecificPackageSupplier((EObject)dataPkg, InformationPackage.Literals.DATA_PKG__OWNED_DATA_PKGS);
    }

    private Supplier<EObject> getInterfacePkg() {
        InterfacePkg interfacePkg = BlockArchitectureExt.getInterfacePkg((BlockArchitecture)this.destinationBlock, (boolean)true);
        return this.getSpecificPackageSupplier((EObject)interfacePkg, CsPackage.Literals.INTERFACE_PKG__OWNED_INTERFACE_PKGS);
    }

    private Supplier<EObject> getSystemComponentPkg() {
        Component root = ComponentExt.getRootComponent((EObject)this.packagedElement);
        if (root != null && BlockArchitectureExt.isRootComponent((Component)root)) {
            SystemComponent rootComponent = (SystemComponent)this.destinationBlock.getSystem();
            return this.getSpecificPackageSupplier((EObject)rootComponent, CtxPackage.Literals.SYSTEM_COMPONENT__OWNED_SYSTEM_COMPONENT_PKGS);
        }
        SystemComponentPkg componentPkg = (SystemComponentPkg)BlockArchitectureExt.getComponentPkg((BlockArchitecture)this.destinationBlock, (boolean)true);
        return this.getSpecificPackageSupplier((EObject)componentPkg, CtxPackage.Literals.SYSTEM_COMPONENT_PKG__OWNED_SYSTEM_COMPONENT_PKGS);
    }

    private Supplier<EObject> getSystemFunctionPkg() {
        AbstractFunction rootFunction = BlockArchitectureExt.getRootFunction((BlockArchitecture)this.destinationBlock, (boolean)true);
        return this.getSpecificPackageSupplier((EObject)rootFunction, CtxPackage.Literals.SYSTEM_FUNCTION__OWNED_SYSTEM_FUNCTION_PKGS);
    }

    private Supplier<EObject> getMissionPkg() {
        if (this.destinationBlock instanceof SystemAnalysis) {
            MissionPkg missionPkg = SystemAnalysisExt.getMissionPkg((SystemAnalysis)((SystemAnalysis)this.destinationBlock));
            return this.getSpecificPackageSupplier((EObject)missionPkg, CtxPackage.Literals.MISSION_PKG__OWNED_MISSION_PKGS);
        }
        return null;
    }

    private Supplier<EObject> getPhysicalComponentPkg() {
        Component root = ComponentExt.getRootComponent((EObject)this.packagedElement);
        if (root != null && BlockArchitectureExt.isRootComponent((Component)root)) {
            PhysicalComponent rootComponent = (PhysicalComponent)this.destinationBlock.getSystem();
            return this.getSpecificPackageSupplier((EObject)rootComponent, PaPackage.Literals.PHYSICAL_COMPONENT__OWNED_PHYSICAL_COMPONENT_PKGS);
        }
        PhysicalComponentPkg componentPkg = (PhysicalComponentPkg)BlockArchitectureExt.getComponentPkg((BlockArchitecture)this.destinationBlock, (boolean)true);
        return this.getSpecificPackageSupplier((EObject)componentPkg, PaPackage.Literals.PHYSICAL_COMPONENT_PKG__OWNED_PHYSICAL_COMPONENT_PKGS);
    }

    private Supplier<EObject> getPhysicalFunctionPkg() {
        AbstractFunction rootFunction = BlockArchitectureExt.getRootFunction((BlockArchitecture)this.destinationBlock, (boolean)true);
        return this.getSpecificPackageSupplier((EObject)rootFunction, PaPackage.Literals.PHYSICAL_FUNCTION__OWNED_PHYSICAL_FUNCTION_PKGS);
    }

    private Supplier<EObject> getLogicalComponentPkg() {
        Component root = ComponentExt.getRootComponent((EObject)this.packagedElement);
        if (root != null && BlockArchitectureExt.isRootComponent((Component)root)) {
            LogicalComponent rootComponent = (LogicalComponent)this.destinationBlock.getSystem();
            return this.getSpecificPackageSupplier((EObject)rootComponent, LaPackage.Literals.LOGICAL_COMPONENT__OWNED_LOGICAL_COMPONENT_PKGS);
        }
        LogicalComponentPkg componentPkg = (LogicalComponentPkg)BlockArchitectureExt.getComponentPkg((BlockArchitecture)this.destinationBlock, (boolean)true);
        return this.getSpecificPackageSupplier((EObject)componentPkg, LaPackage.Literals.LOGICAL_COMPONENT_PKG__OWNED_LOGICAL_COMPONENT_PKGS);
    }

    private Supplier<EObject> getOperationalCapabilityPkg() {
        OperationalCapabilityPkg pkg = (OperationalCapabilityPkg)BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)this.destinationBlock, (boolean)true);
        return this.getSpecificPackageSupplier((EObject)pkg, OaPackage.Literals.OPERATIONAL_CAPABILITY_PKG__OWNED_OPERATIONAL_CAPABILITY_PKGS);
    }

    private Supplier<EObject> getCapabilityPkg() {
        CapabilityPkg pkg = (CapabilityPkg)BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)this.destinationBlock, (boolean)true);
        return this.getSpecificPackageSupplier((EObject)pkg, CtxPackage.Literals.CAPABILITY_PKG__OWNED_CAPABILITY_PKGS);
    }

    private Supplier<EObject> getCapabilityRealizationPkg() {
        CapabilityRealizationPkg pkg = (CapabilityRealizationPkg)BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)this.destinationBlock, (boolean)true);
        return this.getSpecificPackageSupplier((EObject)pkg, LaPackage.Literals.CAPABILITY_REALIZATION_PKG__OWNED_CAPABILITY_REALIZATION_PKGS);
    }

    private Supplier<EObject> getEntityPkg() {
        EntityPkg pkg = (EntityPkg)BlockArchitectureExt.getComponentPkg((BlockArchitecture)this.destinationBlock, (boolean)true);
        return this.getSpecificPackageSupplier((EObject)pkg, OaPackage.Literals.ENTITY_PKG__OWNED_ENTITY_PKGS);
    }

    private Supplier<EObject> getRolePkg() {
        RolePkg pkg = ((OperationalAnalysis)this.destinationBlock).getOwnedRolePkg();
        if (pkg == null) {
            pkg = OaFactory.eINSTANCE.createRolePkg(NamingConstants.CreateOpAnalysisCmd_roles_pkg_name);
            ((OperationalAnalysis)this.destinationBlock).setOwnedRolePkg(pkg);
        }
        return this.getSpecificPackageSupplier((EObject)pkg, OaPackage.Literals.ROLE_PKG__OWNED_ROLE_PKGS);
    }

    private Supplier<EObject> getLogicalFunctionPkg() {
        AbstractFunction rootFunction = BlockArchitectureExt.getRootFunction((BlockArchitecture)this.destinationBlock, (boolean)true);
        return this.getSpecificPackageSupplier((EObject)rootFunction, LaPackage.Literals.LOGICAL_FUNCTION__OWNED_LOGICAL_FUNCTION_PKGS);
    }

    private Supplier<EObject> getOperationalActivityPkg() {
        AbstractFunction rootFunction = BlockArchitectureExt.getRootFunction((BlockArchitecture)this.destinationBlock, (boolean)true);
        return this.getSpecificPackageSupplier((EObject)rootFunction, OaPackage.Literals.OPERATIONAL_ACTIVITY__OWNED_OPERATIONAL_ACTIVITY_PKGS);
    }

    private Supplier<EObject> getPropertyValuePkg() {
        return this.getSpecificPackageSupplier((EObject)this.destinationBlock, CapellacorePackage.Literals.STRUCTURE__OWNED_PROPERTY_VALUE_PKGS);
    }

    class Capellacommon
    extends CapellacommonSwitch<Supplier<EObject>> {
        Capellacommon() {
        }

        public Supplier<EObject> caseStateEvent(StateEvent object) {
            return SpecificPackageSupplierFactory.this.getDataPkg();
        }
    }

    class Capellacore
    extends CapellacoreSwitch<Supplier<EObject>> {
        Capellacore() {
        }

        public Supplier<EObject> caseAbstractPropertyValue(AbstractPropertyValue object) {
            return SpecificPackageSupplierFactory.this.getPropertyValuePkg();
        }

        public Supplier<EObject> casePropertyValueGroup(PropertyValueGroup object) {
            return SpecificPackageSupplierFactory.this.getPropertyValuePkg();
        }

        public Supplier<EObject> casePropertyValuePkg(PropertyValuePkg object) {
            return SpecificPackageSupplierFactory.this.getPropertyValuePkg();
        }

        public Supplier<EObject> caseEnumerationPropertyType(EnumerationPropertyType object) {
            return SpecificPackageSupplierFactory.this.getPropertyValuePkg();
        }
    }

    class Communication
    extends CommunicationSwitch<Supplier<EObject>> {
        Communication() {
        }

        public Supplier<EObject> caseCommunicationItem(CommunicationItem object) {
            return SpecificPackageSupplierFactory.this.getDataPkg();
        }
    }

    class Cs
    extends CsSwitch<Supplier<EObject>> {
        Cs() {
        }

        public Supplier<EObject> caseInterfacePkg(InterfacePkg object) {
            return SpecificPackageSupplierFactory.this.getInterfacePkg();
        }

        public Supplier<EObject> caseInterface(Interface object) {
            return SpecificPackageSupplierFactory.this.getInterfacePkg();
        }

        public Supplier<EObject> casePart(Part object) {
            BlockArchitectureExt.Type blockArchitectureType = BlockArchitectureExt.getBlockArchitectureType((BlockArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)object));
            if (blockArchitectureType == BlockArchitectureExt.Type.OA) {
                return SpecificPackageSupplierFactory.this.getEntityPkg();
            }
            if (blockArchitectureType == BlockArchitectureExt.Type.SA) {
                return SpecificPackageSupplierFactory.this.getSystemComponentPkg();
            }
            if (blockArchitectureType == BlockArchitectureExt.Type.LA) {
                return SpecificPackageSupplierFactory.this.getLogicalComponentPkg();
            }
            if (blockArchitectureType == BlockArchitectureExt.Type.PA) {
                return SpecificPackageSupplierFactory.this.getPhysicalComponentPkg();
            }
            return (Supplier)super.casePart(object);
        }

        public Supplier<EObject> casePhysicalLink(PhysicalLink object) {
            BlockArchitectureExt.Type blockArchitectureType = BlockArchitectureExt.getBlockArchitectureType((BlockArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)object));
            if (blockArchitectureType == BlockArchitectureExt.Type.OA) {
                return SpecificPackageSupplierFactory.this.getEntityPkg();
            }
            if (blockArchitectureType == BlockArchitectureExt.Type.SA) {
                return SpecificPackageSupplierFactory.this.getSystemComponentPkg();
            }
            if (blockArchitectureType == BlockArchitectureExt.Type.LA) {
                return SpecificPackageSupplierFactory.this.getLogicalComponentPkg();
            }
            if (blockArchitectureType == BlockArchitectureExt.Type.PA) {
                return SpecificPackageSupplierFactory.this.getPhysicalComponentPkg();
            }
            return (Supplier)super.casePhysicalLink(object);
        }
    }

    class Ctx
    extends CtxSwitch<Supplier<EObject>> {
        Ctx() {
        }

        public Supplier<EObject> caseSystemFunction(SystemFunction object) {
            return SpecificPackageSupplierFactory.this.getSystemFunctionPkg();
        }

        public Supplier<EObject> caseSystemFunctionPkg(SystemFunctionPkg object) {
            return SpecificPackageSupplierFactory.this.getSystemFunctionPkg();
        }

        public Supplier<EObject> caseSystemComponentPkg(SystemComponentPkg object) {
            return SpecificPackageSupplierFactory.this.getSystemComponentPkg();
        }

        public Supplier<EObject> caseSystemComponent(SystemComponent object) {
            return SpecificPackageSupplierFactory.this.getSystemComponentPkg();
        }

        public Supplier<EObject> caseMission(Mission object) {
            return SpecificPackageSupplierFactory.this.getMissionPkg();
        }

        public Supplier<EObject> caseMissionPkg(MissionPkg object) {
            return SpecificPackageSupplierFactory.this.getMissionPkg();
        }

        public Supplier<EObject> caseCapability(Capability object) {
            return SpecificPackageSupplierFactory.this.getCapabilityPkg();
        }

        public Supplier<EObject> caseCapabilityPkg(CapabilityPkg object) {
            return SpecificPackageSupplierFactory.this.getCapabilityPkg();
        }
    }

    class Datatype
    extends DatatypeSwitch<Supplier<EObject>> {
        Datatype() {
        }

        public Supplier<EObject> caseDataType(DataType object) {
            return SpecificPackageSupplierFactory.this.getDataPkg();
        }
    }

    class Datavalue
    extends DatavalueSwitch<Supplier<EObject>> {
        Datavalue() {
        }

        public Supplier<EObject> caseDataValue(DataValue object) {
            return SpecificPackageSupplierFactory.this.getDataPkg();
        }
    }

    class Fa
    extends FaSwitch<Supplier<EObject>> {
        Fa() {
        }

        public Supplier<EObject> caseComponentExchange(ComponentExchange object) {
            BlockArchitectureExt.Type blockArchitectureType = BlockArchitectureExt.getBlockArchitectureType((BlockArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)object));
            if (blockArchitectureType == BlockArchitectureExt.Type.OA) {
                return SpecificPackageSupplierFactory.this.getEntityPkg();
            }
            if (blockArchitectureType == BlockArchitectureExt.Type.SA) {
                return SpecificPackageSupplierFactory.this.getSystemComponentPkg();
            }
            if (blockArchitectureType == BlockArchitectureExt.Type.LA) {
                return SpecificPackageSupplierFactory.this.getLogicalComponentPkg();
            }
            if (blockArchitectureType == BlockArchitectureExt.Type.PA) {
                return SpecificPackageSupplierFactory.this.getPhysicalComponentPkg();
            }
            return (Supplier)super.caseComponentExchange(object);
        }

        public Supplier<EObject> caseExchangeCategory(ExchangeCategory object) {
            EObject container = object.eContainer();
            if (container != null) {
                return (Supplier)SpecificPackageSupplierFactory.this.zwitch.doSwitch(container);
            }
            return null;
        }
    }

    class Information
    extends InformationSwitch<Supplier<EObject>> {
        Information() {
        }

        public Supplier<EObject> caseDataPkg(DataPkg object) {
            return SpecificPackageSupplierFactory.this.getDataPkg();
        }

        public Supplier<EObject> caseExchangeItem(ExchangeItem object) {
            EObject aep = EcoreUtil2.getFirstContainer((EObject)object, (EClass)CapellacorePackage.Literals.ABSTRACT_EXCHANGE_ITEM_PKG);
            if (aep != null) {
                return (Supplier)SpecificPackageSupplierFactory.this.zwitch.doSwitch(aep);
            }
            return null;
        }

        public Supplier<EObject> caseDataValue(DataValue object) {
            return SpecificPackageSupplierFactory.this.getDataPkg();
        }

        public Supplier<EObject> caseClass(Class object) {
            return SpecificPackageSupplierFactory.this.getDataPkg();
        }

        public Supplier<EObject> caseCollection(org.polarsys.capella.core.data.information.Collection object) {
            return SpecificPackageSupplierFactory.this.getDataPkg();
        }

        public Supplier<EObject> caseKeyPart(KeyPart object) {
            return SpecificPackageSupplierFactory.this.getDataPkg();
        }

        public Supplier<EObject> caseUnion(Union object) {
            return SpecificPackageSupplierFactory.this.getDataPkg();
        }

        public Supplier<EObject> caseUnit(Unit object) {
            return SpecificPackageSupplierFactory.this.getDataPkg();
        }
    }

    class La
    extends LaSwitch<Supplier<EObject>> {
        La() {
        }

        public Supplier<EObject> caseLogicalFunction(LogicalFunction object) {
            return SpecificPackageSupplierFactory.this.getLogicalFunctionPkg();
        }

        public Supplier<EObject> caseLogicalFunctionPkg(LogicalFunctionPkg object) {
            return SpecificPackageSupplierFactory.this.getLogicalFunctionPkg();
        }

        public Supplier<EObject> caseLogicalComponentPkg(LogicalComponentPkg object) {
            return SpecificPackageSupplierFactory.this.getLogicalComponentPkg();
        }

        public Supplier<EObject> caseLogicalComponent(LogicalComponent object) {
            return SpecificPackageSupplierFactory.this.getLogicalComponentPkg();
        }

        public Supplier<EObject> caseCapabilityRealization(CapabilityRealization object) {
            return SpecificPackageSupplierFactory.this.getCapabilityRealizationPkg();
        }

        public Supplier<EObject> caseCapabilityRealizationPkg(CapabilityRealizationPkg object) {
            return SpecificPackageSupplierFactory.this.getCapabilityRealizationPkg();
        }
    }

    class Oa
    extends OaSwitch<Supplier<EObject>> {
        Oa() {
        }

        public Supplier<EObject> caseOperationalActivityPkg(OperationalActivityPkg object) {
            return SpecificPackageSupplierFactory.this.getOperationalActivityPkg();
        }

        public Supplier<EObject> caseOperationalActivity(OperationalActivity object) {
            return SpecificPackageSupplierFactory.this.getOperationalActivityPkg();
        }

        public Supplier<EObject> caseOperationalCapabilityPkg(OperationalCapabilityPkg object) {
            return SpecificPackageSupplierFactory.this.getOperationalCapabilityPkg();
        }

        public Supplier<EObject> caseOperationalCapability(OperationalCapability object) {
            return SpecificPackageSupplierFactory.this.getOperationalCapabilityPkg();
        }

        public Supplier<EObject> caseRolePkg(RolePkg object) {
            return SpecificPackageSupplierFactory.this.getRolePkg();
        }

        public Supplier<EObject> caseRole(Role object) {
            return SpecificPackageSupplierFactory.this.getRolePkg();
        }

        public Supplier<EObject> caseEntityPkg(EntityPkg object) {
            return SpecificPackageSupplierFactory.this.getEntityPkg();
        }

        public Supplier<EObject> caseEntity(Entity object) {
            return SpecificPackageSupplierFactory.this.getEntityPkg();
        }
    }

    class Pa
    extends PaSwitch<Supplier<EObject>> {
        Pa() {
        }

        public Supplier<EObject> casePhysicalFunction(PhysicalFunction object) {
            return SpecificPackageSupplierFactory.this.getPhysicalFunctionPkg();
        }

        public Supplier<EObject> casePhysicalFunctionPkg(PhysicalFunctionPkg object) {
            return SpecificPackageSupplierFactory.this.getPhysicalFunctionPkg();
        }

        public Supplier<EObject> casePhysicalComponent(PhysicalComponent object) {
            return SpecificPackageSupplierFactory.this.getPhysicalComponentPkg();
        }

        public Supplier<EObject> casePhysicalComponentPkg(PhysicalComponentPkg object) {
            return SpecificPackageSupplierFactory.this.getPhysicalComponentPkg();
        }
    }
}

