/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.linkedtext.ui;

import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.polarsys.capella.common.linkedtext.ui.LinkedTextCompletionProposal;
import org.polarsys.capella.common.linkedtext.ui.LinkedTextDocument;

public class LinkedTextCompletionProcessor
implements IContentAssistProcessor,
ICompletionListener {
    private final IStructuredContentProvider _contentProvider;
    private boolean sessionStarted = false;
    private int sessionStartOffset = 0;

    public LinkedTextCompletionProcessor(IStructuredContentProvider provider) {
        this._contentProvider = provider;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ICompletionProposal[] result = null;
        LinkedTextDocument doc = (LinkedTextDocument)viewer.getDocument();
        if (this.sessionStarted) {
            this.sessionStarted = false;
            this.sessionStartOffset = offset;
        }
        try {
            if (this.sessionStartOffset <= offset) {
                String prefix = viewer.getDocument().get(this.sessionStartOffset, offset - this.sessionStartOffset).toLowerCase();
                ArrayList<LinkedTextCompletionProposal> res = new ArrayList<LinkedTextCompletionProposal>();
                if (this._contentProvider != null) {
                    Object[] objectArray = this._contentProvider.getElements(doc.getDocumentBase());
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        String text = doc.getLabelProvider().getText(element);
                        if (text != null && text.length() > 0 && (prefix.length() <= 0 || text.toLowerCase().contains(prefix))) {
                            res.add(new LinkedTextCompletionProposal(doc.getLabelProvider(), element, this.sessionStartOffset, offset, null, null));
                        }
                        ++n2;
                    }
                }
                if (res.size() > 0) {
                    result = res.toArray(new ICompletionProposal[res.size()]);
                }
            }
        }
        catch (BadLocationException exception) {
            exception.printStackTrace();
        }
        return result;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public void assistSessionStarted(ContentAssistEvent event) {
        this.sessionStarted = true;
    }

    public void assistSessionEnded(ContentAssistEvent event) {
        this.sessionStarted = false;
        this.sessionStartOffset = 0;
    }

    public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
    }
}

