/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.AbstractPhysicalLinkEnd;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ExchangeCategory;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.docgen.util.CapellaServices;
import org.polarsys.capella.docgen.util.StringUtil;

public class ExchangesServices {
    public static final String SOURCE_PORT_TREE_ID = "sourcePortTreeView";
    public static final String TARGET_PORT_TREE_ID = "targetPortTreeView";

    public static String getSource(CapellaElement element, String projectName, String outputFolder) {
        PhysicalPort port = null;
        if (element instanceof PhysicalLink) {
            port = ((PhysicalLink)element).getSourcePhysicalPort();
        } else if (element instanceof ComponentExchange) {
            port = ((ComponentExchange)element).getSourcePort();
        } else if (element instanceof FunctionalExchange) {
            port = ((FunctionalExchange)element).getSourceFunctionOutputPort();
        }
        return port != null ? ExchangesServices.getPort((CapellaElement)port, projectName, outputFolder, true) : "";
    }

    public static String getTarget(CapellaElement element, String projectName, String outputFolder) {
        PhysicalPort port = null;
        if (element instanceof PhysicalLink) {
            port = ((PhysicalLink)element).getTargetPhysicalPort();
        } else if (element instanceof ComponentExchange) {
            port = ((ComponentExchange)element).getTargetPort();
        } else if (element instanceof FunctionalExchange) {
            port = ((FunctionalExchange)element).getTargetFunctionInputPort();
        }
        return port != null ? ExchangesServices.getPort((CapellaElement)port, projectName, outputFolder, false) : "";
    }

    public static String getLinkEndsWithContainer(PhysicalLink link, String projectName, String outputFolder) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<ul class=\"generatedList\">");
        for (AbstractPhysicalLinkEnd end : link.getLinkEnds()) {
            buffer.append("<li>");
            buffer.append(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, (EObject)end));
            buffer.append("</li>");
            buffer.append("<ul class=\"generatedList\">");
            buffer.append("<li>");
            buffer.append(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, end.eContainer()));
            buffer.append("</li>");
            buffer.append("</ul>");
        }
        buffer.append("</ul>");
        return buffer.toString();
    }

    private static String getPort(CapellaElement port, String projectName, String outputFolder, boolean source) {
        StringBuilder sb = new StringBuilder();
        CapellaElement parent = (CapellaElement)port.eContainer();
        sb.append("<ul id=\"").append(source ? SOURCE_PORT_TREE_ID : TARGET_PORT_TREE_ID).append("\" class=\"treeview\">");
        sb.append("<li>");
        sb.append(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, (EObject)port));
        sb.append("<ul class=\"generatedList\">");
        sb.append("<li>");
        sb.append(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, (EObject)parent));
        sb.append("</li>");
        sb.append("</ul>");
        sb.append("</li>");
        sb.append("</ul>");
        return sb.toString();
    }

    public static String getAllocatedComponentExchanges(PhysicalLink element, String projectName, String outputFolder) {
        ArrayList<String> list = new ArrayList<String>();
        for (ComponentExchange ce : element.getAllocatedComponentExchanges()) {
            list.add(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, (EObject)ce));
        }
        return StringUtil.stringListToBulette(list);
    }

    public static boolean genAllocatedComponentExchanges(CapellaElement element) {
        if (element instanceof PhysicalLink) {
            return !((PhysicalLink)element).getAllocatedComponentExchanges().isEmpty();
        }
        return false;
    }

    public static String getAllocatedFunctionExchanges(ComponentExchange element, String projectName, String outputFolder) {
        ArrayList<String> list = new ArrayList<String>();
        for (FunctionalExchange fe : element.getAllocatedFunctionalExchanges()) {
            list.add(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, (EObject)fe));
        }
        return StringUtil.stringListToBulette(list);
    }

    public static boolean genAllocatedFunctionExchanges(CapellaElement element) {
        if (element instanceof ComponentExchange) {
            return !((ComponentExchange)element).getAllocatedFunctionalExchanges().isEmpty();
        }
        return false;
    }

    public static String getAllocatedExchangeItems(CapellaElement element, String projectName, String outputFolder) {
        ArrayList<String> list = new ArrayList<String>();
        if (element instanceof FunctionalExchange) {
            for (ExchangeItem ei : ((FunctionalExchange)element).getExchangedItems()) {
                list.add(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, (EObject)ei));
            }
        }
        if (element instanceof ComponentExchange) {
            for (ExchangeItem ei : ((ComponentExchange)element).getConvoyedInformations()) {
                list.add(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, (EObject)ei));
            }
        }
        return StringUtil.stringListToBulette(list);
    }

    public static boolean genAllocatedExchangeItems(CapellaElement element) {
        if (element instanceof FunctionalExchange) {
            return !((FunctionalExchange)element).getExchangedItems().isEmpty();
        }
        if (element instanceof ComponentExchange) {
            return !((ComponentExchange)element).getConvoyedInformations().isEmpty();
        }
        return false;
    }

    public static String getCategories(CapellaElement element, String projectName, String outputFolder) {
        ArrayList<String> list = new ArrayList<String>();
        if (element instanceof FunctionalExchange) {
            for (ExchangeCategory ecat : ((FunctionalExchange)element).getCategories()) {
                list.add(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, (EObject)ecat));
            }
        }
        if (element instanceof ComponentExchange) {
            for (ExchangeCategory ecat : ((ComponentExchange)element).getCategories()) {
                list.add(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, (EObject)ecat));
            }
        }
        if (element instanceof PhysicalLink) {
            for (ExchangeCategory ecat : ((PhysicalLink)element).getCategories()) {
                list.add(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, (EObject)ecat));
            }
        }
        return StringUtil.stringListToBulette(list);
    }

    public static boolean genCategories(CapellaElement element) {
        if (element instanceof FunctionalExchange) {
            return !((FunctionalExchange)element).getCategories().isEmpty();
        }
        if (element instanceof ComponentExchange) {
            return !((ComponentExchange)element).getCategories().isEmpty();
        }
        if (element instanceof PhysicalLink) {
            return !((PhysicalLink)element).getCategories().isEmpty();
        }
        return false;
    }
}

