/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.topdown.handlers.traceability.config;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacommon.Region;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.transition.common.handlers.traceability.ITraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.LevelBasedTraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.MappingTraceability;
import org.polarsys.capella.core.transition.common.handlers.traceability.config.ExtendedTraceabilityConfiguration;
import org.polarsys.capella.core.transition.system.handlers.traceability.LibraryTraceabilityHandler;
import org.polarsys.capella.core.transition.system.handlers.traceability.RealizationLinkTraceabilityHandler;
import org.polarsys.capella.core.transition.system.handlers.traceability.ReconciliationTraceabilityHandler;
import org.polarsys.capella.core.transition.system.helpers.ContextHelper;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class MergeSourceConfiguration
extends ExtendedTraceabilityConfiguration {
    protected String getExtensionIdentifier(IContext context) {
        return "sourceTraceabilityConfiguration";
    }

    protected void initHandlers(IContext fContext) {
        this.addHandler(fContext, (ITraceabilityHandler)new TopDownSourceReconciliationTraceabilityHandler(this.getIdentifier(fContext)));
        this.addHandler(fContext, (ITraceabilityHandler)new TopDownSourceSIDTraceabilityHandler(this.getIdentifier(fContext)));
        this.addHandler(fContext, (ITraceabilityHandler)new LibraryTraceabilityHandler());
    }

    public boolean useHandlerForSourceElements(EObject source, ITraceabilityHandler handler, IContext context) {
        boolean result = super.useHandlerForSourceElements(source, handler, context);
        if (result) {
            if (handler instanceof ReconciliationTraceabilityHandler) {
                if (source instanceof StateMachine) {
                    result = false;
                }
                if (source instanceof Region) {
                    result = false;
                }
            }
            if (handler instanceof RealizationLinkTraceabilityHandler) {
                if (source instanceof SystemEngineering) {
                    result = false;
                }
                if (source instanceof BlockArchitecture) {
                    result = false;
                }
            }
        }
        if (LibraryTraceabilityHandler.isLibraryElement((EObject)source, (IContext)context)) {
            return handler instanceof LibraryTraceabilityHandler;
        }
        return result;
    }

    public boolean useHandlerForTracedElements(EObject source, ITraceabilityHandler handler, IContext context) {
        boolean result = super.useHandlerForTracedElements(source, handler, context);
        if (result && handler instanceof RealizationLinkTraceabilityHandler) {
            if (source instanceof SystemEngineering) {
                result = false;
            } else if (source instanceof BlockArchitecture) {
                result = false;
            }
        }
        if (LibraryTraceabilityHandler.isLibraryElement((EObject)source, (IContext)context)) {
            return handler instanceof LibraryTraceabilityHandler;
        }
        return result;
    }

    public boolean useHandlerForAttachment(EObject source, EObject target, ITraceabilityHandler handler, IContext context) {
        if (handler instanceof ReconciliationTraceabilityHandler) {
            return false;
        }
        return super.useHandlerForAttachment(source, target, handler, context);
    }

    protected class TopDownSourceReconciliationTraceabilityHandler
    extends ReconciliationTraceabilityHandler {
        public TopDownSourceReconciliationTraceabilityHandler(String identifier) {
            super(identifier);
        }

        protected void initializeDataPkg(DataPkg source, DataPkg target, IContext context, LevelBasedTraceabilityHandler.LevelMappingTraceability map) {
            if (source.eClass().equals(target.eClass())) {
                this.addMapping((MappingTraceability)map, (EObject)source, (EObject)target, context);
            }
        }

        protected void initializeComponent(Component source, Component target, IContext context, LevelBasedTraceabilityHandler.LevelMappingTraceability map) {
            super.initializeComponent(source, target, context, map);
            if (source != null && target != null && !source.eClass().equals(target.eClass())) {
                this.addMapping((MappingTraceability)map, (EObject)ComponentExt.getDataPkg((Component)source, (boolean)false), (EObject)ComponentExt.getDataPkg((Component)target, (boolean)false), context);
                this.addMapping((MappingTraceability)map, (EObject)ComponentExt.getInterfacePkg((Component)source, (boolean)false), (EObject)ComponentExt.getInterfacePkg((Component)target, (boolean)false), context);
            }
        }

        protected void initializeBlockArchitecture(BlockArchitecture source, BlockArchitecture target, IContext context, LevelBasedTraceabilityHandler.LevelMappingTraceability map) {
            this.addMapping((MappingTraceability)map, (EObject)BlockArchitectureExt.getFunctionPkg((BlockArchitecture)source, (boolean)false), (EObject)BlockArchitectureExt.getFunctionPkg((BlockArchitecture)target, (boolean)false), context);
            this.addMapping((MappingTraceability)map, (EObject)BlockArchitectureExt.getRootFunction((BlockArchitecture)source, (boolean)false), (EObject)BlockArchitectureExt.getRootFunction((BlockArchitecture)target, (boolean)false), context);
            this.addMapping((MappingTraceability)map, (EObject)BlockArchitectureExt.getDataPkg((BlockArchitecture)source, (boolean)false), (EObject)BlockArchitectureExt.getDataPkg((BlockArchitecture)target, (boolean)false), context);
            this.addMapping((MappingTraceability)map, (EObject)BlockArchitectureExt.getComponentPkg((BlockArchitecture)source, (boolean)false), (EObject)BlockArchitectureExt.getComponentPkg((BlockArchitecture)target, (boolean)false), context);
            if (!(target instanceof PhysicalArchitecture) || source instanceof PhysicalArchitecture) {
                this.addMapping((MappingTraceability)map, (EObject)BlockArchitectureExt.getInterfacePkg((BlockArchitecture)source, (boolean)false), (EObject)BlockArchitectureExt.getInterfacePkg((BlockArchitecture)target, (boolean)false), context);
            }
            this.addMapping((MappingTraceability)map, (EObject)BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)source, (boolean)false), (EObject)BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)target, (boolean)false), context);
            this.addMapping((MappingTraceability)map, (EObject)source.getSystem(), (EObject)target.getSystem(), context);
        }

        protected void initializeRootMappings(IContext context) {
            super.initializeRootMappings(context);
            this.addMappings((EObject)ContextHelper.getSourceProject((IContext)context), (EObject)ContextHelper.getTransformedProject((IContext)context), context);
            this.addMappings((EObject)ContextHelper.getSourceEngineering((IContext)context), ContextHelper.getTransformedEngineering((IContext)context), context);
        }
    }

    protected class TopDownSourceSIDTraceabilityHandler
    extends RealizationLinkTraceabilityHandler {
        public TopDownSourceSIDTraceabilityHandler(String identifier) {
            super(identifier);
        }

        protected void initializeRootMappings(IContext context) {
            super.initializeRootMappings(context);
            this.initializeMappings((EObject)ContextHelper.getSourceProject((IContext)context), (EObject)ContextHelper.getTransformedProject((IContext)context), context);
        }
    }
}

