/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.eclipse.capella.ui.trace.views;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.ui.toolkit.viewers.menu.ModalContextMenuExtender;
import org.polarsys.capella.core.data.capellacommon.GenericTrace;
import org.polarsys.capella.core.data.capellacore.Trace;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.extension.TraceExtensionManager;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.messages.Messages;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.views.components.TraceTreeViewer;
import org.polarsys.capella.core.ui.properties.wizards.EditCapellaCustomPropertyWizard;
import org.polarsys.capella.core.ui.resources.CapellaUIResourcesPlugin;
import org.polarsys.capella.core.ui.toolkit.dialogs.CapellaWizardDialog;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class ViewEditPage
extends WizardPage {
    private TraceableElement _currentElt;
    private TraceTreeViewer _leftTraceViewer;
    private TraceTreeViewer _rightTraceViewer;
    private Text _statusBarText;

    public ViewEditPage(String pageName_p, TraceableElement currentElt_p) {
        super(pageName_p);
        this._currentElt = currentElt_p;
        this.setTitle(Messages.getString("ViewEditPage.title"));
        this.setCapellaImageDescriptor(currentElt_p);
    }

    public void setCapellaImageDescriptor(TraceableElement currentElt_p) {
        ImageDescriptor pngImageDescriptor = CapellaUIResourcesPlugin.getDefault().getPNGImage(currentElt_p.eClass());
        this.setImageDescriptor(pngImageDescriptor);
    }

    protected Composite createInternalComposite(Composite parent_p) {
        Composite composite = new Composite(parent_p, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        GridData gridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gridData);
        return composite;
    }

    public void createControl(Composite parent_p) {
        Composite composite = this.createInternalComposite(parent_p);
        Label currentNamedEltValueLabel = new Label(composite, 18440);
        if (this._currentElt instanceof AbstractNamedElement) {
            String name = ((AbstractNamedElement)this._currentElt).getName();
            currentNamedEltValueLabel.setText(name == null ? "" : name);
            this.setTitle(String.valueOf(Messages.getString("ViewEditPage.title")) + ((AbstractNamedElement)this._currentElt).getName());
            currentNamedEltValueLabel.setVisible(false);
        }
        Label imageExplanation = new Label(composite, 0x1000000);
        GridData gdData = new GridData();
        gdData.horizontalAlignment = 4;
        gdData.verticalAlignment = 0;
        gdData.grabExcessHorizontalSpace = true;
        gdData.grabExcessVerticalSpace = false;
        gdData.horizontalSpan = 2;
        imageExplanation.setLayoutData((Object)gdData);
        imageExplanation.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.polarsys.capella.core.platform.eclipse.ui.trace", (String)"icons/transparent_traceability.png").createImage());
        Composite traceTreeComposite = new Composite(composite, 4);
        traceTreeComposite.setLayout((Layout)new FillLayout());
        GridData data = new GridData(4, 4, true, true);
        traceTreeComposite.setLayoutData((Object)data);
        this._leftTraceViewer = new TraceTreeViewer(this._currentElt, TraceTreeViewer.TraceType.SOURCE_ELEMENT);
        this._leftTraceViewer.getControl(traceTreeComposite);
        this._leftTraceViewer.setWizardPage(this);
        this._rightTraceViewer = new TraceTreeViewer(this._currentElt, TraceTreeViewer.TraceType.TARGET_ELEMENT);
        this._rightTraceViewer.getControl(traceTreeComposite);
        this._rightTraceViewer.setWizardPage(this);
        MenuManager m = new MenuManager();
        Control c = this._leftTraceViewer.getClientViewer().getControl();
        m.setRemoveAllWhenShown(true);
        m.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                EditAction editAction = new EditAction(true);
                editAction.setText(Messages.getString("ViewEditPage.edit_menu.text"));
                manager.add((IContributionItem)new ActionContributionItem((IAction)editAction));
            }
        });
        ModalContextMenuExtender.registerContextMenu((MenuManager)m, (String)"org.polarsys.capella.core.platform.eclipse.capella.ui.trace.views.leftPane", (ISelectionProvider)this._leftTraceViewer.getClientViewer());
        c.setMenu(m.createContextMenu(c));
        MenuManager m2 = new MenuManager();
        Control c2 = this._rightTraceViewer.getClientViewer().getControl();
        m2.setRemoveAllWhenShown(true);
        c2.setMenu(m2.createContextMenu(c2));
        m2.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                EditAction editAction = new EditAction(false);
                editAction.setText(Messages.getString("ViewEditPage.edit_menu.text"));
                manager.add((IContributionItem)new ActionContributionItem((IAction)editAction));
            }
        });
        ModalContextMenuExtender.registerContextMenu((MenuManager)m2, (String)"org.polarsys.capella.core.platform.eclipse.capella.ui.trace.views.rightPane", (ISelectionProvider)this._rightTraceViewer.getClientViewer());
        this.createStatusTextField(composite);
        this._leftTraceViewer.addListener(new TraceTreeListener(this._rightTraceViewer));
        this._leftTraceViewer.addListener(new LabelListener(currentNamedEltValueLabel));
        this._rightTraceViewer.addListener(new TraceTreeListener(this._leftTraceViewer));
        this._rightTraceViewer.addListener(new LabelListener(currentNamedEltValueLabel));
        this.setControl((Control)composite);
    }

    private void createStatusTextField(Composite parent_p) {
        this._statusBarText = new Text(parent_p, 2056);
        this._statusBarText.setEditable(false);
        GridData gdData = new GridData();
        gdData.horizontalAlignment = 4;
        gdData.grabExcessHorizontalSpace = true;
        gdData.grabExcessVerticalSpace = false;
        gdData.horizontalSpan = 2;
        this._statusBarText.setLayoutData((Object)gdData);
    }

    public String getElementPath(Object object_p) {
        if (object_p instanceof TraceableElement) {
            TraceableElement element = (TraceableElement)object_p;
            SystemEngineering systemEngineering = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ExtensibleElement)element);
            return this.getPath(systemEngineering, element);
        }
        return "";
    }

    public String getPath(SystemEngineering sysEng_p, TraceableElement target_p) {
        String name = target_p instanceof AbstractNamedElement ? ((AbstractNamedElement)target_p).getName() : "";
        StringBuffer path = new StringBuffer(name == null ? "" : name);
        EObject container = target_p.eContainer();
        if (container instanceof TraceableElement) {
            TraceableElement parent = (TraceableElement)container;
            if (parent != sysEng_p) {
                path.insert(path.indexOf(path.toString()), String.valueOf(this.getPath(sysEng_p, parent)) + "::");
            } else {
                String parentName = parent instanceof AbstractNamedElement ? ((AbstractNamedElement)parent).getName() : "";
                path.insert(path.indexOf(path.toString()), String.valueOf(parentName) + "::");
            }
        }
        return path.toString();
    }

    private void updateStatusBar(Object element_p) {
        if (element_p == null) {
            this._statusBarText.setText("");
            return;
        }
        this._statusBarText.setText(this.getElementPath(element_p));
    }

    private class EditAction
    extends Action {
        private boolean isLeftPane = false;

        public EditAction(boolean isLeftPane) {
            this.isLeftPane = isLeftPane;
        }

        protected ISelection getSelection() {
            if (this.isLeftPane) {
                return ViewEditPage.this._leftTraceViewer.getClientViewer().getSelection();
            }
            return ViewEditPage.this._rightTraceViewer.getClientViewer().getSelection();
        }

        public boolean isEnabled() {
            IStructuredSelection selection = (IStructuredSelection)this.getSelection();
            if (!selection.isEmpty()) {
                Object a = selection.getFirstElement();
                return a instanceof GenericTrace || a instanceof EObject && TraceExtensionManager.eINSTANCE.canEdit((EObject)a);
            }
            return false;
        }

        public void runWithEvent(Event event) {
            super.runWithEvent(event);
            ISelection source = this.getSelection();
            Trace currentTrace = (Trace)((IStructuredSelection)source).getFirstElement();
            IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
            EditCapellaCustomPropertyWizard traceEditor = new EditCapellaCustomPropertyWizard(part, (EObject)currentTrace);
            CapellaWizardDialog dlg = new CapellaWizardDialog(ViewEditPage.this.getShell(), (IWizard)traceEditor);
            dlg.open();
        }
    }

    protected class LabelListener
    implements IDoubleClickListener {
        Label _namedEltLabel;

        public LabelListener(Label namedEltLabel_p) {
            this._namedEltLabel = namedEltLabel_p;
        }

        public void doubleClick(DoubleClickEvent event_p) {
            Object elem;
            ISelection selection = event_p.getSelection();
            if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && (elem = ((IStructuredSelection)selection).getFirstElement()) instanceof TraceableElement) {
                String name = elem instanceof AbstractNamedElement ? ((AbstractNamedElement)elem).getName() : "";
                this._namedEltLabel.setText(name == null ? "" : name);
                ViewEditPage.this.setTitle(String.valueOf(Messages.getString("ViewEditPage.title")) + (name == null ? "" : name));
                ViewEditPage.this.setCapellaImageDescriptor((TraceableElement)elem);
            }
        }
    }

    protected class TraceTreeListener
    extends MouseAdapter
    implements IDoubleClickListener,
    ISelectionChangedListener {
        TraceTreeViewer _traceTreeViewer;

        public TraceTreeListener(TraceTreeViewer traceTreeViewer_p) {
            this._traceTreeViewer = traceTreeViewer_p;
            this._traceTreeViewer._treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this._traceTreeViewer._treeViewer.getTree().addMouseListener((MouseListener)this);
        }

        public void doubleClick(DoubleClickEvent event_p) {
            Object elem;
            ISelection selection = event_p.getSelection();
            if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && (elem = ((IStructuredSelection)selection).getFirstElement()) instanceof TraceableElement) {
                this._traceTreeViewer.updateComponent((TraceableElement)elem);
            }
        }

        public void selectionChanged(SelectionChangedEvent event_p) {
            ISelection selection = event_p.getSelection();
            if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
                Object elem = ((IStructuredSelection)selection).getFirstElement();
                ViewEditPage.this.updateStatusBar(elem);
            }
        }

        public void mouseUp(MouseEvent e_p) {
        }
    }
}

