/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.validation.connection;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeRealization;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class MDCHK_Connection_Realization_1
extends AbstractValidationRule {
    private static final String UNKNOWN_LEVEL = "unknown level";

    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof ComponentExchange) {
            ComponentExchange exch = (ComponentExchange)eObj;
            if (CapellaLayerCheckingExt.isInPhysicalLayer((CapellaElement)exch)) {
                return ctx.createSuccessStatus();
            }
            for (AbstractTrace trace : exch.getIncomingTraces()) {
                if (!(trace instanceof ComponentExchangeRealization) || !(trace.getSourceElement() instanceof ComponentExchange)) continue;
                return ctx.createSuccessStatus();
            }
            String itemLevel = UNKNOWN_LEVEL;
            String otherItemLevel = UNKNOWN_LEVEL;
            BlockArchitecture architectureLevel = SystemEngineeringExt.getRootBlockArchitecture((ModelElement)exch);
            if (architectureLevel != null) {
                itemLevel = architectureLevel.getName();
                SystemEngineering systemEngineering = SystemEngineeringExt.getSystemEngineering((ExtensibleElement)architectureLevel);
                if (systemEngineering != null) {
                    LogicalArchitecture elem = null;
                    if (architectureLevel instanceof SystemAnalysis) {
                        elem = SystemEngineeringExt.getOwnedLogicalArchitecture((SystemEngineering)systemEngineering);
                    } else if (architectureLevel instanceof LogicalArchitecture) {
                        elem = SystemEngineeringExt.getOwnedPhysicalArchitecture((SystemEngineering)systemEngineering);
                    }
                    if (elem != null) {
                        otherItemLevel = elem.getName();
                    }
                }
            }
            return ctx.createFailureStatus(new Object[]{exch.getName(), itemLevel, otherItemLevel});
        }
        return ctx.createSuccessStatus();
    }
}

