/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.model.algorithms;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfaceImplementation;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.cs.InterfaceUse;
import org.polarsys.capella.core.data.ctx.SystemComponentPkg;
import org.polarsys.capella.core.data.helpers.information.services.ExchangeMechanismExt;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemInstance;
import org.polarsys.capella.core.data.information.ExchangeMechanism;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.data.information.communication.CommunicationFactory;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkProtocol;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.properties.dialogs.Messages;
import org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.model.algorithms.CompatibilityDefinition;
import org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.model.communications.AbstractCommunication;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.InterfaceExt;

public class CreationAlgorithms {
    public static final CreationAlgorithms INSTANCE = new CreationAlgorithms();
    protected CompatibilityDefinition compatibilityDef = CompatibilityDefinition.INSTANCE;

    public Interface createInterface(String interfaceName, InstanceRole sourceIR, InstanceRole targetIR, boolean isStructural) {
        Interface result = CsFactory.eINSTANCE.createInterface(interfaceName);
        result.setStructural(isStructural);
        EObject src = sourceIR != null ? sourceIR.getRepresentedInstance().eContainer() : null;
        EObject tgt = targetIR != null ? targetIR.getRepresentedInstance().eContainer() : null;
        BlockArchitecture container = null;
        if (src instanceof Component && tgt instanceof Component && !((Component)src).isActor() && !((Component)tgt).isActor()) {
            container = ComponentExt.getFirstCommonComponentOrPkgAncestor((EObject)src, (EObject)tgt);
        }
        if (src instanceof SystemComponentPkg && tgt instanceof SystemComponentPkg) {
            container = ComponentExt.getRootBlockArchitecture((ModelElement)((SystemComponentPkg)src));
        }
        if (sourceIR != null && ComponentExt.isActor((EObject)sourceIR.getRepresentedInstance())) {
            container = ComponentExt.getRootBlockArchitecture((ModelElement)sourceIR);
        } else if (targetIR != null && ComponentExt.isActor((EObject)targetIR.getRepresentedInstance())) {
            container = ComponentExt.getRootBlockArchitecture((ModelElement)targetIR);
        }
        EReference referenceInterfacePkg = null;
        referenceInterfacePkg = container instanceof BlockArchitecture ? CsPackage.Literals.BLOCK_ARCHITECTURE__OWNED_INTERFACE_PKG : CsPackage.Literals.BLOCK__OWNED_INTERFACE_PKG;
        if (container != null && container.eGet((EStructuralFeature)referenceInterfacePkg) == null) {
            container.eSet((EStructuralFeature)referenceInterfacePkg, (Object)CsFactory.eINSTANCE.createInterfacePkg(Messages.SelectOperationDialog_InterfacePkgName8));
        }
        if (container != null) {
            InterfacePkg pkg = (InterfacePkg)container.eGet((EStructuralFeature)referenceInterfacePkg);
            pkg.getOwnedInterfaces().add((Object)result);
        }
        CapellaElementExt.creationService((EObject)result);
        result.setName(interfaceName);
        return result;
    }

    public ExchangeItem createExchangeItem(String name, Interface itf, ExchangeMechanism exchangeMechanism) {
        ExchangeItem result = InformationFactory.eINSTANCE.createExchangeItem();
        EObject container = itf.eContainer();
        if (container instanceof InterfacePkg) {
            InterfacePkg ipkg = (InterfacePkg)container;
            ipkg.getOwnedExchangeItems().add((Object)result);
        } else {
            InterfaceExt.getRootOwnerInterfacePkg((Interface)itf).getOwnedExchangeItems().add((Object)result);
        }
        result.setExchangeMechanism(exchangeMechanism);
        CapellaElementExt.creationService((EObject)result);
        result.setName(name);
        return result;
    }

    public ExchangeItemAllocation createExchangeItemAllocationAndAllocateExchangeItem(ExchangeItem exchangeItem, Interface interface_, MessageKind _messageKind) {
        ExchangeItemAllocation result = InterfaceExt.addExchangeItem((Interface)interface_, (ExchangeItem)exchangeItem);
        if (_messageKind == MessageKind.SYNCHRONOUS_CALL) {
            result.setSendProtocol(CommunicationLinkProtocol.SYNCHRONOUS);
        }
        if (_messageKind == MessageKind.ASYNCHRONOUS_CALL) {
            result.setSendProtocol(CommunicationLinkProtocol.ASYNCHRONOUS);
        }
        if (_messageKind == MessageKind.CREATE) {
            result.setSendProtocol(CommunicationLinkProtocol.BROADCAST);
        }
        return result;
    }

    public boolean isGoodInterface(CapellaElement capellaElement, InstanceRole sourceIR, InstanceRole targetIR) {
        Interface interf = (Interface)capellaElement;
        AbstractType src = sourceIR == null ? null : sourceIR.getRepresentedInstance().getAbstractType();
        AbstractType tgt = targetIR == null ? null : targetIR.getRepresentedInstance().getAbstractType();
        Component srcComp = null;
        Component tgtComp = null;
        ExchangeItem ei = null;
        if (src instanceof Component) {
            srcComp = (Component)src;
        } else {
            ei = (ExchangeItem)src;
        }
        if (tgt instanceof Component) {
            tgtComp = (Component)tgt;
        } else {
            ei = (ExchangeItem)tgt;
        }
        if (ei == null) {
            return ComponentExt.isImplementingInterface((Component)tgtComp, (Interface)interf) && ComponentExt.isUsingInterface((Component)srcComp, (Interface)interf);
        }
        for (ExchangeItemAllocation eia : interf.getOwnedExchangeItemAllocations()) {
            if (eia.getAllocatedItem() != ei) continue;
            return true;
        }
        return false;
    }

    public String getDefaultInterfaceName(InstanceRole sourceIR, InstanceRole targetIR, List<Interface> existingInterfaces) {
        String baseName;
        StringBuilder builder = new StringBuilder();
        if (sourceIR != null && sourceIR.getRepresentedInstance() instanceof ExchangeItemInstance) {
            builder.append(sourceIR.getName());
            builder.append("_Interface");
        } else if (targetIR != null && targetIR.getRepresentedInstance() instanceof ExchangeItemInstance) {
            builder.append(targetIR.getName());
            builder.append("_Interface");
        } else {
            AbstractType abstractType;
            if (sourceIR != null && sourceIR.getRepresentedInstance() != null) {
                abstractType = sourceIR.getRepresentedInstance().getAbstractType();
                if (abstractType != null) {
                    builder.append(abstractType.getName());
                } else {
                    builder.append(sourceIR.getName());
                }
            }
            if (sourceIR != null && targetIR != null) {
                builder.append("_to_");
            }
            if (targetIR != null && targetIR.getRepresentedInstance() != null) {
                abstractType = targetIR.getRepresentedInstance().getAbstractType();
                if (abstractType != null) {
                    builder.append(abstractType.getName());
                } else {
                    builder.append(targetIR.getName());
                }
            }
        }
        String name = baseName = builder.toString();
        int index = 1;
        while (this.interfaceExistWithName(name, existingInterfaces)) {
            name = String.valueOf(baseName) + "_" + index;
            ++index;
        }
        return name;
    }

    public boolean interfaceExistWithName(String name, List<Interface> allInterfacesInBetweenSourceAndTarget) {
        for (Interface interfaze : allInterfacesInBetweenSourceAndTarget) {
            if (!interfaze.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public ExchangeItemAllocation getOrCreateAllocation(AbstractCommunication communication, MessageKind messageKind, boolean withReturn) {
        ExchangeMechanism mechanism = communication.exchangeItem.getExchangeMechanism();
        CommunicationLinkProtocol defaultSenderProtocol = this.compatibilityDef.getCompatibleProtocol(true, mechanism, messageKind, withReturn);
        CommunicationLinkProtocol defaultReceiverProtocol = this.compatibilityDef.getCompatibleProtocol(false, mechanism, messageKind, withReturn);
        ExchangeItemAllocation allocation = null;
        for (ExchangeItemAllocation existingAllocation : communication.interfaze.getOwnedExchangeItemAllocations()) {
            ExchangeItem item = existingAllocation.getAllocatedItem();
            if (item != communication.exchangeItem) continue;
            boolean isCandidate = true;
            if (communication.senderLink != null) {
                isCandidate = existingAllocation.getSendProtocol() == communication.senderLink.getProtocol();
            } else {
                boolean bl = isCandidate = existingAllocation.getSendProtocol() == defaultSenderProtocol;
            }
            if (!isCandidate) continue;
            if (communication.receiverLink != null) {
                isCandidate = existingAllocation.getReceiveProtocol() == communication.receiverLink.getProtocol();
            } else {
                boolean bl = isCandidate = existingAllocation.getReceiveProtocol() == defaultReceiverProtocol;
            }
            if (!isCandidate) continue;
            allocation = existingAllocation;
            break;
        }
        if (allocation == null) {
            allocation = CsFactory.eINSTANCE.createExchangeItemAllocation();
            allocation.setAllocatedItem(communication.exchangeItem);
            communication.interfaze.getOwnedExchangeItemAllocations().add((Object)allocation);
            if (communication.senderLink != null) {
                allocation.setSendProtocol(communication.senderLink.getProtocol());
            } else {
                allocation.setSendProtocol(defaultSenderProtocol);
            }
            if (communication.receiverLink != null) {
                allocation.setReceiveProtocol(communication.receiverLink.getProtocol());
            } else {
                allocation.setReceiveProtocol(defaultReceiverProtocol);
            }
            CapellaElementExt.creationService((EObject)allocation);
        }
        return allocation;
    }

    public void updateInterfaceCommunication(AbstractCommunication communication) {
        Component source = communication.source;
        Component target = communication.target;
        Interface interfaze = communication.interfaze;
        if (!ComponentExt.getAllUsedAndRequiredInterfaces((Component)source).contains(interfaze)) {
            InterfaceUse use = CsFactory.eINSTANCE.createInterfaceUse();
            use.setUsedInterface(interfaze);
            source.getOwnedInterfaceUses().add((Object)use);
            CapellaElementExt.creationService((EObject)use);
        }
        if (!ComponentExt.getAllImplementedAndProvidedInterfaces((Component)target).contains(interfaze)) {
            InterfaceImplementation implementation = CsFactory.eINSTANCE.createInterfaceImplementation();
            implementation.setImplementedInterface(interfaze);
            target.getOwnedInterfaceImplementations().add((Object)implementation);
            CapellaElementExt.creationService((EObject)implementation);
        }
    }

    public void updateLinkCommunication(AbstractCommunication communication, MessageKind messageKind, boolean withReturn) {
        CommunicationLink sender = communication.senderLink;
        if (sender == null) {
            sender = CommunicationFactory.eINSTANCE.createCommunicationLink();
            sender.setExchangeItem(communication.exchangeItem);
            sender.setKind(ExchangeMechanismExt.getKind((ExchangeMechanism)communication.exchangeItem.getExchangeMechanism(), (boolean)true));
            communication.source.getOwnedCommunicationLinks().add((Object)sender);
            CapellaElementExt.creationService((EObject)sender);
            communication.senderLink = sender;
        }
        sender.setProtocol(communication.exchangeItemAllocation.getSendProtocol());
        CommunicationLink receiver = communication.receiverLink;
        if (receiver == null) {
            receiver = CommunicationFactory.eINSTANCE.createCommunicationLink();
            receiver.setExchangeItem(communication.exchangeItem);
            receiver.setKind(ExchangeMechanismExt.getKind((ExchangeMechanism)communication.exchangeItem.getExchangeMechanism(), (boolean)false));
            communication.target.getOwnedCommunicationLinks().add((Object)receiver);
            CapellaElementExt.creationService((EObject)receiver);
            communication.receiverLink = receiver;
        }
        receiver.setProtocol(communication.exchangeItemAllocation.getReceiveProtocol());
    }
}

