/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.mappings;

import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.mappings.CheckedInChangeSetCollector;
import org.eclipse.team.internal.ccvs.ui.mappings.ModelParticipantChangeSetCapability;
import org.eclipse.team.internal.ccvs.ui.subscriber.CommitSetDialog;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class WorkspaceChangeSetCapability
extends ModelParticipantChangeSetCapability {
    public boolean supportsActiveChangeSets() {
        return true;
    }

    public boolean enableActiveChangeSetsFor(ISynchronizePageConfiguration configuration) {
        return this.supportsActiveChangeSets() && configuration.getMode() != 1;
    }

    public ActiveChangeSet createChangeSet(ISynchronizePageConfiguration configuration, IDiff[] infos) {
        ActiveChangeSet set = this.getActiveChangeSetManager().createSet(CVSUIMessages.WorkspaceChangeSetCapability_1, new IDiff[0]);
        CommitSetDialog dialog = new CommitSetDialog(configuration.getSite().getShell(), set, this.getResources(infos), 0);
        dialog.open();
        if (dialog.getReturnCode() != 0) {
            return null;
        }
        set.add(infos);
        return set;
    }

    private IResource[] getResources(IDiff[] diffs) {
        HashSet<IResource> result = new HashSet<IResource>();
        IDiff[] iDiffArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            IDiff diff = iDiffArray[n2];
            IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
            if (resource != null) {
                result.add(resource);
            }
            ++n2;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public void editChangeSet(ISynchronizePageConfiguration configuration, ActiveChangeSet set) {
        CommitSetDialog dialog = new CommitSetDialog(configuration.getSite().getShell(), set, set.getResources(), 1);
        dialog.open();
        if (dialog.getReturnCode() != 0) {
            return;
        }
    }

    public ActiveChangeSetManager getActiveChangeSetManager() {
        return CVSUIPlugin.getPlugin().getChangeSetManager();
    }

    @Override
    public CheckedInChangeSetCollector createCheckedInChangeSetCollector(ISynchronizePageConfiguration configuration) {
        return new CheckedInChangeSetCollector(configuration, (Subscriber)CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber());
    }
}

