/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.pa.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.cs.ArchitectureAllocation;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.helpers.cs.delegates.BlockArchitectureHelper;
import org.polarsys.capella.core.data.la.CapabilityRealizationPkg;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.pa.LogicalArchitectureRealization;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalFunctionPkg;

public class PhysicalArchitectureHelper {
    private static PhysicalArchitectureHelper instance;

    private PhysicalArchitectureHelper() {
    }

    public static PhysicalArchitectureHelper getInstance() {
        if (instance == null) {
            instance = new PhysicalArchitectureHelper();
        }
        return instance;
    }

    public Object doSwitch(PhysicalArchitecture element, EStructuralFeature feature) {
        Object ret = null;
        if (feature.equals(PaPackage.Literals.PHYSICAL_ARCHITECTURE__ALLOCATED_LOGICAL_ARCHITECTURE_REALIZATIONS)) {
            ret = this.getAllocatedLogicalArchitectureRealizations(element);
        } else if (feature.equals(PaPackage.Literals.PHYSICAL_ARCHITECTURE__CONTAINED_CAPABILITY_REALIZATION_PKG)) {
            ret = this.getContainedCapabilityRealizationPkg(element);
        } else if (feature.equals(PaPackage.Literals.PHYSICAL_ARCHITECTURE__CONTAINED_PHYSICAL_FUNCTION_PKG)) {
            ret = this.getContainedPhysicalFunctionPkg(element);
        } else if (feature.equals(PaPackage.Literals.PHYSICAL_ARCHITECTURE__ALLOCATED_LOGICAL_ARCHITECTURES)) {
            ret = this.getAllocatedLogicalArchitectures(element);
        } else if (feature.equals(PaPackage.Literals.PHYSICAL_ARCHITECTURE__ALLOCATING_EPBS_ARCHITECTURES)) {
            ret = this.getAllocatingEpbsArchitectures(element);
        }
        if (ret == null) {
            ret = BlockArchitectureHelper.getInstance().doSwitch((BlockArchitecture)element, feature);
        }
        return ret;
    }

    protected List<LogicalArchitectureRealization> getAllocatedLogicalArchitectureRealizations(PhysicalArchitecture element) {
        ArrayList<LogicalArchitectureRealization> ret = new ArrayList<LogicalArchitectureRealization>();
        for (ArchitectureAllocation architectureAllocation : element.getProvisionedArchitectureAllocations()) {
            if (!(architectureAllocation instanceof LogicalArchitectureRealization)) continue;
            ret.add((LogicalArchitectureRealization)architectureAllocation);
        }
        return ret;
    }

    protected CapabilityRealizationPkg getContainedCapabilityRealizationPkg(PhysicalArchitecture element) {
        AbstractCapabilityPkg abstractCapabilityPkg = element.getOwnedAbstractCapabilityPkg();
        if (abstractCapabilityPkg instanceof CapabilityRealizationPkg) {
            return (CapabilityRealizationPkg)abstractCapabilityPkg;
        }
        return null;
    }

    protected PhysicalFunctionPkg getContainedPhysicalFunctionPkg(PhysicalArchitecture element) {
        FunctionPkg functionPkg = element.getOwnedFunctionPkg();
        if (functionPkg instanceof PhysicalFunctionPkg) {
            return (PhysicalFunctionPkg)functionPkg;
        }
        return null;
    }

    protected List<LogicalArchitecture> getAllocatedLogicalArchitectures(PhysicalArchitecture element) {
        ArrayList<LogicalArchitecture> ret = new ArrayList<LogicalArchitecture>();
        for (BlockArchitecture architecture : element.getAllocatedArchitectures()) {
            if (!(architecture instanceof LogicalArchitecture)) continue;
            ret.add((LogicalArchitecture)architecture);
        }
        return ret;
    }

    protected List<EPBSArchitecture> getAllocatingEpbsArchitectures(PhysicalArchitecture element) {
        ArrayList<EPBSArchitecture> ret = new ArrayList<EPBSArchitecture>();
        for (BlockArchitecture architecture : element.getAllocatingArchitectures()) {
            if (!(architecture instanceof EPBSArchitecture)) continue;
            ret.add((EPBSArchitecture)architecture);
        }
        return ret;
    }
}

