/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.la.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.core.data.capellacommon.CapabilityRealizationInvolvedElement;
import org.polarsys.capella.core.data.capellacommon.CapabilityRealizationInvolvement;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.helpers.interaction.delegates.AbstractCapabilityHelper;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.AbstractCapabilityRealization;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.la.LaPackage;

public class CapabilityRealizationHelper {
    private static CapabilityRealizationHelper instance;

    private CapabilityRealizationHelper() {
    }

    public static CapabilityRealizationHelper getInstance() {
        if (instance == null) {
            instance = new CapabilityRealizationHelper();
        }
        return instance;
    }

    public Object doSwitch(CapabilityRealization element, EStructuralFeature feature) {
        List<CapabilityRealization> ret = null;
        if (feature.equals(LaPackage.Literals.CAPABILITY_REALIZATION__INVOLVED_COMPONENTS)) {
            ret = this.getInvolvedComponents(element);
        } else if (feature.equals(LaPackage.Literals.CAPABILITY_REALIZATION__REALIZED_CAPABILITIES)) {
            ret = this.getRealizedCapabilities(element);
        } else if (feature.equals(LaPackage.Literals.CAPABILITY_REALIZATION__REALIZED_CAPABILITY_REALIZATIONS)) {
            ret = this.getRealizedCapabilityRealizations(element);
        } else if (feature.equals(LaPackage.Literals.CAPABILITY_REALIZATION__REALIZING_CAPABILITY_REALIZATIONS)) {
            ret = this.getRealizingCapabilityRealizations(element);
        }
        if (ret == null) {
            ret = AbstractCapabilityHelper.getInstance().doSwitch((AbstractCapability)element, feature);
        }
        return ret;
    }

    protected List<CapabilityRealizationInvolvedElement> getInvolvedComponents(CapabilityRealization element) {
        ArrayList<CapabilityRealizationInvolvedElement> ret = new ArrayList<CapabilityRealizationInvolvedElement>();
        for (CapabilityRealizationInvolvement involvement : element.getOwnedCapabilityRealizationInvolvements()) {
            CapabilityRealizationInvolvedElement involvedCapabilityRealizationInvolvedElement = involvement.getInvolvedCapabilityRealizationInvolvedElement();
            if (involvedCapabilityRealizationInvolvedElement == null) continue;
            ret.add(involvedCapabilityRealizationInvolvedElement);
        }
        return ret;
    }

    protected List<Capability> getRealizedCapabilities(CapabilityRealization element) {
        ArrayList<Capability> ret = new ArrayList<Capability>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            AbstractCapability capability;
            if (!(trace instanceof AbstractCapabilityRealization) || !((capability = ((AbstractCapabilityRealization)trace).getRealizedCapability()) instanceof Capability)) continue;
            ret.add((Capability)capability);
        }
        return ret;
    }

    protected List<CapabilityRealization> getRealizedCapabilityRealizations(CapabilityRealization element) {
        ArrayList<CapabilityRealization> ret = new ArrayList<CapabilityRealization>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            AbstractCapability capability;
            if (!(trace instanceof AbstractCapabilityRealization) || !((capability = ((AbstractCapabilityRealization)trace).getRealizedCapability()) instanceof CapabilityRealization)) continue;
            ret.add((CapabilityRealization)capability);
        }
        return ret;
    }

    protected List<CapabilityRealization> getRealizingCapabilityRealizations(CapabilityRealization element) {
        ArrayList<CapabilityRealization> ret = new ArrayList<CapabilityRealization>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            AbstractCapability capability;
            if (!(trace instanceof AbstractCapabilityRealization) || !((capability = ((AbstractCapabilityRealization)trace).getRealizingCapability()) instanceof CapabilityRealization)) continue;
            ret.add((CapabilityRealization)capability);
        }
        return ret;
    }
}

