/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.capellamodeller.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellacore.Structure;
import org.polarsys.capella.core.data.capellamodeller.CapellamodellerPackage;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.StructureHelper;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.sharedmodel.SharedPkg;

public class SystemEngineeringHelper {
    private static SystemEngineeringHelper instance;

    private SystemEngineeringHelper() {
    }

    public static SystemEngineeringHelper getInstance() {
        if (instance == null) {
            instance = new SystemEngineeringHelper();
        }
        return instance;
    }

    public Object doSwitch(SystemEngineering element, EStructuralFeature feature) {
        List<LogicalArchitecture> ret = null;
        if (feature.equals(CapellamodellerPackage.Literals.SYSTEM_ENGINEERING__CONTAINED_OPERATIONAL_ANALYSIS)) {
            ret = this.getContainedOperationalAnalysis(element);
        } else if (feature.equals(CapellamodellerPackage.Literals.SYSTEM_ENGINEERING__CONTAINED_SYSTEM_ANALYSIS)) {
            ret = this.getContainedSystemAnalysis(element);
        } else if (feature.equals(CapellamodellerPackage.Literals.SYSTEM_ENGINEERING__CONTAINED_LOGICAL_ARCHITECTURES)) {
            ret = this.getContainedLogicalArchitectures(element);
        } else if (feature.equals(CapellamodellerPackage.Literals.SYSTEM_ENGINEERING__CONTAINED_PHYSICAL_ARCHITECTURES)) {
            ret = this.getContainedPhysicalArchitectures(element);
        } else if (feature.equals(CapellamodellerPackage.Literals.SYSTEM_ENGINEERING__CONTAINED_EPBS_ARCHITECTURES)) {
            ret = this.getContainedEPBSArchitectures(element);
        } else if (feature.equals(CapellamodellerPackage.Literals.SYSTEM_ENGINEERING__CONTAINED_SHARED_PKGS)) {
            ret = this.getContainedSharedPkgs(element);
        }
        if (ret == null) {
            ret = StructureHelper.getInstance().doSwitch((Structure)element, feature);
        }
        return ret;
    }

    protected List<OperationalAnalysis> getContainedOperationalAnalysis(SystemEngineering element) {
        ArrayList<OperationalAnalysis> res = new ArrayList<OperationalAnalysis>();
        for (ModellingArchitecture architecture : element.getOwnedArchitectures()) {
            if (!(architecture instanceof OperationalAnalysis)) continue;
            res.add((OperationalAnalysis)architecture);
        }
        return res;
    }

    protected List<SystemAnalysis> getContainedSystemAnalysis(SystemEngineering element) {
        ArrayList<SystemAnalysis> res = new ArrayList<SystemAnalysis>();
        for (ModellingArchitecture architecture : element.getOwnedArchitectures()) {
            if (!(architecture instanceof SystemAnalysis)) continue;
            res.add((SystemAnalysis)architecture);
        }
        return res;
    }

    protected List<LogicalArchitecture> getContainedLogicalArchitectures(SystemEngineering element) {
        ArrayList<LogicalArchitecture> res = new ArrayList<LogicalArchitecture>();
        for (ModellingArchitecture architecture : element.getOwnedArchitectures()) {
            if (!(architecture instanceof LogicalArchitecture)) continue;
            res.add((LogicalArchitecture)architecture);
        }
        return res;
    }

    protected List<PhysicalArchitecture> getContainedPhysicalArchitectures(SystemEngineering element) {
        ArrayList<PhysicalArchitecture> res = new ArrayList<PhysicalArchitecture>();
        for (ModellingArchitecture architecture : element.getOwnedArchitectures()) {
            if (!(architecture instanceof PhysicalArchitecture)) continue;
            res.add((PhysicalArchitecture)architecture);
        }
        return res;
    }

    protected List<EPBSArchitecture> getContainedEPBSArchitectures(SystemEngineering element) {
        ArrayList<EPBSArchitecture> res = new ArrayList<EPBSArchitecture>();
        for (ModellingArchitecture architecture : element.getOwnedArchitectures()) {
            if (!(architecture instanceof EPBSArchitecture)) continue;
            res.add((EPBSArchitecture)architecture);
        }
        return res;
    }

    protected List<SharedPkg> getContainedSharedPkgs(SystemEngineering element) {
        ArrayList<SharedPkg> res = new ArrayList<SharedPkg>();
        for (ModellingArchitecture architecture : element.getOwnedArchitectures()) {
            if (!(architecture instanceof SharedPkg)) continue;
            res.add((SharedPkg)architecture);
        }
        return res;
    }
}

