/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.progress.internal;

import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.progress.IProgressConstants;
import org.eclipse.e4.ui.progress.IProgressService;
import org.eclipse.e4.ui.progress.internal.ProgressMessages;
import org.eclipse.e4.ui.progress.internal.ProgressMonitorJobsDialog;
import org.eclipse.e4.ui.progress.internal.Services;
import org.eclipse.e4.ui.progress.internal.legacy.StatusUtil;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ProgressManagerUtil {
    public static long SHORT_OPERATION_TIME = 250L;
    static final QualifiedName KEEP_PROPERTY = IProgressConstants.KEEP_PROPERTY;
    static final QualifiedName KEEPONE_PROPERTY = IProgressConstants.KEEPONE_PROPERTY;
    static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    static final QualifiedName INFRASTRUCTURE_PROPERTY = new QualifiedName("org.eclipse.e4.ui.progress", "INFRASTRUCTURE_PROPERTY");
    private static String ellipsis = ProgressMessages.ProgressFloatingWindow_EllipsisValue;

    static IStatus exceptionStatus(Throwable exception) {
        return StatusUtil.newStatus(4, exception.getMessage() == null ? "" : exception.getMessage(), exception);
    }

    static void logException(Throwable exception) {
        IStatus status = Status.error((String)(exception.getMessage() == null ? "" : exception.getMessage()), (Throwable)exception);
        Platform.getLog(ProgressManagerUtil.class).log(status);
    }

    public static ViewerComparator getProgressViewerComparator() {
        return new ProgressViewerComparator();
    }

    public static void openProgressView() {
        Services services = Services.getInstance();
        MPart progressView = (MPart)services.getModelService().find("org.eclipse.e4.ui.progress.ProgressView", (MUIElement)services.getMWindow());
        EPartService partService = services.getPartService();
        if (progressView == null && (progressView = partService.createPart("org.eclipse.e4.ui.progress.ProgressView")) != null) {
            partService.showPart(progressView, EPartService.PartState.VISIBLE);
        }
        if (progressView == null) {
            return;
        }
        partService.activate(progressView);
    }

    static String shortenText(String textValue, Control control) {
        if (textValue == null) {
            return null;
        }
        GC gc = new GC((Drawable)control);
        int maxExtent = gc.textExtent((String)textValue).x;
        int maxWidth = control.getBounds().width - 5;
        if (maxExtent < maxWidth) {
            gc.dispose();
            return textValue;
        }
        int length = textValue.length();
        int charsToClip = Math.round(0.95f * (float)length * (1.0f - (float)maxWidth / (float)maxExtent));
        int secondWord = ProgressManagerUtil.findSecondWhitespace(textValue, gc, maxWidth);
        int pivot = (length - secondWord) / 2 + secondWord;
        int start = pivot - charsToClip / 2;
        int end = pivot + charsToClip / 2 + 1;
        while (start >= 0 && end < length) {
            String s1 = textValue.substring(0, start);
            String s2 = textValue.substring(end, length);
            String s = String.valueOf(s1) + ellipsis + s2;
            int l = gc.textExtent((String)s).x;
            if (l < maxWidth) {
                gc.dispose();
                return s;
            }
            --start;
            ++end;
        }
        gc.dispose();
        return textValue;
    }

    private static int findSecondWhitespace(String textValue, GC gc, int maxWidth) {
        int firstCharacter = 0;
        char[] chars = textValue.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (Character.isWhitespace(chars[i])) {
                firstCharacter = i;
                break;
            }
            ++i;
        }
        if (firstCharacter == 0) {
            return 0;
        }
        int secondCharacter = firstCharacter;
        int i2 = firstCharacter;
        while (i2 < chars.length) {
            if (Character.isWhitespace(chars[i2])) {
                secondCharacter = i2;
                break;
            }
            ++i2;
        }
        if (gc.textExtent((String)textValue.substring((int)0, (int)secondCharacter)).x > maxWidth) {
            if (gc.textExtent((String)textValue.substring((int)0, (int)firstCharacter)).x > maxWidth) {
                return 0;
            }
            return firstCharacter;
        }
        return secondCharacter;
    }

    public static boolean rescheduleIfModalShellOpen(Job openJob, IProgressService progressService) {
        Shell modal = ProgressManagerUtil.getModalShellExcluding(null);
        if (modal == null) {
            return false;
        }
        openJob.schedule((long)progressService.getLongOperationTime());
        return true;
    }

    public static boolean safeToOpen(ProgressMonitorJobsDialog dialog, Shell excludedShell) {
        Shell modal = ProgressManagerUtil.getModalShellExcluding(excludedShell);
        if (modal == null) {
            return true;
        }
        dialog.watchTicks();
        return false;
    }

    public static Shell getModalShellExcluding(Shell shell) {
        if (shell == null || shell.isDisposed()) {
            return ProgressManagerUtil.getModalChildExcluding(Services.getInstance().getShell().getShells(), shell);
        }
        return ProgressManagerUtil.getModalChildExcluding(shell.getShells(), shell);
    }

    private static Shell getModalChildExcluding(Shell[] toSearch, Shell toExclude) {
        int modal = 229376;
        int i = toSearch.length - 1;
        while (i >= 0) {
            Shell shell = toSearch[i];
            if (!shell.equals(toExclude) && !shell.isDisposed()) {
                Shell[] children = shell.getShells();
                Shell modalChild = ProgressManagerUtil.getModalChildExcluding(children, toExclude);
                if (modalChild != null) {
                    return modalChild;
                }
                if (shell.isVisible() && (shell.getStyle() & modal) != 0) {
                    return shell;
                }
            }
            --i;
        }
        return null;
    }

    public static Shell getDefaultParent() {
        Shell modal = ProgressManagerUtil.getModalShellExcluding(null);
        if (modal != null) {
            return modal;
        }
        return ProgressManagerUtil.getNonModalShell();
    }

    public static Shell getNonModalShell() {
        Object widget;
        MApplication application = Services.getInstance().getMApplication();
        if (application == null) {
            return null;
        }
        MWindow window = (MWindow)application.getSelectedElement();
        if (window != null && (widget = window.getWidget()) instanceof Shell) {
            return (Shell)widget;
        }
        for (MWindow child : application.getChildren()) {
            Object widget2 = child.getWidget();
            if (!(widget2 instanceof Shell)) continue;
            return (Shell)widget2;
        }
        return null;
    }

    static class ProgressViewerComparator
    extends ViewerComparator {
        ProgressViewerComparator() {
        }

        public int compare(Viewer testViewer, Object e1, Object e2) {
            return ((Comparable)e1).compareTo(e2);
        }

        public void sort(Viewer viewer, Object[] elements) {
            int retries = 3;
            while (retries > 0) {
                try {
                    Arrays.sort(elements, (a, b) -> this.compare(viewer, a, b));
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    --retries;
                }
            }
            super.sort(viewer, elements);
        }
    }
}

