/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.appenders.reportlogview;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.AbstractMarkerViewContentProvider;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.IViewerRefresh;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewHelper;

class CanonicalContentProvider
extends AbstractMarkerViewContentProvider
implements ITreeContentProvider {
    private List<IMarker> markers;

    public CanonicalContentProvider(TreeViewer viewer, MarkerViewHelper helper, IViewerRefresh refresh) {
        super(viewer, helper, refresh);
        this.refillCache();
    }

    private void refillCache() {
        this.markers = new ArrayList<IMarker>();
        for (IMarker marker : this.findMarkers()) {
            this.markerAddedIntern(marker);
        }
    }

    public Object getParent(Object element) {
        Object result = null;
        if (element != this.viewer.getInput()) {
            result = this.viewer.getInput();
        }
        return result;
    }

    public synchronized Object[] getElements(Object inputElement) {
        return this.markers.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        return this.noChildren;
    }

    public boolean hasChildren(Object element) {
        return element == this.viewer.getInput();
    }

    private void markerAddedIntern(IMarker marker) {
        this.markers.add(marker);
        this.viewerRefresh.refresh();
    }

    @Override
    public synchronized void markerAdded(IMarker marker) {
        this.markerAddedIntern(marker);
    }

    @Override
    public synchronized void markerDeleted(IMarker marker) {
        this.markers.remove(marker);
        this.viewerRefresh.refresh();
    }
}

