/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration.cmdline;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.polarsys.capella.core.commandline.core.CommandLineException;
import org.polarsys.capella.core.commandline.core.DefaultCommandLine;
import org.polarsys.capella.core.data.migration.MigrationConstants;
import org.polarsys.capella.core.data.migration.MigrationHelpers;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;

public class MigrationCommandLine
extends DefaultCommandLine {
    private Display display;

    public boolean execute(IApplicationContext context) throws CommandLineException {
        this.display = PlatformUI.createDisplay();
        PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)new WorkbenchAdvisor(){

            public String getInitialWindowPerspectiveId() {
                return null;
            }

            public void postStartup() {
                super.postStartup();
                MigrationCommandLine.this.migrateAllImportedProjects(MigrationCommandLine.this.display.getActiveShell());
                PlatformUI.getWorkbench().close();
            }
        });
        return true;
    }

    public void migrateAllImportedProjects(Shell shell) {
        Set capellaProjects = this.getProjectsFromInput().stream().filter(CapellaResourceHelper::isCapellaProject).collect(Collectors.toSet());
        for (IProject project : capellaProjects) {
            try {
                if (this.argHelper.isBackupNeeded()) {
                    MigrationHelpers.getInstance().trigger((IResource)project, shell, true, false, MigrationConstants.DEFAULT_KIND_ORDER);
                    continue;
                }
                MigrationHelpers.getInstance().trigger((IResource)project, shell, true, true, false, false, MigrationConstants.DEFAULT_KIND_ORDER);
            }
            catch (Exception e) {
                this.logError("Error during migration of " + project.getName());
            }
        }
    }

    @Deprecated
    public void setRefreshPrefs() {
    }

    public void printHelp() {
        super.printHelp();
        this.printArgumentsFromTable("migrationParameters", false, Collections.emptyList());
    }

    public void compliancyCheck(IFile modeller) throws CommandLineException {
    }
}

