/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration.capella;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.core.data.migration.contribution.AbstractMigrationContribution;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;

public class LegacyResourceMigrationContribution
extends AbstractMigrationContribution {
    @Override
    public Object getValue(EObject peekObject, EStructuralFeature feature, Object value, int position, Resource resource, MigrationContext context) {
        String semanticResourceString;
        IPath semanticResourcePath;
        if (peekObject instanceof DAnalysis && ViewpointPackage.Literals.DANALYSIS__SEMANTIC_RESOURCES.equals(feature) && value instanceof String && CapellaResourceHelper.isLegacyCapellaResourcePath((IPath)(semanticResourcePath = Path.fromPortableString((String)(semanticResourceString = (String)value))))) {
            IPath mondernPath = CapellaResourceHelper.convertLegacyResourcePathToModern((IPath)semanticResourcePath);
            return mondernPath.toPortableString();
        }
        return super.getValue(peekObject, feature, value, position, resource, context);
    }

    @Override
    public void updateElement(EObject peekObject, String typeName, EObject result, EStructuralFeature feature, Resource resource, MigrationContext context) {
        if (result instanceof InternalEObject && result.eIsProxy()) {
            String platformString;
            IPath platformPath;
            InternalEObject internalObject = (InternalEObject)result;
            URI internalObjectURI = internalObject.eProxyURI();
            if (internalObjectURI.isPlatformResource() && CapellaResourceHelper.isLegacyCapellaResourcePath((IPath)(platformPath = Path.fromPortableString((String)(platformString = internalObjectURI.toPlatformString(true)))))) {
                IPath mondernPath = CapellaResourceHelper.convertLegacyResourcePathToModern((IPath)platformPath);
                String modernPathString = mondernPath.toPortableString();
                String fragment = internalObjectURI.fragment();
                URI modernURI = URI.createPlatformResourceURI((String)modernPathString, (boolean)true).appendFragment(fragment);
                internalObject.eSetProxyURI(modernURI);
            }
        } else {
            super.updateElement(peekObject, typeName, result, feature, resource, context);
        }
    }

    @Override
    public String getHandleProxy(InternalEObject proxy, String uriLiteral, Resource resource, XMLHelper helper, MigrationContext context) {
        if (this.isLegacyURILiteral(uriLiteral)) {
            return this.convertLegacyURILiteralToModern(uriLiteral);
        }
        return super.getHandleProxy(proxy, uriLiteral, resource, helper, context);
    }

    private boolean isLegacyURILiteral(String uriLiteral) {
        Set legacyExtensions = CapellaResourceHelper.LEGACY_TO_MODERN_FILE_EXTENSIONS.keySet();
        for (String legacyExtension : legacyExtensions) {
            if (!uriLiteral.contains(legacyExtension)) continue;
            return true;
        }
        return false;
    }

    private String convertLegacyURILiteralToModern(String uriLiteral) {
        String modernLiteral = uriLiteral;
        for (Map.Entry entry : CapellaResourceHelper.LEGACY_TO_MODERN_FILE_EXTENSIONS.entrySet()) {
            String legacyExtension = (String)entry.getKey();
            String modernExtension = (String)entry.getValue();
            modernLiteral = modernLiteral.replace(legacyExtension, modernExtension);
        }
        return modernLiteral;
    }
}

