/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.libraries;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AccessPolicy implements Enumerator
{
    READ_ONLY(0, "readOnly", "readOnly"),
    READ_AND_WRITE(1, "readAndWrite", "readAndWrite");

    public static final int READ_ONLY_VALUE = 0;
    public static final int READ_AND_WRITE_VALUE = 1;
    private static final AccessPolicy[] VALUES_ARRAY;
    public static final List<AccessPolicy> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AccessPolicy[]{READ_ONLY, READ_AND_WRITE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AccessPolicy get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AccessPolicy result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AccessPolicy getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AccessPolicy result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AccessPolicy get(int value) {
        switch (value) {
            case 0: {
                return READ_ONLY;
            }
            case 1: {
                return READ_AND_WRITE;
            }
        }
        return null;
    }

    private AccessPolicy(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

