/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.libraries.ui.views.libraryManager.accessPolicyManager;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.libraries.properties.LibraryManagerModel;
import org.polarsys.capella.core.libraries.ui.views.libraryManager.accessPolicyManager.AccessPolicyEditingSupport;
import org.polarsys.capella.core.libraries.ui.views.libraryManager.accessPolicyManager.AccessPolicyLabelProvider;

public class AccessPolicyManagerWidget {
    private static final String LIBRARY_COLUMN_NAME = "Library";
    private static final String ACCESS_POLICY_COLUMN_NAME = "Access Policy";
    protected Table table;
    protected TableViewer tableViewer;
    protected LibraryManagerModel model;
    private IProperty property;
    private IRendererContext rendererContext;
    private TableViewerColumn accessPolicyColumn;

    public AccessPolicyManagerWidget(Composite parent) {
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        this.table = new Table(parent, 68096);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayout((Layout)tableLayout);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        TableViewerColumn labelPolicyColumn = new TableViewerColumn(this.tableViewer, 0);
        labelPolicyColumn.getColumn().setText(LIBRARY_COLUMN_NAME);
        this.accessPolicyColumn = new TableViewerColumn(this.tableViewer, 0);
        this.accessPolicyColumn.getColumn().setWidth(20);
        this.accessPolicyColumn.getColumn().setText(ACCESS_POLICY_COLUMN_NAME);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
    }

    public void initializeView(LibraryManagerModel model_, IProperty property_, IRendererContext rendererContext_) {
        this.model = model_;
        this.property = property_;
        this.rendererContext = rendererContext_;
        this.accessPolicyColumn.setEditingSupport((EditingSupport)new AccessPolicyEditingSupport(this.accessPolicyColumn.getViewer(), this.model, this));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AccessPolicyLabelProvider(this.model));
        this.accessPolicyColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public void update(ViewerCell cell) {
                IModel library = (IModel)cell.getElement();
                if (!AccessPolicyManagerWidget.this.model.isAccessPolicyModifiable(library)) {
                    cell.setForeground(Display.getDefault().getSystemColor(16));
                } else {
                    cell.setForeground(Display.getDefault().getSystemColor(2));
                }
                cell.setText(AccessPolicyManagerWidget.this.model.getAccessPolicy(library).getLiteral());
            }
        });
        this.refreshView();
    }

    protected void refreshView() {
        this.tableViewer.setInput((Object)this.model.getAllReferencedLibrariesByRootModel().toArray());
    }

    protected void notifyValueModification() {
        this.rendererContext.getPropertyContext().setCurrentValue(this.property, (Object)this.model);
    }
}

