/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.menu.dynamic;

import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ItemProviderDecorator;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.helpers.EObjectCouple;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.menu.dynamic.util.DynamicCommandParameter;
import org.polarsys.capella.common.ui.menu.dynamic.DynamicCreateChildAction;
import org.polarsys.capella.common.ui.menu.dynamic.utils.ContributionItemComparator;
import org.polarsys.capella.core.data.capellacommon.FinalState;
import org.polarsys.capella.core.data.capellacommon.Region;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.capellacore.AbstractPropertyValue;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyType;
import org.polarsys.capella.core.data.capellacore.PropertyValueGroup;
import org.polarsys.capella.core.data.capellacore.Relationship;
import org.polarsys.capella.core.data.capellacore.Structure;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.oa.CommunicationMean;
import org.polarsys.capella.core.menu.dynamic.DynamicActionContributionItem;
import org.polarsys.capella.core.menu.dynamic.DynamicModelElementAction;
import org.polarsys.capella.core.model.handler.provider.CapellaAdapterFactoryProvider;
import org.polarsys.capella.core.model.helpers.move.MoveHelper;
import org.polarsys.kitalpha.emde.model.ElementExtension;

public class DynamicCreationAction
extends DynamicModelElementAction {
    private ContributionItemComparator contributionItemComparator = new ContributionItemComparator();

    public DynamicCreationAction(Shell shell, ISelectionProvider selectionProvider) {
        super(shell, selectionProvider);
    }

    protected Collection<CommandParameter> getFilteredNewChildDescriptors(EditingDomain editingDomain, EObject modelElement) {
        AbstractType element;
        HashMap<EObjectCouple, CommandParameter> filteredNewChildDescriptors = new HashMap<EObjectCouple, CommandParameter>();
        HashSet<CommandParameter> dynamicDescriptors = new HashSet<CommandParameter>();
        Collection newChildDescriptors = editingDomain.getNewChildDescriptors((Object)modelElement, null);
        StructuredSelection selection = new StructuredSelection((Object)modelElement);
        for (CommandParameter cmd : newChildDescriptors) {
            if (cmd instanceof DynamicCommandParameter) {
                dynamicDescriptors.add(cmd);
            } else {
                EObjectCouple key = new EObjectCouple(cmd.getEReference(), cmd.getEValue().eClass());
                filteredNewChildDescriptors.put(key, cmd);
            }
            cmd.setOwner((Object)selection);
        }
        if (modelElement instanceof Part && (element = ((Part)modelElement).getOwnedAbstractType()) != null) {
            selection = new StructuredSelection((Object)element);
            newChildDescriptors = editingDomain.getNewChildDescriptors((Object)element, null);
            for (CommandParameter cmd : newChildDescriptors) {
                EObjectCouple key = new EObjectCouple(cmd.getEReference(), cmd.getEValue().eClass());
                filteredNewChildDescriptors.put(key, cmd);
                cmd.setOwner((Object)selection);
            }
        }
        dynamicDescriptors.addAll(filteredNewChildDescriptors.values());
        return dynamicDescriptors;
    }

    @Override
    public Collection<IContributionItem> getStructuralDynamicActions() {
        EObject modelElement = this.getModelElement();
        TransactionalEditingDomain editingDomain = TransactionHelper.getEditingDomain((EObject)modelElement);
        Collection<CommandParameter> newChildDescriptors = this.getFilteredNewChildDescriptors((EditingDomain)editingDomain, modelElement);
        return this.generateCreateChildActions(newChildDescriptors, (EditingDomain)editingDomain, new AbstractCondition(this){

            @Override
            public boolean isValid() {
                Object value = this.getValue();
                return this.isStructureRelated(value) && !this.isExtensionRelated(value);
            }
        });
    }

    @Override
    public Collection<IContributionItem> getPropertyValueDynamicActions() {
        EObject modelElement = this.getModelElement();
        TransactionalEditingDomain editingDomain = TransactionHelper.getEditingDomain((EObject)modelElement);
        Collection<CommandParameter> newChildDescriptors = this.getFilteredNewChildDescriptors((EditingDomain)editingDomain, modelElement);
        return this.generateCreateChildActions(newChildDescriptors, (EditingDomain)editingDomain, new AbstractCondition(this){

            @Override
            public boolean isValid() {
                Object value = this.getValue();
                return this.isPropertyRelated(value);
            }
        });
    }

    @Override
    public Collection<IContributionItem> getExtensionDynamicActions() {
        EObject modelElement = this.getModelElement();
        TransactionalEditingDomain editingDomain = TransactionHelper.getEditingDomain((EObject)modelElement);
        Collection<CommandParameter> newChildDescriptors = this.getFilteredNewChildDescriptors((EditingDomain)editingDomain, modelElement);
        return this.generateCreateChildActions(newChildDescriptors, (EditingDomain)editingDomain, new AbstractCondition(this){

            @Override
            public boolean isValid() {
                Object value = this.getValue();
                return this.isExtensionRelated(value) && !this.isRelationshipButNotCMOrFCIRelated(value);
            }
        });
    }

    @Override
    public Collection<IContributionItem> getNonStructuralDynamicActions() {
        EObject modelElement = this.getModelElement();
        TransactionalEditingDomain editingDomain = TransactionHelper.getEditingDomain((EObject)modelElement);
        Collection<CommandParameter> newChildDescriptors = this.getFilteredNewChildDescriptors((EditingDomain)editingDomain, modelElement);
        return this.generateCreateChildActions(newChildDescriptors, (EditingDomain)editingDomain, new AbstractCondition(this){

            @Override
            public boolean isValid() {
                Object value = this.getValue();
                return !this.isRelationshipButNotCMOrFCIRelated(value) && !this.isStructureRelated(value) && !this.isPropertyRelated(value) && !this.isExtensionRelated(value);
            }
        });
    }

    private boolean isStructureRelated(Object value) {
        return value instanceof Structure;
    }

    private boolean isPropertyRelated(Object value) {
        return value instanceof AbstractPropertyValue || value instanceof EnumerationPropertyType || value instanceof PropertyValueGroup;
    }

    private boolean isExtensionRelated(Object value) {
        return value instanceof ElementExtension;
    }

    private boolean isRelationshipButNotCMOrFCIRelated(Object value) {
        return value instanceof Relationship && !(value instanceof CommunicationMean) && !(value instanceof FunctionalChainInvolvement);
    }

    protected Collection<IContributionItem> generateCreateChildActions(Collection<CommandParameter> descriptors, EditingDomain editingDomain, AbstractCondition condition) {
        TreeSet<IContributionItem> contributionItems = new TreeSet<IContributionItem>((Comparator<IContributionItem>)this.contributionItemComparator);
        if (descriptors != null) {
            Set featureDescriptors;
            HashMap<EClass, HashSet<CommandParameter>> descriptorsSortedByType = new HashMap<EClass, HashSet<CommandParameter>>();
            HashMap<EReference, HashSet<CommandParameter>> descriptorsSortedByFeature = new HashMap<EReference, HashSet<CommandParameter>>();
            HashSet<EReference> featuresDisplayedAsSubMenuManager = new HashSet<EReference>(0);
            for (CommandParameter descriptor : descriptors) {
                EReference feature = descriptor.getEReference();
                featureDescriptors = (HashSet<CommandParameter>)descriptorsSortedByFeature.get(feature);
                if (featureDescriptors == null) {
                    featureDescriptors = new HashSet<CommandParameter>(1);
                    descriptorsSortedByFeature.put(feature, (HashSet<CommandParameter>)featureDescriptors);
                }
                featureDescriptors.add(descriptor);
                EClass eClass = descriptor.getEValue().eClass();
                HashSet<CommandParameter> typeDescriptors = (HashSet<CommandParameter>)descriptorsSortedByType.get(eClass);
                if (typeDescriptors == null) {
                    typeDescriptors = new HashSet<CommandParameter>(1);
                    descriptorsSortedByType.put(eClass, typeDescriptors);
                }
                typeDescriptors.add(descriptor);
                if (typeDescriptors.size() <= 1 || featureDescriptors.size() <= 1) continue;
                if (!typeDescriptors.stream().noneMatch(DynamicCommandParameter.class::isInstance)) continue;
                if (!featureDescriptors.stream().noneMatch(DynamicCommandParameter.class::isInstance)) continue;
                featuresDisplayedAsSubMenuManager.add(feature);
            }
            for (CommandParameter descriptor : descriptors) {
                EReference reference = descriptor.getEReference();
                if (featuresDisplayedAsSubMenuManager.contains(reference)) {
                    featureDescriptors = (Set)descriptorsSortedByFeature.get(reference);
                    MenuManager featureMenuManager = new MenuManager(this.getFeatureLabel((EStructuralFeature)reference, descriptor.getEValue()));
                    contributionItems.add((IContributionItem)featureMenuManager);
                    TreeSet<IContributionItem> actionItems = new TreeSet<IContributionItem>((Comparator<IContributionItem>)this.contributionItemComparator);
                    for (CommandParameter featureDescriptor : featureDescriptors) {
                        this.fillContributionItems(editingDomain, condition, actionItems, featureDescriptor);
                    }
                    for (IContributionItem dynamicItem : actionItems) {
                        featureMenuManager.add(dynamicItem);
                    }
                    continue;
                }
                this.fillContributionItems(editingDomain, condition, contributionItems, descriptor);
            }
        }
        return contributionItems;
    }

    protected void fillContributionItems(EditingDomain editingDomain, AbstractCondition condition, TreeSet<IContributionItem> items, CommandParameter descriptor) {
        DynamicCreateChildAction action;
        condition.setValue(descriptor.getValue());
        if (condition.isValid() && (action = this.createChildAction(editingDomain, (ISelection)descriptor.getOwner(), descriptor)).isExecutable() && action.isEnabled()) {
            items.add((IContributionItem)new DynamicActionContributionItem((IAction)action));
        }
    }

    protected DynamicCreateChildAction createChildAction(EditingDomain editingDomain, ISelection selection, CommandParameter descriptor) {
        return new CapellaCreateChildAction(editingDomain, selection, descriptor);
    }

    protected String getFeatureLabel(EStructuralFeature feature, EObject object) {
        ItemProviderAdapter genericItemProvider = this.getItemProviderAdapter(object);
        String featureLabel = EObjectLabelProviderHelper.getFeatureLabel((EStructuralFeature)feature, (ItemProviderAdapter)genericItemProvider);
        genericItemProvider.dispose();
        return featureLabel;
    }

    protected String getMetaclassLabel(EClass clazz, EObject object) {
        ItemProviderAdapter genericItemProvider = this.getItemProviderAdapter(object);
        String metaclassLabel = EObjectLabelProviderHelper.getMetaclassLabel((EClass)clazz, (ItemProviderAdapter)genericItemProvider);
        genericItemProvider.dispose();
        return metaclassLabel;
    }

    protected ItemProviderAdapter getItemProviderAdapter(EObject object) {
        IChangeNotifier notifier;
        IItemLabelProvider itemLabelProvider = this.getItemLabelProvider(object);
        if (itemLabelProvider instanceof ItemProviderDecorator && (notifier = ((ItemProviderDecorator)itemLabelProvider).getDecoratedItemProvider()) instanceof ItemProviderAdapter) {
            return (ItemProviderAdapter)notifier;
        }
        return (ItemProviderAdapter)itemLabelProvider;
    }

    protected IItemLabelProvider getItemLabelProvider(EObject object) {
        AdapterFactory adapterFactory = CapellaAdapterFactoryProvider.getInstance().getAdapterFactory();
        Adapter adapter = adapterFactory.adapt((Notifier)object, IItemLabelProvider.class);
        return (IItemLabelProvider)adapter;
    }

    protected abstract class AbstractCondition {
        private Object value;

        protected AbstractCondition() {
        }

        public abstract boolean isValid();

        public void setValue(Object value) {
            this.value = value;
        }

        protected Object getValue() {
            return this.value;
        }
    }

    protected class CapellaCreateChildAction
    extends DynamicCreateChildAction {
        public CapellaCreateChildAction(EditingDomain editingDomain, ISelection selection, Object descriptor) {
            super(editingDomain, selection, descriptor);
        }

        public void configureAction(ISelection selection) {
            super.configureAction(selection);
            EObject object = ((CommandParameter)this.descriptor).getEValue();
            if (this.descriptor instanceof DynamicCommandParameter) {
                DynamicCommandParameter richCommandParameter = (DynamicCommandParameter)this.descriptor;
                this.setText(richCommandParameter.getLabel());
                ImageDescriptor imageDescriptor = this.findBestImageDescriptor(object, selection);
                this.setImageDescriptor(imageDescriptor);
            } else {
                EClass eClass = object.eClass();
                this.setText(DynamicCreationAction.this.getMetaclassLabel(eClass, object));
            }
            if (this.getImageDescriptor() == null) {
                ImageDescriptor imageDescriptor = this.findBestImageDescriptor(object, selection);
                this.setImageDescriptor(imageDescriptor);
            }
        }

        private ImageDescriptor findBestImageDescriptor(EObject object, ISelection selection) {
            ImageDescriptor imageDescriptor = ExtendedImageRegistry.getInstance().getImageDescriptor(EObjectLabelProviderHelper.getImage((EObject)object));
            if (imageDescriptor == null) {
                IItemLabelProvider itemLabelProvider = DynamicCreationAction.this.getItemLabelProvider(object);
                URL imageUrl = null;
                if (itemLabelProvider != null && itemLabelProvider.getImage((Object)object) instanceof URL) {
                    imageUrl = (URL)itemLabelProvider.getImage((Object)object);
                } else {
                    Object parent = ((StructuredSelection)selection).getFirstElement();
                    EStructuralFeature feature = ((CommandParameter)this.descriptor).getEStructuralFeature();
                    ItemProviderAdapter itemProvider = DynamicCreationAction.this.getItemProviderAdapter(object);
                    Object childImage = itemProvider.getCreateChildImage(parent, (Object)feature, (Object)object, null);
                    imageUrl = (URL)childImage;
                    itemProvider.dispose();
                }
                imageDescriptor = ImageDescriptor.createFromURL((URL)imageUrl);
            }
            return imageDescriptor;
        }

        protected Command createActionCommand(EditingDomain editingDomain, Collection<?> collection) {
            if (collection.size() == 1) {
                Object owner = collection.iterator().next();
                if (this.descriptor instanceof CommandParameter) {
                    CommandParameter param = (CommandParameter)this.descriptor;
                    if (owner instanceof Region && param.getValue() instanceof State && !(param.getValue() instanceof FinalState) && !MoveHelper.getInstance().canMoveModeState((State)param.getValue(), (Region)owner)) {
                        return UnexecutableCommand.INSTANCE;
                    }
                }
            }
            return super.createActionCommand(editingDomain, collection);
        }
    }
}

