/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public final class UIUtil {
    public static final String CC_MIRRORED_PROPERTY = "MIRRORED";

    private UIUtil() {
    }

    public static Composite createComposite(Composite parent_p) {
        Composite result = new Composite(parent_p, 2048);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        result.setLayout((Layout)layout);
        return result;
    }

    public static MenuManager createMenuTool(IToolBarManager context_p) {
        MenuDropDownAction action = new MenuDropDownAction(1);
        action.setImageDescriptor(EMFDiffMergeUIPlugin.getDefault().getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.VIEW_MENU));
        action.setToolTipText(Messages.ComparisonViewer_ViewMenuTooltip);
        context_p.add((IAction)action);
        return action.getMenuManager();
    }

    public static ToolBar createToolBar(Composite parent_p) {
        ToolBar result = new ToolBar(parent_p, 131328);
        GridData data = new GridData(131072, 128, false, false);
        result.setData((Object)data);
        return result;
    }

    public static Font getBase(Font font_p) {
        FontData data = font_p.getFontData()[0];
        Font result = JFaceResources.getFontRegistry().get(data.getName());
        return result;
    }

    public static Font getBold(Font font_p) {
        FontData data = font_p.getFontData()[0];
        Font result = JFaceResources.getFontRegistry().getBold(data.getName());
        return result;
    }

    public static final Color getColor(int code_p) {
        return Display.getDefault().getSystemColor(code_p);
    }

    public static Image getEMFImage(Object element_p) {
        Image result = EMFDiffMergeUIPlugin.getDefault().getAdapterFactoryLabelProvider().getImage(element_p);
        if (result == null) {
            Object rawImage;
            AdapterFactoryEditingDomain editingDomain;
            IItemLabelProvider provider;
            EditingDomain rawEditingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((Object)element_p);
            if (rawEditingDomain == null) {
                rawEditingDomain = TransactionUtil.getEditingDomain((Object)element_p);
            }
            if (rawEditingDomain instanceof AdapterFactoryEditingDomain && (provider = (IItemLabelProvider)(editingDomain = (AdapterFactoryEditingDomain)rawEditingDomain).getAdapterFactory().adapt(element_p, IItemLabelProvider.class)) != null && (rawImage = provider.getImage(element_p)) != null) {
                result = ExtendedImageRegistry.getInstance().getImage(rawImage);
            }
        }
        return result;
    }

    public static String getEMFText(Object element_p) {
        String result = EMFDiffMergeUIPlugin.getDefault().getAdapterFactoryLabelProvider().getText(element_p);
        if (result == null) {
            AdapterFactoryEditingDomain editingDomain;
            IItemLabelProvider provider;
            EditingDomain rawEditingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((Object)element_p);
            if (rawEditingDomain == null) {
                rawEditingDomain = TransactionUtil.getEditingDomain((Object)element_p);
            }
            if (rawEditingDomain instanceof AdapterFactoryEditingDomain && (provider = (IItemLabelProvider)(editingDomain = (AdapterFactoryEditingDomain)rawEditingDomain).getAdapterFactory().adapt(element_p, IItemLabelProvider.class)) != null) {
                result = provider.getText(element_p);
            }
        }
        return result;
    }

    public static String getFormattedFeatureText(EStructuralFeature feature_p) {
        return FormattedTextProvider.getInstance().getFeatureText(feature_p);
    }

    public static String getFormattedText(String label_p) {
        return FormattedTextProvider.getInstance().getFormattedText(label_p);
    }

    public static String getFormattedTypeText(EObject element_p) {
        return FormattedTextProvider.getInstance().getTypeText(element_p);
    }

    public static Font getItalic(Font font_p) {
        FontData data = font_p.getFontData()[0];
        Font result = JFaceResources.getFontRegistry().getItalic(data.getName());
        return result;
    }

    public static boolean itemGetSelection(Item item_p) {
        assert (item_p instanceof ToolItem || item_p instanceof MenuItem);
        boolean result = item_p instanceof ToolItem ? ((ToolItem)item_p).getSelection() : ((MenuItem)item_p).getSelection();
        return result;
    }

    public static void itemSetSelection(Item item_p, boolean selected_p) {
        assert (item_p instanceof ToolItem || item_p instanceof MenuItem);
        if (item_p instanceof ToolItem) {
            ((ToolItem)item_p).setSelection(selected_p);
        } else {
            ((MenuItem)item_p).setSelection(selected_p);
        }
    }

    public static String simplifyURI(URI uri_p) {
        String result = null;
        if (uri_p != null) {
            if (uri_p.isPlatform()) {
                result = uri_p.toPlatformString(true);
            } else if (uri_p.isFile()) {
                result = uri_p.toFileString();
            } else {
                String path = uri_p.path();
                if (path == null) {
                    path = uri_p.toString();
                }
                result = URI.decode((String)path);
            }
        }
        return result;
    }

    public static TreePath toTreePath(List<?> path_p) {
        return new TreePath(path_p.toArray());
    }

    public static TreePath[] toTreePaths(List<? extends List<?>> paths_p) {
        ArrayList<TreePath> result = new ArrayList<TreePath>(paths_p.size());
        for (List<?> path : paths_p) {
            result.add(UIUtil.toTreePath(path));
        }
        return result.toArray(new TreePath[result.size()]);
    }

    protected static class FormattedTextProvider
    extends ReflectiveItemProvider {
        protected static FormattedTextProvider __instance = null;

        protected FormattedTextProvider() {
            super(null);
        }

        public String getFeatureText(Object feature_p) {
            return super.getFeatureText(feature_p);
        }

        public String getFormattedText(String label_p) {
            return this.format(this.capName(label_p), ' ');
        }

        public String getTypeText(Object object_p) {
            return super.getTypeText(object_p);
        }

        public static FormattedTextProvider getInstance() {
            if (__instance == null) {
                __instance = new FormattedTextProvider();
            }
            return __instance;
        }
    }

    public static class LabelBasedComparator
    implements Comparator<Object> {
        private final ILabelProvider _labelProvider;

        public LabelBasedComparator(ILabelProvider labelProvider_p) {
            this._labelProvider = labelProvider_p;
        }

        @Override
        public int compare(Object o1_p, Object o2_p) {
            String label2;
            String label1 = this._labelProvider.getText(o1_p);
            if (label1 == null) {
                label1 = o1_p.toString();
            }
            if ((label2 = this._labelProvider.getText(o2_p)) == null) {
                label2 = o2_p.toString();
            }
            return label1.compareTo(label2);
        }
    }

    public static class MenuDropDownAction
    extends Action
    implements IMenuCreator {
        private final MenuManager _menuManager = new MenuManager();

        public MenuDropDownAction() {
            this(4);
        }

        public MenuDropDownAction(int style_p) {
            super(null, style_p);
            this.setMenuCreator(this);
        }

        public void dispose() {
            if (this._menuManager != null) {
                this._menuManager.dispose();
            }
        }

        public Menu getMenu(Control parent_p) {
            Menu result = this._menuManager.createContextMenu(parent_p);
            parent_p.setMenu(result);
            return result;
        }

        public Menu getMenu(Menu parent_p) {
            Menu existingMenu = this._menuManager.getMenu();
            if (existingMenu == null || existingMenu.isDisposed()) {
                Menu containerMenu = new Menu(parent_p);
                this._menuManager.fill(containerMenu, -1);
            }
            return this._menuManager.getMenu();
        }

        public MenuManager getMenuManager() {
            return this._menuManager;
        }

        public void runWithEvent(Event event_p) {
            Widget sourceWidget = event_p.widget;
            Menu menu = null;
            if (sourceWidget instanceof ToolItem) {
                ToolItem item = (ToolItem)sourceWidget;
                ToolBar toolBar = item.getParent();
                menu = this.getMenu((Control)toolBar);
                Rectangle rect = item.getBounds();
                Point pt = toolBar.toDisplay(new Point(rect.x, rect.y));
                menu.setLocation(pt.x, pt.y + rect.height);
            } else if (sourceWidget instanceof MenuItem) {
                Menu parentMenu = ((MenuItem)sourceWidget).getMenu();
                menu = this.getMenu(parentMenu);
            }
            if (menu != null) {
                menu.setVisible(true);
            }
        }
    }
}

