/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.filterrow.combobox;

import org.eclipse.nebula.widgets.nattable.data.convert.ConversionFailedException;
import org.eclipse.nebula.widgets.nattable.edit.editor.ComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.IComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterNatCombo;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.nebula.widgets.nattable.widget.NatCombo;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterRowComboBoxCellEditor
extends ComboBoxCellEditor {
    private static final Logger LOG = LoggerFactory.getLogger(FilterRowComboBoxCellEditor.class);
    private Object currentCanonicalValue = null;
    private boolean applyFilterOnDropdownFilter = false;
    private boolean closeOnEnterInDropdownFilter = false;

    public FilterRowComboBoxCellEditor(IComboBoxDataProvider dataProvider) {
        this(dataProvider, 5);
    }

    public FilterRowComboBoxCellEditor(IComboBoxDataProvider dataProvider, int maxVisibleItems) {
        super(dataProvider, maxVisibleItems);
        this.multiselect = true;
        this.useCheckbox = true;
    }

    @Override
    public NatCombo createEditorControl(Composite parent) {
        FilterNatCombo combo;
        int style = 42;
        FilterNatCombo filterNatCombo = combo = this.iconImage == null ? new FilterNatCombo(parent, this.cellStyle, this.maxVisibleItems, style, this.showDropdownFilter) : new FilterNatCombo(parent, this.cellStyle, this.maxVisibleItems, style, this.iconImage, this.showDropdownFilter);
        if (this.freeEdit) {
            combo.setCursor(Display.getDefault().getSystemCursor(19));
        } else {
            combo.setCursor(Display.getDefault().getSystemCursor(0));
        }
        combo.setMultiselectValueSeparator(this.multiselectValueSeparator);
        combo.setMultiselectTextBracket(this.multiselectTextPrefix, this.multiselectTextSuffix);
        this.addNatComboListener(combo);
        combo.addCheckStateListener(event -> {
            if (event.getChecked()) {
                this.setCanonicalValue("SELECT_ALL");
            }
            this.commit(SelectionLayer.MoveDirectionEnum.NONE, !this.multiselect && this.editMode == EditModeEnum.INLINE);
        });
        if (this.applyFilterOnDropdownFilter) {
            combo.setFilterModifyAction(() -> this.commit(SelectionLayer.MoveDirectionEnum.NONE, !this.multiselect && this.editMode == EditModeEnum.INLINE));
        }
        if (this.closeOnEnterInDropdownFilter) {
            combo.setDropdownFilterKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    if (event.keyCode == 13 || event.keyCode == 0x1000050 || event.keyCode == 27) {
                        FilterRowComboBoxCellEditor.this.close();
                    }
                }
            });
        }
        return combo;
    }

    @Override
    public void setCanonicalValue(Object canonicalValue) {
        this.currentCanonicalValue = canonicalValue;
        super.setCanonicalValue(canonicalValue);
    }

    @Override
    public boolean commit(SelectionLayer.MoveDirectionEnum direction, boolean closeAfterCommit) {
        if (!this.isClosed()) {
            block7: {
                Object canonicalValue = this.getCanonicalValue();
                if (!(canonicalValue != null && this.currentCanonicalValue == null || canonicalValue == null && this.currentCanonicalValue != null) && (canonicalValue == null || this.currentCanonicalValue == null || canonicalValue.equals(this.currentCanonicalValue))) break block7;
                if (super.commit(direction, closeAfterCommit)) {
                    this.currentCanonicalValue = canonicalValue;
                    return true;
                }
            }
            try {
                if (closeAfterCommit) {
                    this.close();
                }
                return true;
            }
            catch (ConversionFailedException canonicalValue) {
            }
            catch (Exception e) {
                LOG.error("Error on updating cell value: {}", (Object)e.getLocalizedMessage(), (Object)e);
            }
        }
        return false;
    }

    public void configureDropdownFilter(boolean applyFilter, boolean closeOnEnter) {
        this.setShowDropdownFilter(true);
        this.applyFilterOnDropdownFilter = applyFilter;
        this.closeOnEnterInDropdownFilter = closeOnEnter;
    }
}

