/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.PrefsMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.validation.preferences.EMFModelValidationPreferences;
import org.eclipse.swt.widgets.Display;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;

public class CapellaPreferencesService {
    private static final char EXPORT_ROOT_PREFIX = '!';
    private static final char BUNDLE_VERSION_PREFIX = '@';
    private static final String VERSION_KEY = "file_export_version";
    private static final String EMPTY_STRING = "";
    private static final String EPF_PATH_ARGUMENT_ID = "-EPF";
    public static final String KEY_PREFIX = "org.eclipse.emf.validation";

    public void initializePreferences(final InputStream input) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    CapellaPreferencesService.this.applyPreferences(CapellaPreferencesService.this.readEPFPreferencesFile(input));
                }
                catch (CoreException exception_p) {
                    CapellaPreferencesService.getLogger().error((Object)exception_p.getMessage());
                }
            }
        });
    }

    public static String getEPFPathFromApplicationArguments() {
        if (Platform.inDebugMode()) {
            CapellaPreferencesService.getLogger().debug((Object)"Start Capella Preferences initialization From EPF File");
        }
        String epfPath = EMPTY_STRING;
        String[] args = Platform.getApplicationArgs();
        int i = 0;
        while (i < args.length) {
            String currentArgument = args[i].toLowerCase();
            if (EPF_PATH_ARGUMENT_ID.equalsIgnoreCase(currentArgument)) {
                epfPath = args[++i];
            }
            ++i;
        }
        if (Platform.inDebugMode()) {
            CapellaPreferencesService.getLogger().debug((Object)("funded EPF File : " + epfPath));
        }
        return epfPath;
    }

    private void applyPreferences(IEclipsePreferences readEPFPreferencesFile_p) {
        try {
            this.flushPreferences(readEPFPreferencesFile_p);
        }
        catch (CoreException exception_p) {
            CapellaPreferencesService.createStatusError("Fail to initialize Capella Preferences From File : ", (Exception)((Object)exception_p));
        }
    }

    public IEclipsePreferences readEPFPreferencesFile(InputStream input) throws CoreException {
        if (input == null) {
            throw new IllegalArgumentException();
        }
        Properties properties = new Properties();
        try {
            try {
                properties.load(input);
            }
            catch (IOException e) {
                throw new CoreException(CapellaPreferencesService.createStatusError(PrefsMessages.preferences_importProblems, e));
            }
        }
        finally {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        if (properties.isEmpty()) {
            throw new CoreException(CapellaPreferencesService.createStatusError(PrefsMessages.preferences_invalidFileFormat, null));
        }
        if (this.isLegacy(properties)) {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message((String)"Read legacy preferences file, converting to 3.0 format...");
            }
            properties = this.convertFromLegacy(properties);
        } else {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message((String)"Read preferences file.");
            }
            properties.remove(VERSION_KEY);
        }
        return this.convertFromProperties(properties);
    }

    private IEclipsePreferences convertFromProperties(Properties properties) {
        IEclipsePreferences root = Platform.getPreferencesService().getRootNode();
        for (Object element : properties.keySet()) {
            String path = (String)element;
            String value = properties.getProperty(path);
            String[] decoded = EclipsePreferences.decodePath((String)path);
            path = decoded[0] == null ? EMPTY_STRING : decoded[0];
            IEclipsePreferences current = (IEclipsePreferences)root.node(path);
            String key = decoded[1];
            if (key != null && path != null && this.isEMFValidationNode(path)) {
                key = key.replaceFirst("con.disabled/", EMPTY_STRING);
                boolean bool = Boolean.parseBoolean(value);
                EMFModelValidationPreferences.setConstraintDisabled((String)key, (boolean)Boolean.parseBoolean(value));
                EMFModelValidationPreferences.save();
            }
            current.put(key, value);
            InstanceScope.INSTANCE.getNode("org.polarsys.capella.core.preferences").put(key, value);
        }
        return root;
    }

    private boolean isEMFValidationNode(String path) {
        return path != null && path.contains(KEY_PREFIX);
    }

    private static IStatus createStatusError(String message, Exception e) {
        return new Status(4, "org.eclipse.equinox.preferences", 4, message, (Throwable)e);
    }

    private boolean isLegacy(Properties properties) {
        return properties.getProperty(VERSION_KEY) == null;
    }

    private Properties convertFromLegacy(Properties properties) {
        Properties result = new Properties();
        String prefix = "/instance/";
        for (Object element : properties.keySet()) {
            String key = (String)element;
            String value = properties.getProperty(key);
            if (value == null) continue;
            int index = key.indexOf(47);
            if (index == -1) {
                result.put(String.valueOf('@') + key, value);
                result.put(String.valueOf('!') + prefix + key, EMPTY_STRING);
                continue;
            }
            String path = key.substring(0, index);
            key = key.substring(index + 1);
            result.put(EclipsePreferences.encodePath((String)(String.valueOf(prefix) + path), (String)key), value);
        }
        return result;
    }

    public void flushPreferences(IEclipsePreferences root) throws CoreException {
        try {
            root.flush();
        }
        catch (Exception e) {
            throw new CoreException(CapellaPreferencesService.createStatusError(PrefsMessages.preferences_applyProblems, e));
        }
    }

    private static Logger getLogger() {
        return ReportManagerRegistry.getInstance().subscribe("User Interface");
    }
}

