/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.commands.ExpressionContext;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.UIElement;
import org.polarsys.capella.core.commands.preferences.service.IItemDescriptor;
import org.polarsys.capella.core.commands.preferences.service.PreferencesItemsRegistry;
import org.polarsys.capella.core.preferences.Activator;

public class PreferencesHandler
extends AbstractHandler
implements IElementUpdater {
    private static HashMap<Command, PreferencesHandler> instances = new HashMap();
    private static Map<String, List<IHandlerActivation>> pluginHandlers = new HashMap<String, List<IHandlerActivation>>(0);
    private Command currentCommand;
    private static IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
    private boolean isEnabledCommand;

    public static PreferencesHandler getInstance(Command command) {
        if (!instances.containsKey(command)) {
            instances.put(command, new PreferencesHandler(command));
        }
        return instances.get(command);
    }

    private void registerHandlerActivation(IHandlerActivation activation) {
        if (!pluginHandlers.containsKey(activation.getCommandId())) {
            pluginHandlers.put(activation.getCommandId(), new ArrayList());
        }
        pluginHandlers.get(activation.getCommandId()).add(activation);
    }

    private void registerHandlerActivations(List<IHandlerActivation> activations) {
        for (IHandlerActivation activation : activations) {
            this.registerHandlerActivation(activation);
        }
    }

    protected IEclipsePreferences getPreferences() {
        return InstanceScope.INSTANCE.getNode("org.polarsys.capella.core.preferences");
    }

    private List<IHandlerActivation> getRegisteredHandlerActivations(IHandlerService service, String commandId) {
        if (!pluginHandlers.containsKey(commandId)) {
            return Collections.emptyList();
        }
        return pluginHandlers.get(commandId);
    }

    private PreferencesHandler(Command command) {
        this.currentCommand = command;
        this.registerHandlerActivations(this.getHandlerActivations(handlerService, this.currentCommand.getId()));
    }

    private void activateHandler(Command command) {
        boolean isCommandEnabled = this.isEnabled();
        boolean isPreferenceRegistered = false;
        for (IHandlerActivation activation : this.getRegisteredHandlerActivations(handlerService, this.currentCommand.getId())) {
            boolean isPreferenceHandler = activation.getHandler().equals((Object)this);
            if (isPreferenceHandler) {
                if (isCommandEnabled) {
                    if (this.getHandlerActivations(handlerService, this.currentCommand.getId()).contains(activation)) {
                        handlerService.deactivateHandler(activation);
                    }
                } else {
                    handlerService.activateHandler(activation);
                }
                isPreferenceRegistered = true;
                continue;
            }
            if (isCommandEnabled) {
                handlerService.activateHandler(activation);
                continue;
            }
            handlerService.deactivateHandler(activation);
        }
        if (!isPreferenceRegistered && !isCommandEnabled) {
            this.registerHandlerActivation(this.getPreferenceHandlerActivation());
        }
    }

    private IEclipseContext getEclipseContext(IEvaluationContext evalContext) {
        if (evalContext instanceof ExpressionContext) {
            return ((ExpressionContext)evalContext).eclipseContext;
        }
        return evalContext != null ? this.getEclipseContext(evalContext.getParent()) : null;
    }

    private List<IHandlerActivation> getHandlerActivations(IHandlerService service, String commandId) {
        IEclipseContext eclipseContext = this.getEclipseContext(service.getCurrentState());
        List handlerActivations = (List)eclipseContext.getLocal("legacy::handler::" + commandId);
        return handlerActivations;
    }

    public boolean isEnabled() {
        IItemDescriptor commandDescriptor = PreferencesItemsRegistry.getInstance().getDescriptor(this.currentCommand.getId());
        boolean result = commandDescriptor == null ? true : this.getPreferences().getBoolean(this.currentCommand.getId(), commandDescriptor.isEnabledByDefault());
        return result;
    }

    private IHandlerActivation getPreferenceHandlerActivation() {
        IHandlerActivation handlerActivation = handlerService.activateHandler(this.currentCommand.getId(), (IHandler)this, new Expression(){

            public EvaluationResult evaluate(IEvaluationContext context_p) throws CoreException {
                IItemDescriptor commandDescriptor;
                Object selection = context_p.getVariable("selection");
                boolean result = true;
                if (selection != null && selection instanceof ISelection) {
                    commandDescriptor = PreferencesItemsRegistry.getInstance().getDescriptor(PreferencesHandler.this.currentCommand.getId());
                    result = commandDescriptor == null ? true : PreferencesHandler.this.getPreferences().getBoolean(PreferencesHandler.this.currentCommand.getId(), commandDescriptor.isEnabledByDefault());
                }
                result = (commandDescriptor = PreferencesItemsRegistry.getInstance().getDescriptor(PreferencesHandler.this.currentCommand.getId())) == null ? true : PreferencesHandler.this.getPreferences().getBoolean(PreferencesHandler.this.currentCommand.getId(), commandDescriptor.isEnabledByDefault());
                return EvaluationResult.valueOf((boolean)result);
            }

            public void collectExpressionInfo(ExpressionInfo info) {
                info.markDefaultVariableAccessed();
            }
        });
        return handlerActivation;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        if (!this.isEnabledCommand) {
            element.setIcon(Activator.getImageDescriptor("preference.gif"));
            element.setHoverIcon(Activator.getImageDescriptor("preference.gif"));
            element.setTooltip("this element is disabled from preferences");
        }
    }

    public static void initializePreferenceCommands() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command[] commandArray = commandService.getDefinedCommands();
        int n = commandArray.length;
        int n2 = 0;
        while (n2 < n) {
            Command command = commandArray[n2];
            IItemDescriptor commandDescriptor = PreferencesItemsRegistry.getInstance().getDescriptor(command.getId());
            if (commandDescriptor != null && command.isDefined()) {
                PreferencesHandler.getInstance(command).activateHandler(command);
                commandService.refreshElements(command.getId(), null);
            }
            ++n2;
        }
    }
}

