/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.ui.launch.tabs.widgets.composer;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.polarsys.kitalpha.composer.extension.points.CodeManagerExtensions;
import org.polarsys.kitalpha.composer.ui.Activator;
import org.polarsys.kitalpha.composer.ui.launch.tabs.ComposerTab;
import org.polarsys.kitalpha.composer.ui.launch.tabs.widgets.AtomicWidget;
import org.polarsys.kitalpha.composer.ui.launch.tabs.widgets.composer.AbstractComposerWidget;

public class GeneratorTypeWidget
extends AbstractComposerWidget {
    private Viewer viewer;
    private ComposerTab tab;
    AtomicWidget cw;
    private IConfigurationElement selectedAllocationBinding;

    public GeneratorTypeWidget(ComposerTab tab_p) {
        this.tab = tab_p;
    }

    @Override
    public void createContents(Composite parent) {
        this.createWidget(parent, "Generation Type", "Choose the generation Type", false);
        this.attachListeners();
        this.initialize();
    }

    private void attachListeners() {
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new AbstractComposerWidget.ComposerElementListener(this));
    }

    @Override
    public void initialize() {
        IConfigurationElement[] binding = CodeManagerExtensions.getAllBindingExtensions();
        this.viewer.setInput((Object)binding);
    }

    @Override
    public void updateSelection(IConfigurationElement selectedElement) {
        if (selectedElement != this.selectedAllocationBinding) {
            this.selectedAllocationBinding = selectedElement;
            String ns_URI = this.selectedAllocationBinding.getAttribute("NsUri");
            this.tab.setGlobalNsUri(ns_URI);
            this.tab.update();
        }
    }

    public Viewer createWidget(Composite parent_p, String name_p, String comboxText_p, boolean button) {
        Group group = new Group(parent_p, 0);
        group.setText(name_p);
        group.setLayout((Layout)new GridLayout(2, true));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)gd);
        this.cw = new AtomicWidget((Composite)group);
        this.viewer = this.cw.createComboViewer(false);
        if (!button) {
            this.cw.createEmptyLabel(false);
        } else {
            Button edit = this.cw.createButton((Composite)group, "Edit Parameters", "configure the parameters");
            GridData gd_button = new GridData();
            gd_button.horizontalAlignment = 131072;
            edit.setLayoutData((Object)gd_button);
        }
        this.description = this.cw.createEmptyLabel(true);
        return this.viewer;
    }

    @Override
    public final Viewer getViewer() {
        return this.viewer;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.selectedAllocationBinding != null) {
            configuration.setAttribute("allocation_uri", this.selectedAllocationBinding.getAttribute("NsUri"));
            configuration.setAttribute("generation_name", this.selectedAllocationBinding.getAttribute("Name"));
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String str = configuration.getAttribute("generation_name", "");
            if (!str.equals("")) {
                int index = this.cw.initializeComboViewer(str);
                this.cw.intializeDescription(this.description, index);
            }
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
    }
}

