/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.re.commands;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.CatalogElementKind;
import org.polarsys.capella.common.re.helpers.ReplicableElementExt;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaDeleteCommand;
import org.polarsys.capella.core.transition.common.commands.DefaultCommand;

public class DeleteReplicaPreserveRelatedElementsCommand
extends DefaultCommand {
    public DeleteReplicaPreserveRelatedElementsCommand(Collection<?> selection, IProgressMonitor progressMonitor) {
        super(selection, progressMonitor);
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected void performTransformation(Collection<?> source) {
        Collection semanticElements = CapellaAdapterHelper.resolveSemanticObjects(source);
        HashSet<CatalogElement> catalogElements = new HashSet<CatalogElement>();
        for (Object selected : semanticElements) {
            if (selected instanceof CatalogElement && ((CatalogElement)selected).getKind() != CatalogElementKind.REC) {
                catalogElements.add((CatalogElement)selected);
                continue;
            }
            catalogElements.addAll(ReplicableElementExt.getReferencingReplicas((EObject)((EObject)selected)));
        }
        CapellaDeleteCommand delete = new CapellaDeleteCommand(TransactionHelper.getExecutionManager(catalogElements), catalogElements, true, !this.isHeadless(), true);
        delete.execute();
    }

    protected boolean isHeadless() {
        return true;
    }
}

