/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.cadence.core.api;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.polarsys.kitalpha.cadence.core.Activator;
import org.polarsys.kitalpha.cadence.core.api.CadenceValidator;
import org.polarsys.kitalpha.cadence.core.api.IActivity;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.cadence.core.api.parameter.ParameterError;
import org.polarsys.kitalpha.cadence.core.api.parameter.WorkflowActivityParameter;
import org.polarsys.kitalpha.cadence.core.internal.CadenceExtensions;

public final class CadenceLauncher {
    private static Map<String, ParameterError<?>> wrongParams = null;

    public static IStatus cadence(String workflowId, String workflowElementId, WorkflowActivityParameter workflowActivityParameters) throws Exception {
        return CadenceLauncher.cadence(workflowId, workflowElementId, workflowActivityParameters, null);
    }

    public static IStatus cadence(String workflowId, String workflowElementId, WorkflowActivityParameter workflowActivityParameters, IProgressMonitor monitor) throws Exception {
        int candidateSize;
        Set<Object> activitiesID;
        MultiStatus result = new MultiStatus("org.polarsys.kitalpha.cadence.core", 0, "Cadence activities", null);
        boolean isMultiple = CadenceExtensions.isMultiple(workflowId, workflowElementId);
        if (workflowActivityParameters != null) {
            activitiesID = workflowActivityParameters.getActivitiesID();
            candidateSize = workflowActivityParameters.getActivitiesID().size();
        } else {
            activitiesID = Collections.emptySet();
            candidateSize = 0;
        }
        if (monitor != null) {
            IConfigurationElement iConfigurationElement = CadenceExtensions.getWorkflow(workflowId);
            IConfigurationElement workflowElement = CadenceExtensions.getWorkflowElement(workflowId, workflowElementId);
            String workflowName = iConfigurationElement.getAttribute("Name");
            String workflowElementName = workflowElement.getAttribute("Name");
            monitor.beginTask("Cadence " + workflowName + " : " + workflowElementName, candidateSize);
        }
        if (candidateSize <= 1 || candidateSize > 1 && isMultiple) {
            for (String string : activitiesID) {
                ActivityParameters activityParameters;
                IStatus status = CadenceLauncher.cadence(workflowId, workflowElementId, string, activityParameters = workflowActivityParameters.getActivityParameters(string), monitor);
                if (status == null) {
                    Activator.getDefault().getLog().log((IStatus)new Status(2, "org.polarsys.kitalpha.cadence.core", "Activity : " + string + " has returned a null status."));
                } else {
                    result.add(status);
                }
                if (monitor == null) continue;
                monitor.worked(1);
            }
        } else {
            throw new Exception("the workflowElement " + workflowElementId + " is not multiple.");
        }
        if (monitor != null) {
            monitor.subTask("");
        }
        return result;
    }

    public static IStatus cadence(String workflowId, String workflowElementId, String activityElementId, ActivityParameters activityParameters) {
        return CadenceLauncher.cadence(workflowId, workflowElementId, activityElementId, activityParameters, null);
    }

    public static IStatus cadence(String workflowId, String workflowElementId, String activityElementId, ActivityParameters activityParameters, IProgressMonitor monitor) {
        IConfigurationElement workflowElement = CadenceExtensions.getWorkflowElement(workflowId, workflowElementId);
        IConfigurationElement activityElement = CadenceExtensions.getActivityConfigElement(activityElementId);
        if (monitor != null) {
            String activityName = activityElement.getAttribute("Name");
            monitor.subTask(activityName);
        }
        IStatus status = CadenceLauncher.cadence(workflowElement, activityElement, activityParameters);
        return status;
    }

    private static IStatus cadence(IConfigurationElement workflowElement, IConfigurationElement activityElement, ActivityParameters activityParameters) {
        IStatus status;
        block4: {
            status = null;
            try {
                IActivity activity = (IActivity)activityElement.createExecutableExtension("ActivityClass");
                if (activityParameters == null || !CadenceLauncher.matchParameters(workflowElement, activityParameters)) break block4;
                wrongParams = activity.validateParameters(activityParameters);
                if (wrongParams == null || wrongParams.isEmpty()) {
                    status = activity.run(activityParameters);
                    if (status != null && !status.isOK()) {
                        ILog log = Activator.getDefault().getLog();
                        log.log(status);
                    }
                    break block4;
                }
                throw new Exception("activity's parameters are not valid. " + CadenceValidator.getParameterErrorsTrace(wrongParams));
            }
            catch (Exception e) {
                ILog log = Activator.getDefault().getLog();
                StringBuilder message = new StringBuilder();
                message.append("Exception during activity execution (activity : ").append(activityElement.getAttribute("Name"));
                message.append(", worflow element : ").append(workflowElement.getAttribute("Name"));
                message.append(")");
                Status builtStatus = new Status(4, "org.polarsys.kitalpha.cadence.core", message.toString(), (Throwable)e);
                log.log((IStatus)builtStatus);
                return status;
            }
        }
        return status;
    }

    private static boolean matchParameters(IConfigurationElement workflowElement, ActivityParameters activityParameters) throws Exception {
        if (activityParameters != null) {
            IConfigurationElement[] params = CadenceExtensions.getWorkflowElementParameters(workflowElement);
            if (activityParameters.getParameters().size() < params.length) {
                throw new Exception("activity doesn't define parameters enough");
            }
            IConfigurationElement[] iConfigurationElementArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement p = iConfigurationElementArray[n2];
                String name = p.getAttribute("Name");
                if (!activityParameters.getParametersID().contains(name)) {
                    throw new Exception("The org.polarsys.kitalpha.cadence.core.api.parameter " + name + " doesn't exist.");
                }
                ++n2;
            }
        }
        return true;
    }
}

