/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.metric.dialog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.polarsys.capella.common.ui.toolkit.dialogs.AbstractExportDialog;
import org.polarsys.capella.common.ui.toolkit.dialogs.IExportConstants;
import org.polarsys.capella.common.ui.toolkit.viewers.AbstractRegExpViewer;
import org.polarsys.capella.common.ui.toolkit.viewers.RegExpTreeViewer;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellamodeller.CapellamodellerPackage;
import org.polarsys.capella.core.ui.metric.MetricMessages;
import org.polarsys.capella.core.ui.metric.core.MetricTree;
import org.polarsys.capella.core.ui.metric.dialog.MetricContentProvider;
import org.polarsys.capella.core.ui.metric.dialog.MetricLabelProvider;

public class MetricDialog
extends AbstractExportDialog {
    protected String resourceName;
    private MetricLabelProvider labelProvider = new MetricLabelProvider();

    public MetricDialog(Shell parentShell, String title, String message, String shellTitle) {
        super(parentShell, title, message, shellTitle);
    }

    protected List<String[]> getExportableData() {
        List result = super.getExportableData(this.resourceName);
        ArrayList<MetricTree<EObject>> ses = new ArrayList<MetricTree<EObject>>();
        MetricTree data = (MetricTree)this.getData();
        EClass eRoot = ((EObject)data.getElement()).eClass();
        if (CapellacorePackage.Literals.MODELLING_ARCHITECTURE.isSuperTypeOf(eRoot)) {
            result.addAll(this.serializeLayerNodes(Collections.singletonList(data)));
        } else {
            if (eRoot == CapellamodellerPackage.Literals.PROJECT) {
                ses.addAll(data.getChildren());
            } else if (eRoot == CapellamodellerPackage.Literals.SYSTEM_ENGINEERING) {
                ses.add(data);
            }
            result.addAll(this.serializeSysEngNodes(ses));
        }
        return result;
    }

    private List<String[]> serializeSysEngNodes(List<MetricTree<EObject>> nodes) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (MetricTree<EObject> node : nodes) {
            result.add(IExportConstants.EXPORT_EMPTY_LINE);
            result.add(new String[]{String.valueOf(node.getElement().eClass().getName()) + ':' + this.labelProvider.getColumnText(node, 0)});
            result.add(IExportConstants.EXPORT_EMPTY_LINE);
            result.addAll(this.serializeLayerNodes(node.getChildren()));
        }
        return result;
    }

    private List<String[]> serializeLayerNodes(List<MetricTree<EObject>> nodes) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (MetricTree<EObject> node : nodes) {
            result.add(IExportConstants.EXPORT_EMPTY_LINE);
            result.add(new String[]{String.valueOf(MetricMessages.layer) + ':' + this.labelProvider.getColumnText(node, 0)});
            result.add(IExportConstants.EXPORT_EMPTY_LINE);
            for (MetricTree<EObject> node2 : node.getChildren()) {
                result.add(new String[]{this.labelProvider.getColumnText(node2, 0), Integer.toString(node2.getCount())});
            }
        }
        return result;
    }

    protected AbstractRegExpViewer createViewer(Composite parent) {
        RegExpTreeViewer treeViewer = new RegExpTreeViewer(parent);
        TreeViewer viewer = treeViewer.getClientViewer();
        TreeViewerColumn columnViewer = new TreeViewerColumn(viewer, 16384);
        TreeColumn column = columnViewer.getColumn();
        column.setText(MetricMessages.treeObjectColumnLabel);
        column.setWidth(300);
        ViewerComparator vc = new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int result = 0;
                MetricTree node1 = (MetricTree)e1;
                MetricTree node2 = (MetricTree)e2;
                if (!node1.hasChildren()) {
                    String lbl1 = MetricDialog.this.labelProvider.getColumnText(node1, 0);
                    String lbl2 = MetricDialog.this.labelProvider.getColumnText(node2, 0);
                    result = lbl1.compareTo(lbl2);
                }
                return result;
            }
        };
        viewer.setComparator(vc);
        columnViewer = new TreeViewerColumn(viewer, 16388);
        column = columnViewer.getColumn();
        column.setText(MetricMessages.treeResultColumnLabel);
        column.setWidth(70);
        viewer.getTree().setLinesVisible(true);
        viewer.getTree().setHeaderVisible(true);
        viewer.setContentProvider((IContentProvider)new MetricContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        return treeViewer;
    }

    public void setResourceName(String name) {
        this.resourceName = name;
    }
}

