/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.showhide;

import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ExchangeCategory;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.sirius.analysis.ABServices;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.FaServices;
import org.polarsys.capella.core.sirius.analysis.constants.MappingConstantsHelper;
import org.polarsys.capella.core.sirius.analysis.showhide.AbstractShowHide;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideFunctionalExchange;
import org.polarsys.capella.core.sirius.analysis.tool.HashMapSet;

public class ShowHideExchangeCategory
extends ShowHideFunctionalExchange {
    public static final String NO_SOURCE_PORT = "npo";
    public static final String NO_TARGET_PORT = "npo";
    public static final String SOURCE_PORTS = "sourcePorts";
    public static final String TARGET_PORTS = "targetPorts";

    public ShowHideExchangeCategory(DDiagramContents content) {
        super(content);
    }

    @Override
    protected boolean isValidNodeView(DDiagramElement semanticView, DSemanticDecorator containerView) {
        return super.isValidNodeView(semanticView, containerView);
    }

    @Override
    protected boolean isValidSemanticView(EObject semantic, DSemanticDecorator semanticView, AbstractShowHide.DiagramContext context) {
        return super.isValidSemanticView(semantic, semanticView, context);
    }

    @Override
    protected boolean mustHide(DDiagramElement view, AbstractShowHide.DiagramContext context) {
        EObject target;
        if (view.getDiagramElementMapping() instanceof AbstractNodeMapping && ((target = view.getTarget()) instanceof FunctionPort || target instanceof ExchangeCategory)) {
            BasicEList relatedEdges = new BasicEList();
            relatedEdges.addAll((Collection)((EdgeTarget)view).getIncomingEdges());
            relatedEdges.addAll((Collection)((EdgeTarget)view).getOutgoingEdges());
            for (DEdge edge : relatedEdges) {
                if (edge == null || edge.getTarget() instanceof FunctionalChain || !this.getContent().isVisible((DDiagramElement)edge)) continue;
                return false;
            }
            return true;
        }
        return super.mustHide(view, context);
    }

    @Override
    protected boolean mustShow(AbstractShowHide.ContextItemElement originCouple, AbstractShowHide.DiagramContext context, HashMapSet<String, DSemanticDecorator> relatedViews) {
        EObject semantic = originCouple.getValue();
        AbstractShowHide.ContextItemElement lastContext = context.getLast();
        if (semantic instanceof AbstractFunction || semantic instanceof Part || semantic instanceof Entity) {
            return false;
        }
        if (semantic instanceof ExchangeCategory) {
            AbstractFunction source = (AbstractFunction)((Collection)context.getLastVariable("sourceParts").getValue()).iterator().next();
            AbstractFunction target = (AbstractFunction)((Collection)context.getLastVariable("targetParts").getValue()).iterator().next();
            ExchangeCategory category = (ExchangeCategory)semantic;
            if ("source".equals(lastContext.getKey())) {
                return ABServices.getService().isSourceTargetCategoryFunction(source, target, category);
            }
            if ("target".equals(lastContext.getKey())) {
                return ABServices.getService().isSourceTargetCategoryFunction(source, target, category);
            }
            return ABServices.getService().isSourceTargetCategoryFunction(source, target, category);
        }
        return super.mustShow(originCouple, context, relatedViews);
    }

    @Override
    public HashMapSet<String, EObject> getRelatedObjects(EObject semantic, AbstractShowHide.DiagramContext context) {
        HashMapSet<String, EObject> value = super.getRelatedObjects(semantic, context);
        AbstractShowHide.ContextItemElement lastContext = context.getLast();
        if (lastContext.getValue() instanceof ExchangeCategory) {
            if ("source".equals(lastContext.getKey()) && lastContext.getValue() instanceof ExchangeCategory) {
                AbstractShowHide.ContextItemVariable variable = context.getLastVariable("sourceParts");
                EObject container = this.getContainer((AbstractFunction)((Collection)variable.getValue()).iterator().next());
                if (container != null) {
                    value.put("container", container);
                }
            } else if ("target".equals(lastContext.getKey()) && lastContext.getValue() instanceof ExchangeCategory) {
                AbstractShowHide.ContextItemVariable variable = context.getLastVariable("targetParts");
                EObject container = this.getContainer((AbstractFunction)((Collection)variable.getValue()).iterator().next());
                if (container != null) {
                    value.put("container", container);
                }
            } else {
                value.put("source", semantic);
                value.put("target", semantic);
            }
        }
        return value;
    }

    private EObject getContainer(AbstractFunction abstractFunction) {
        return FaServices.getBestFunctionContainer((EObject)abstractFunction, this.getContent());
    }

    @Override
    public DiagramElementMapping getMapping(EObject semantic, AbstractShowHide.DiagramContext context, HashMapSet<String, DSemanticDecorator> relatedViews) {
        DiagramElementMapping mapping = super.getMapping(semantic, context, relatedViews);
        AbstractShowHide.ContextItemElement lastContext = context.getLast();
        if (lastContext.getValue() instanceof ExchangeCategory) {
            if ("source".equals(lastContext.getKey())) {
                String mappingName = MappingConstantsHelper.getMappingFunctionalExchangeCategoryOutputPin(this.getContent().getDDiagram());
                mapping = this.getContent().getMapping(mappingName);
            } else if ("target".equals(lastContext.getKey())) {
                String mappingName = MappingConstantsHelper.getMappingFunctionalExchangeCategoryInputPin(this.getContent().getDDiagram());
                mapping = this.getContent().getMapping(mappingName);
            } else {
                String mappingName = MappingConstantsHelper.getMappingFunctionalExchangeCategory(this.getContent().getDDiagram());
                mapping = this.getContent().getMapping(mappingName);
            }
        }
        return mapping;
    }

    @Override
    protected boolean isValidEdgeView(DEdge edge, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        if (sourceView.equals(edge.getTargetNode()) && targetView.equals(edge.getSourceNode())) {
            String mappingName = MappingConstantsHelper.getMappingFunctionalExchangeCategory(this.getContent().getDDiagram());
            DiagramElementMapping categoryMapping = this.getContent().getMapping(mappingName);
            if (categoryMapping.equals(edge.getActualMapping())) {
                return true;
            }
        }
        return super.isValidEdgeView(edge, sourceView, targetView);
    }

    @Override
    protected Collection<DSemanticDecorator> retrieveDefaultContainer(EObject semantic, AbstractShowHide.DiagramContext context, Collection<DSemanticDecorator> targetViews) {
        return super.retrieveDefaultContainer(semantic, context, targetViews);
    }

    @Override
    protected boolean mustHide(AbstractShowHide.ContextItemElement originCouple, AbstractShowHide.DiagramContext context) {
        EObject semantic = originCouple.getValue();
        if (semantic instanceof AbstractFunction) {
            return false;
        }
        if (semantic instanceof FunctionalExchange) {
            return true;
        }
        if (semantic instanceof FunctionInputPort) {
            return true;
        }
        if (semantic instanceof FunctionOutputPort) {
            return true;
        }
        return semantic instanceof ExchangeCategory;
    }

    @Override
    protected boolean hideInsteadOfRemoveView(DDiagramElement element, AbstractShowHide.DiagramContext context) {
        EObject target = element.getTarget();
        if (target instanceof FunctionPort) {
            return this.getContent().getDDiagram().isSynchronized();
        }
        return super.hideInsteadOfRemoveView(element, context);
    }

    @Override
    protected Collection<DDiagramElement> showNodes(DSemanticDecorator containerView, EObject semantic, DDiagramContents content, AbstractNodeMapping mapping) {
        Collection<DDiagramElement> nodes = super.showNodes(containerView, semantic, content, mapping);
        if (semantic instanceof FunctionPort) {
            for (DDiagramElement element : nodes) {
                this.getContent().deferredShow(element);
            }
        }
        return nodes;
    }

    @Override
    protected Collection<DDiagramElement> showEdges(DSemanticDecorator source, DSemanticDecorator target, EObject exchange, DDiagramContents content, EdgeMapping edgeMapping) {
        Collection<DDiagramElement> nodes = super.showEdges(source, target, exchange, content, edgeMapping);
        if (exchange instanceof FunctionalExchange) {
            for (DDiagramElement element : nodes) {
                this.getContent().deferredShow(element);
            }
        }
        return nodes;
    }
}

