/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.queries.configurationItemServices;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.exceptions.QueryException;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.Feature;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.epbs.PhysicalArchitectureRealization;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.PhysicalArchitectureExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;

public class GetAllRealizablePhysicalArtefacts
extends AbstractQuery {
    public List<Object> execute(Object input_p, IQueryContext context_p) throws QueryException {
        ArrayList<Object> result = new ArrayList<Object>();
        ModelElement element = (ModelElement)input_p;
        BlockArchitecture arch = SystemEngineeringExt.getRootBlockArchitecture((ModelElement)element);
        if (arch == null) {
            return result;
        }
        if (arch instanceof EPBSArchitecture) {
            EList ownedPhysicalArchitectureRealizations = ((EPBSArchitecture)arch).getOwnedPhysicalArchitectureRealizations();
            for (PhysicalArchitectureRealization physicalArchitectureRealization : ownedPhysicalArchitectureRealizations) {
                BlockArchitecture allocatedArchitecture = physicalArchitectureRealization.getAllocatedArchitecture();
                if (allocatedArchitecture == null || !(allocatedArchitecture instanceof PhysicalArchitecture)) continue;
                Collection allPhysicalComponents = BlockArchitectureExt.getAllComponents((BlockArchitecture)((PhysicalArchitecture)allocatedArchitecture));
                result.addAll(allPhysicalComponents);
                for (Component physicalComponent : allPhysicalComponents) {
                    EList ownedFeatures = physicalComponent.getOwnedFeatures();
                    for (Feature feature : ownedFeatures) {
                        if (!(feature instanceof PhysicalPort)) continue;
                        result.add(feature);
                    }
                }
                List allPhysicalLinks = PhysicalArchitectureExt.getAllPhysicalLinks((PhysicalArchitecture)((PhysicalArchitecture)allocatedArchitecture));
                result.addAll(allPhysicalLinks);
            }
        }
        return result;
    }
}

