/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.cache;

import java.util.HashMap;
import java.util.Map;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.model.helpers.graph.InternalLinksGraph;
import org.polarsys.capella.core.model.helpers.graph.InvolvementGraph;

public class FunctionalChainCache {
    private static FunctionalChainCache instance;
    private Map<FunctionalChain, InvolvementGraph> involvmentGraphs = new HashMap<FunctionalChain, InvolvementGraph>();
    private Map<InvolvementGraph, InternalLinksGraph> internalLinksGraphs = new HashMap<InvolvementGraph, InternalLinksGraph>();

    public static FunctionalChainCache getInstance() {
        if (instance == null) {
            instance = new FunctionalChainCache();
        }
        return instance;
    }

    private FunctionalChainCache() {
    }

    public InvolvementGraph getInvolvementGraph(FunctionalChain chain) {
        return this.involvmentGraphs.computeIfAbsent(chain, InvolvementGraph::new);
    }

    public InternalLinksGraph getInternalLinksGraph(InvolvementGraph graph) {
        return this.internalLinksGraphs.computeIfAbsent(graph, InternalLinksGraph::new);
    }

    public void reset() {
        this.involvmentGraphs.clear();
        this.internalLinksGraphs.clear();
    }
}

