/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacommon.CapabilityRealizationInvolvement;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.interaction.RefinementLink;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.la.LaFactory;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;

public class LogicalServices {
    public List<TraceableElement> getRefinedRecursively(CapabilityRealization capabilityRealization_p) {
        ArrayList<TraceableElement> returnedList = new ArrayList<TraceableElement>();
        for (AbstractTrace aTrace : capabilityRealization_p.getIncomingTraces()) {
            if (!(aTrace instanceof RefinementLink) || aTrace.getSourceElement() == null) continue;
            returnedList.add(aTrace.getSourceElement());
            if (!(aTrace.getSourceElement() instanceof CapabilityRealization)) continue;
            returnedList.addAll(this.getRefinedRecursively((CapabilityRealization)aTrace.getSourceElement()));
        }
        return returnedList;
    }

    public List<RefinementLink> getRefinementTracesRecursively(CapabilityRealization capabilityRealization_p) {
        ArrayList<RefinementLink> returnedList = new ArrayList<RefinementLink>();
        for (AbstractTrace aTrace : capabilityRealization_p.getIncomingTraces()) {
            if (!(aTrace instanceof RefinementLink)) continue;
            returnedList.add((RefinementLink)aTrace);
            if (!(aTrace.getSourceElement() instanceof CapabilityRealization)) continue;
            returnedList.addAll(this.getRefinementTracesRecursively((CapabilityRealization)aTrace.getSourceElement()));
        }
        return returnedList;
    }

    public List<InvolvedElement> getSystemComponentInvolvmentOnRefinedRecursively(CapabilityRealization capabilityRealization_p) {
        ArrayList<InvolvedElement> returnedList = new ArrayList<InvolvedElement>();
        for (CapabilityRealizationInvolvement anInvolvement : capabilityRealization_p.getOwnedCapabilityRealizationInvolvements()) {
            if (anInvolvement.getInvolved() == null) continue;
            returnedList.add(anInvolvement.getInvolved());
        }
        for (AbstractTrace aTrace : capabilityRealization_p.getIncomingTraces()) {
            if (!(aTrace instanceof RefinementLink) || aTrace.getSourceElement() == null) continue;
            returnedList.addAll(this.getSystemComponentInvolvmentOnRefinedRecursively((CapabilityRealization)aTrace.getSourceElement()));
        }
        return returnedList;
    }

    public List<CapabilityRealizationInvolvement> getInvolvmentLinkOnRefinedRecursively(CapabilityRealization capabilityRealization_p) {
        ArrayList<CapabilityRealizationInvolvement> returnedList = new ArrayList<CapabilityRealizationInvolvement>();
        returnedList.addAll((Collection<CapabilityRealizationInvolvement>)capabilityRealization_p.getOwnedCapabilityRealizationInvolvements());
        for (AbstractTrace aTrace : capabilityRealization_p.getIncomingTraces()) {
            if (!(aTrace instanceof RefinementLink) || aTrace.getSourceElement() == null) continue;
            returnedList.addAll(this.getInvolvmentLinkOnRefinedRecursively((CapabilityRealization)aTrace.getSourceElement()));
        }
        return returnedList;
    }

    public LogicalComponent createLogicalComponent(EObject container) {
        LogicalComponent component = LaFactory.eINSTANCE.createLogicalComponent();
        if (component != null) {
            if (container instanceof LogicalComponent) {
                LogicalComponent componentContainer = (LogicalComponent)container;
                componentContainer.getOwnedLogicalComponents().add((Object)component);
            }
            CapellaServices.getService().creationService((EObject)component);
        }
        return component;
    }
}

