/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.handler.post.commit.listener;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.common.tools.api.util.SiriusCrossReferenceAdapter;
import org.polarsys.capella.common.data.helpers.modellingcore.utils.HoldingResourceFilter;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.ef.domain.AbstractEditingDomainResourceSetListenerImpl;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.common.platform.sirius.ted.SiriusSessionListener;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;

public class ProxyResolutionResourceSetListener
extends AbstractEditingDomainResourceSetListenerImpl {
    public boolean isPrecommitOnly() {
        return true;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        if (SiriusSessionListener.isClosingSession((EditingDomain)event.getEditingDomain())) {
            return null;
        }
        HashSet<EObject> toVisit = new HashSet<EObject>();
        for (Notification notification : event.getNotifications()) {
            if (notification.getFeature() instanceof EReference && !((EReference)notification.getFeature()).isContainment()) continue;
            EObject element = null;
            Object notifier = notification.getNotifier();
            if (notification.getEventType() == 3) {
                Object newValue = notification.getNewValue();
                if (notifier instanceof Resource) {
                    if (CapellaResourceHelper.isCapellaResource(notifier) && newValue instanceof EObject) {
                        element = (EObject)newValue;
                    }
                } else if (notifier instanceof ModelElement && notification.getFeature() instanceof EReference) {
                    element = (EObject)newValue;
                }
            } else if (notification.getEventType() == 4) {
                Object oldValue = notification.getOldValue();
                if (notifier instanceof Resource) {
                    if (CapellaResourceHelper.isCapellaResource(notifier) && oldValue instanceof EObject) {
                        element = (EObject)oldValue;
                    }
                } else if (notifier instanceof ModelElement && notification.getFeature() instanceof EReference) {
                    element = (EObject)oldValue;
                }
            }
            if (notification.getEventType() != 3 && notification.getEventType() != 4 || element == null || element.eResource() == null || HoldingResourceFilter.getInstance().isHoldByHoldingResource(element)) continue;
            toVisit.add(element);
        }
        HashSet<EObject> contents = new HashSet<EObject>();
        for (EObject object : toVisit) {
            if (contents.contains(object)) continue;
            contents.add(object);
            Resource resource = object.eResource();
            TreeIterator content = object.eAllContents();
            while (content.hasNext()) {
                EObject element = (EObject)content.next();
                if (element.eResource() != resource) continue;
                contents.add(element);
            }
        }
        toVisit.clear();
        SemanticEditingDomainFactory.SemanticEditingDomain editingDomain = (SemanticEditingDomainFactory.SemanticEditingDomain)TransactionHelper.getEditingDomain(contents);
        if (editingDomain != null) {
            SiriusCrossReferenceAdapter crossReferencer = editingDomain.getCrossReferencer();
            final HashMap<EObject, EObject> toChange = new HashMap<EObject, EObject>();
            for (EObject eObject : contents) {
                Collection inverseReferences = crossReferencer.getInverseReferences(eObject, false);
                for (EStructuralFeature.Setting setting : inverseReferences) {
                    Object e = setting.get(false);
                    if (e instanceof EObject && ((EObject)e).eIsProxy()) {
                        toChange.put((EObject)e, eObject);
                        continue;
                    }
                    if (!(e instanceof EList)) continue;
                    EList es = (EList)e;
                    for (Object ess : es) {
                        if (!(ess instanceof EObject) || !((EObject)ess).eIsProxy()) continue;
                        toChange.put((EObject)ess, eObject);
                    }
                }
            }
            contents.clear();
            if (!toChange.isEmpty()) {
                return new RecordingCommand((TransactionalEditingDomain)editingDomain){

                    protected void doExecute() {
                        for (EObject key : toChange.keySet()) {
                            ProxyResolutionResourceSetListener.this.updateProxyURI(key, (EObject)toChange.get(key));
                        }
                    }
                };
            }
        }
        return null;
    }

    protected void updateProxyURI(EObject proxy_p, EObject element_p) {
        if (proxy_p instanceof InternalEObject) {
            String fragment;
            String id = EcoreUtil.getID((EObject)element_p);
            InternalEObject a = (InternalEObject)proxy_p;
            URI proxyUri = a.eProxyURI();
            if (proxyUri != null && (fragment = proxyUri.fragment()) != null && fragment.equals(id)) {
                URI uri = element_p.eResource().getURI().appendFragment(id);
                a.eSetProxyURI(uri);
            }
        }
    }
}

