/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.genchain.tools.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.portfolio.genchain.tools.Activator;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundlePluginModel;
import org.eclipse.pde.internal.core.feature.FeaturePlugin;
import org.eclipse.pde.internal.core.feature.WorkspaceFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.ui.wizards.feature.CreateFeatureProjectOperation;
import org.eclipse.pde.internal.ui.wizards.feature.FeatureData;

public class FeatureHelper {
    public static final String VERSION = "1.0.0.qualifier";
    private static final Path PLUGIN_PATH = new Path("/plugin.xml");
    private static final Path METAFEST_PATH = new Path("/META-INF/MANIFEST.MF");
    private static final IWorkspaceRoot ROOT = ResourcesPlugin.getWorkspace().getRoot();

    public static IProject createFeatureProject(Collection<String> includedFeatureList, Collection<String> pluginList, String id, String name, IProgressMonitor monitor) throws CoreException {
        IPluginBase[] pluginBase = FeatureHelper.getPluginBase(pluginList);
        FeatureData featureData = FeatureHelper.getFeatureData(id, name);
        IProject projectF = ROOT.getProject(featureData.id);
        MyCreateFeatureProjectOperation operation = new MyCreateFeatureProjectOperation(projectF, ROOT.getLocation(), featureData, pluginBase, new ArrayList<String>(includedFeatureList));
        try {
            operation.run(monitor);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getPluginID(), e.getMessage(), (Throwable)e));
        }
        return projectF;
    }

    private static IPluginBase[] getPluginBase(Collection<String> pluginList) {
        if (pluginList != null && pluginList.size() > 0) {
            int size = pluginList.size();
            IPluginBase[] result = new IPluginBase[size];
            size = 0;
            for (String id : pluginList) {
                result[size++] = FeatureHelper.getPluginBase(id);
            }
            return result;
        }
        return null;
    }

    private static IPluginBase getPluginBase(String pluginName) {
        IProject project = ROOT.getProject(pluginName);
        IFile manifestFile = project.getFile((IPath)METAFEST_PATH);
        IFile pluginFile = project.getFile((IPath)PLUGIN_PATH);
        WorkspaceBundlePluginModel model = new WorkspaceBundlePluginModel(manifestFile, pluginFile);
        IPluginBase pluginBase = model.getPluginBase();
        return pluginBase;
    }

    private static FeatureData getFeatureData(String id, String name) {
        FeatureData featureData = new FeatureData();
        featureData.id = String.valueOf(id) + ".feature";
        featureData.name = String.valueOf(name) + " Feature";
        IProject fproject = ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(id) + ".feature");
        featureData.version = FeatureHelper.getFeatureProjectVersion(fproject);
        return featureData;
    }

    private static String getFeatureProjectVersion(IProject fproject) {
        String version = VERSION;
        if (fproject.exists()) {
            WorkspaceFeatureModel model = null;
            try {
                try {
                    IFile file = PDEProject.getFeatureXml((IProject)fproject);
                    file.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                    model = new WorkspaceFeatureModel(file);
                    model.load();
                    IFeature feature = model.getFeature();
                    version = feature.getVersion();
                }
                catch (Exception exception) {
                    if (model != null) {
                        model.dispose();
                    }
                }
            }
            finally {
                if (model != null) {
                    model.dispose();
                }
            }
        }
        return version;
    }

    private static class MyCreateFeatureProjectOperation
    extends CreateFeatureProjectOperation {
        private List<String> includedFeatureList;

        public MyCreateFeatureProjectOperation(IProject project, IPath location, FeatureData featureData, IPluginBase[] plugins, List<String> includedFeatureList) {
            super(project, location, featureData, plugins, null);
            this.includedFeatureList = includedFeatureList;
        }

        protected void configureFeature(IFeature feature, WorkspaceFeatureModel model) throws CoreException {
            IFeaturePlugin[] added = new IFeaturePlugin[this.fPlugins.length];
            int i = 0;
            while (i < this.fPlugins.length) {
                IPluginBase plugin = this.fPlugins[i];
                FeaturePlugin fplugin = (FeaturePlugin)model.getFactory().createPlugin();
                fplugin.loadFrom(plugin);
                fplugin.setVersion("0.0.0");
                fplugin.setUnpack(false);
                added[i] = fplugin;
                ++i;
            }
            feature.addPlugins(added);
            IFeatureChild[] features = new IFeatureChild[this.includedFeatureList.size()];
            int i2 = 0;
            while (i2 < this.includedFeatureList.size()) {
                IFeatureChild child = model.getFactory().createChild();
                child.setId(this.includedFeatureList.get(i2));
                child.setVersion("0.0.0");
                features[i2] = child;
                ++i2;
            }
            feature.addIncludedFeatures(features);
        }

        protected void openFeatureEditor(IFile manifestFile) {
        }

        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
            if (this.fProject.exists()) {
                this.fProject.delete(true, monitor);
            }
            super.execute(monitor);
        }

        protected boolean shouldOverwriteFeature() {
            return true;
        }
    }
}

