/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.genchain.tools.ui.actions;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.core.domain.EgfResourceSet;
import org.eclipse.egf.core.pde.tools.ConvertProjectOperation;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.domain.emf.EMFDomainHelper;
import org.eclipse.egf.model.domain.Domain;
import org.eclipse.egf.model.domain.DomainFactory;
import org.eclipse.egf.model.domain.EMFDomain;
import org.eclipse.egf.model.domain.TypeDomain;
import org.eclipse.egf.model.domain.util.DomainSwitch;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.FactoryComponent;
import org.eclipse.egf.model.pattern.Substitution;
import org.eclipse.egf.model.pattern.TypePatternSubstitution;
import org.eclipse.egf.model.types.TypeString;
import org.eclipse.egf.portfolio.genchain.extension.ExtensionHelper;
import org.eclipse.egf.portfolio.genchain.generationChain.FeatureAddition;
import org.eclipse.egf.portfolio.genchain.generationChain.GenerationChain;
import org.eclipse.egf.portfolio.genchain.generationChain.PluginProvider;
import org.eclipse.egf.portfolio.genchain.generationChain.util.GenerationChainSwitch;
import org.eclipse.egf.portfolio.genchain.tools.Activator;
import org.eclipse.egf.portfolio.genchain.tools.ui.Messages;
import org.eclipse.egf.portfolio.genchain.tools.ui.actions.FeatureHelper;
import org.eclipse.egf.portfolio.genchain.tools.utils.RunActivityHelper;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.internal.editors.text.WorkspaceOperationRunner;

public class CreateFcoreHelper {
    private static final String ORG_ECLIPSE_PDE_PLUGIN_NATURE = "org.eclipse.pde.PluginNature";
    public static final CreateFcoreHelper INSTANCE = new CreateFcoreHelper();
    private static final URI GENERATOR_URI = URI.createURI((String)"platform:/plugin/org.eclipse.egf.portfolio.genchain.tools/egf/Generation_Chain_Producer.fcore#_6qO2EYhGEd-Ii9WHGzCGHg");

    public WorkspaceJob createJob(final GenerationChain generationChain, final boolean run) {
        final String fcoreOutputPath = this.computeFcoreOutputPath(generationChain);
        final WorkspaceJob beforeJob = this.createBeforeJob();
        final WorkspaceJob afterJob = this.createAfterJob();
        final WorkspaceJob runJob = new WorkspaceJob(Messages.genchain_run_action_label){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    EgfResourceSet set = new EgfResourceSet();
                    CreateFcoreHelper.this.runFcore((ResourceSet)set, generationChain, fcoreOutputPath, monitor);
                    CreateFcoreHelper.this.generateFeaturePlugin((ResourceSet)set, generationChain, monitor);
                    if (afterJob != null) {
                        afterJob.schedule(1000L);
                    }
                }
                catch (CoreException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(4, Activator.getDefault().getPluginID(), e.getMessage(), (Throwable)e));
                }
                return Status.OK_STATUS;
            }
        };
        final WorkspaceJob buildJob = new WorkspaceJob(Messages.genchain_generate_action_label){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    CreateFcoreHelper.this.createFcore(generationChain, fcoreOutputPath, monitor);
                    if (run) {
                        runJob.schedule(1000L);
                    }
                }
                catch (CoreException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(4, Activator.getDefault().getPluginID(), e.getMessage(), (Throwable)e));
                }
                return Status.OK_STATUS;
            }
        };
        WorkspaceJob setupJob = new WorkspaceJob(Messages.genchain_generate_action_label){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    if (beforeJob != null) {
                        beforeJob.schedule();
                        beforeJob.join();
                    }
                    CreateFcoreHelper.this.setupProject(generationChain.getFactoryComponentName(), CreateFcoreHelper.this.computeFcoreRelativePath(generationChain));
                    buildJob.schedule(1000L);
                }
                catch (CoreException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(4, Activator.getDefault().getPluginID(), e.getMessage(), (Throwable)e));
                }
                return Status.OK_STATUS;
            }
        };
        return setupJob;
    }

    public WorkspaceJob createBeforeJob() {
        return null;
    }

    public WorkspaceJob createAfterJob() {
        return null;
    }

    public WorkspaceJob createJob(URI fcoreURI, boolean run) {
        EgfResourceSet resourceSet = new EgfResourceSet();
        GenerationChain generationChain = (GenerationChain)resourceSet.getResource(fcoreURI, true).getContents().get(0);
        return this.createJob(generationChain, run);
    }

    protected String computeFcoreOutputPath(GenerationChain generationChain) {
        return String.valueOf(generationChain.getFactoryComponentName()) + this.computeFcoreRelativePath(generationChain);
    }

    protected String computeFcoreRelativePath(GenerationChain generationChain) {
        return "/model/" + generationChain.getName() + ".fcore";
    }

    public void setupProject(String projectName, String fcorePath) throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists()) {
            project.create(null);
        }
        project.open(null);
        WorkspaceOperationRunner runner = new WorkspaceOperationRunner();
        runner.setProgressMonitor(null);
        try {
            runner.run(true, false, (IRunnableWithProgress)new ConvertProjectOperation(project, false, false));
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getPluginID(), e.getMessage(), (Throwable)e));
        }
    }

    protected void createFcore(GenerationChain generationChain, String fcoreOutputPath, IProgressMonitor monitor) throws CoreException {
        FactoryComponent fc = (FactoryComponent)new EgfResourceSet().getEObject(this.getGeneratorURI(), true);
        EMFDomain domain = DomainFactory.eINSTANCE.createEMFDomain();
        URI uri = generationChain.eResource().getURI();
        domain.setUri(uri);
        ((TypePatternSubstitution)fc.getContract("pattern substitutions").getType()).getSubstitutions().addAll(this.computeSubstitutions());
        ((TypeDomain)fc.getContract("genChain model").getType()).setDomain((Domain)domain);
        ((TypeString)fc.getContract("generation plugin name").getType()).setValue(generationChain.getFactoryComponentName());
        ((TypeString)fc.getContract("model name").getType()).setValue(generationChain.getName());
        ((TypeString)fc.getContract("fcore output path").getType()).setValue(fcoreOutputPath);
        EMFDomainHelper helper = new EMFDomainHelper();
        try {
            try {
                if (helper.loadDomain((Domain)domain)) {
                    RunActivityHelper.run((Activity)fc, (IProgressMonitor)monitor);
                }
            }
            finally {
                helper.unLoadDomain((Domain)domain);
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getPluginID(), e.getMessage(), (Throwable)e));
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(generationChain.getFactoryComponentName());
        if (project != null && project.exists()) {
            project.refreshLocal(2, monitor);
        }
    }

    protected void runFcore(ResourceSet resourceSet, GenerationChain generationChain, String fcoreOutputPath, IProgressMonitor monitor) throws CoreException {
        URI uri = URI.createPlatformPluginURI((String)fcoreOutputPath, (boolean)false);
        EObject eObject = (EObject)resourceSet.getResource(uri, true).getContents().get(0);
        try {
            RunActivityHelper.run((Activity)((Activity)eObject), (IProgressMonitor)monitor);
        }
        catch (InvocationException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getPluginID(), e.getMessage(), (Throwable)e));
        }
    }

    protected void generateFeaturePlugin(ResourceSet resourceSet, GenerationChain generationChain, IProgressMonitor monitor) throws CoreException {
        final HashSet<String> pluginList = new HashSet<String>();
        final HashSet<String> includedFeatureList = new HashSet<String>();
        String fcPath = this.computeFcoreOutputPath(generationChain);
        final EList<EObject> collectDomains = this.collectDomains(resourceSet, fcPath);
        String pluginName = generationChain.getFactoryComponentName();
        URI uri = generationChain.eResource().getURI();
        pluginList.add(uri.segment(1));
        new GenerationChainSwitch<Object>(){

            protected Object doSwitch(EClass theEClass, EObject theEObject) {
                if (theEClass.eContainer() == modelPackage) {
                    return this.doSwitch(theEClass.getClassifierID(), theEObject);
                }
                EList eSuperTypes = theEClass.getESuperTypes();
                if (eSuperTypes.isEmpty()) {
                    return this.defaultCase(theEObject);
                }
                for (EClass superType : eSuperTypes) {
                    Object doSwitch = this.doSwitch(superType, theEObject);
                    if (doSwitch == null) continue;
                    return doSwitch;
                }
                return null;
            }

            public Object caseGenerationChain(GenerationChain object) {
                for (EObject obj : object.getElements()) {
                    this.doSwitch(obj);
                }
                return this;
            }

            public Object casePluginProvider(PluginProvider object) {
                pluginList.addAll(object.getPluginNames(collectDomains));
                return this;
            }

            public Object caseFeatureAddition(FeatureAddition addition) {
                for (String projectName : addition.getAdditions()) {
                    includedFeatureList.add(projectName);
                }
                return this;
            }
        }.doSwitch((EObject)generationChain);
        for (String pluginNameString : pluginList) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(pluginNameString);
            if (!project.exists() || project.hasNature(ORG_ECLIPSE_PDE_PLUGIN_NATURE)) continue;
            WorkspaceOperationRunner runner = new WorkspaceOperationRunner();
            runner.setProgressMonitor(null);
            try {
                runner.run(true, false, (IRunnableWithProgress)new ConvertProjectOperation(project, false, false));
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, Activator.getDefault().getPluginID(), e.getMessage(), (Throwable)e));
            }
        }
        IProject projectF = FeatureHelper.createFeatureProject(includedFeatureList, pluginList, pluginName, generationChain.getName(), monitor);
        if (projectF != null && projectF.exists()) {
            projectF.refreshLocal(2, monitor);
        }
    }

    private EList<EObject> collectDomains(ResourceSet resourceSet, String fcPath) {
        BasicEList result = new BasicEList();
        DomainSwitch<Object> _switch = new DomainSwitch<Object>((EList)result, resourceSet){
            private final /* synthetic */ EList val$result;
            private final /* synthetic */ ResourceSet val$resourceSet;
            {
                this.val$result = eList;
                this.val$resourceSet = resourceSet;
            }

            public Object caseEMFDomain(EMFDomain object) {
                this.val$result.add((Object)((EObject)this.val$resourceSet.getResource(object.getUri(), true).getContents().get(0)));
                return this;
            }

            public Object defaultCase(EObject object) {
                for (EObject obj : object.eContents()) {
                    this.doSwitch(obj);
                }
                return null;
            }
        };
        for (EObject obj : resourceSet.getResource(URI.createPlatformPluginURI((String)fcPath, (boolean)false), true).getContents()) {
            _switch.doSwitch(obj);
        }
        return result;
    }

    protected List<Substitution> computeSubstitutions() {
        return ExtensionHelper.getAllSubstitutions();
    }

    protected URI getGeneratorURI() {
        return GENERATOR_URI;
    }
}

